/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.project.ProjectInternal;

public class BasePluginConvention {
    private ProjectInternal project;
    private String distsDirName;
    private String libsDirName;
    private File buildDir;
    private File libsDir;
    private File distsDir;
    private String archivesBaseName;

    public BasePluginConvention(Project project) {
        this.project = (ProjectInternal)project;
        this.archivesBaseName = project.getName();
        this.distsDirName = "distributions";
        this.libsDirName = "libs";
    }

    public File getDistsDir() {
        File dir;
        File curProjectBuildDir = this.project.getBuildDir();
        if (this.distsDir != null && curProjectBuildDir.equals(this.buildDir)) {
            return this.distsDir;
        }
        this.buildDir = curProjectBuildDir;
        this.distsDir = dir = ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(curProjectBuildDir).resolve((Object)this.distsDirName);
        return dir;
    }

    public File getLibsDir() {
        File dir;
        File curProjectBuildDir = this.project.getBuildDir();
        if (this.libsDir != null && curProjectBuildDir.equals(this.buildDir)) {
            return this.libsDir;
        }
        this.buildDir = curProjectBuildDir;
        this.libsDir = dir = ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(curProjectBuildDir).resolve((Object)this.libsDirName);
        return dir;
    }

    public ProjectInternal getProject() {
        return this.project;
    }

    public void setProject(ProjectInternal project) {
        this.project = project;
    }

    public String getDistsDirName() {
        return this.distsDirName;
    }

    public void setDistsDirName(String distsDirName) {
        this.distsDirName = distsDirName;
        this.distsDir = null;
    }

    public String getLibsDirName() {
        return this.libsDirName;
    }

    public void setLibsDirName(String libsDirName) {
        this.libsDirName = libsDirName;
        this.libsDir = null;
    }

    public String getArchivesBaseName() {
        return this.archivesBaseName;
    }

    public void setArchivesBaseName(String archivesBaseName) {
        this.archivesBaseName = archivesBaseName;
    }
}

