/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.provider;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.PercentageProgressFormatter;
import org.gradle.kotlin.dsl.provider.JarGenerationProgressMonitorProvider;
import org.gradle.kotlin.dsl.support.ProgressMonitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/gradle/kotlin/dsl/provider/StandardJarGenerationProgressMonitorProvider;", "Lorg/gradle/kotlin/dsl/provider/JarGenerationProgressMonitorProvider;", "progressLoggerFactory", "Lorg/gradle/internal/logging/progress/ProgressLoggerFactory;", "(Lorg/gradle/internal/logging/progress/ProgressLoggerFactory;)V", "getProgressLoggerFactory", "()Lorg/gradle/internal/logging/progress/ProgressLoggerFactory;", "progressLoggerFor", "Lorg/gradle/internal/logging/progress/ProgressLogger;", "outputJar", "Ljava/io/File;", "progressMonitorFor", "Lorg/gradle/kotlin/dsl/support/ProgressMonitor;", "totalWork", "", "gradle-kotlin-dsl"})
public final class StandardJarGenerationProgressMonitorProvider
implements JarGenerationProgressMonitorProvider {
    @NotNull
    private final ProgressLoggerFactory progressLoggerFactory;

    @Override
    @NotNull
    public ProgressMonitor progressMonitorFor(@NotNull File outputJar, int totalWork) {
        Intrinsics.checkParameterIsNotNull((Object)outputJar, (String)"outputJar");
        ProgressLogger progressLogger = this.progressLoggerFor(outputJar);
        PercentageProgressFormatter progressFormatter = new PercentageProgressFormatter("Generating", totalWork);
        return new ProgressMonitor(progressLogger, progressFormatter){
            final /* synthetic */ ProgressLogger $progressLogger;
            final /* synthetic */ PercentageProgressFormatter $progressFormatter;

            public void onProgress() {
                this.$progressLogger.progress(this.$progressFormatter.incrementAndGetProgress());
            }

            public void close() {
                this.$progressLogger.completed();
            }
            {
                this.$progressLogger = $captured_local_variable$0;
                this.$progressFormatter = $captured_local_variable$1;
            }
        };
    }

    private final ProgressLogger progressLoggerFor(File outputJar) {
        ProgressLogger progressLogger;
        ProgressLogger $receiver = progressLogger = this.progressLoggerFactory.newOperation(JarGenerationProgressMonitorProvider.class);
        $receiver.setDescription("Gradle Kotlin DSL JARs generation");
        $receiver.setLoggingHeader("Generating JAR file '" + outputJar.getName() + '\'');
        $receiver.started();
        ProgressLogger progressLogger2 = progressLogger;
        Intrinsics.checkExpressionValueIsNotNull((Object)progressLogger2, (String)"progressLoggerFactory.ne\u2026      started()\n        }");
        return progressLogger2;
    }

    @NotNull
    public final ProgressLoggerFactory getProgressLoggerFactory() {
        return this.progressLoggerFactory;
    }

    public StandardJarGenerationProgressMonitorProvider(@NotNull ProgressLoggerFactory progressLoggerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)progressLoggerFactory, (String)"progressLoggerFactory");
        this.progressLoggerFactory = progressLoggerFactory;
    }
}

