/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.BS;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.renderbio.RocketsRenderer;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class RocketRenderer {
    private boolean tPending;
    private ProteinStructure proteinstructurePending;
    private int startIndexPending;
    private int endIndexPending;
    private V3 vtemp;
    private P3 screenA;
    private P3 screenB;
    private P3 screenC;
    private short colix;
    private short mad;
    private RocketsRenderer rr;
    private Viewer vwr;
    private JmolRendererInterface g3d;
    private TransformManager tm;
    private boolean renderArrowHeads;
    private boolean isRockets;
    private static final int[][] boxFaces = new int[][]{{0, 1, 3, 2}, {0, 2, 6, 4}, {0, 4, 5, 1}, {7, 5, 4, 6}, {7, 6, 2, 3}, {7, 3, 1, 5}};
    private static final int[][] arrowHeadFaces = new int[][]{{1, 0, 4}, {2, 3, 5}, {0, 1, 3, 2}, {2, 5, 4, 0}, {1, 4, 5, 3}};
    private P3 ptC;
    private P3 ptTip;
    private P3[] corners;
    private P3[] screenCorners;
    private V3 vW;
    private V3 vH;
    private MeshSurface meshSurface;

    RocketRenderer set(RocketsRenderer rr) {
        this.screenA = new P3();
        this.screenB = new P3();
        this.screenC = new P3();
        this.vtemp = new V3();
        this.rr = rr;
        this.vwr = rr.vwr;
        this.tm = rr.vwr.tm;
        this.isRockets = rr.isRockets;
        return this;
    }

    void renderRockets() {
        this.g3d = this.rr.g3d;
        this.tPending = false;
        this.renderArrowHeads = this.rr.renderArrowHeads;
        BS bsVisible = this.rr.bsVisible;
        int i = bsVisible.nextSetBit(0);
        while (i >= 0) {
            if (this.rr.structureTypes[i] == STR.HELIX || this.isRockets && this.rr.structureTypes[i] == STR.SHEET) {
                this.renderSpecialSegment((AlphaMonomer)this.rr.monomers[i], this.rr.getLeadColix(i), this.rr.mads[i]);
            } else if (this.isRockets) {
                this.renderPending();
                this.rr.renderHermiteConic(i, true, 7);
            }
            i = bsVisible.nextSetBit(i + 1);
        }
        this.renderPending();
    }

    private void renderSpecialSegment(AlphaMonomer monomer, short thisColix, short thisMad) {
        ProteinStructure proteinstructure = monomer.proteinStructure;
        if (this.tPending) {
            if (proteinstructure == this.proteinstructurePending && thisMad == this.mad && thisColix == this.colix && proteinstructure.getIndex(monomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPending();
        }
        this.proteinstructurePending = proteinstructure;
        this.startIndexPending = this.endIndexPending = proteinstructure.getIndex(monomer);
        this.colix = thisColix;
        this.mad = thisMad;
        this.tPending = true;
    }

    private void renderPending() {
        boolean renderArrowHead;
        if (!this.tPending) {
            return;
        }
        P3[] segments = this.proteinstructurePending.getSegments();
        boolean bl = renderArrowHead = this.renderArrowHeads && this.endIndexPending == this.proteinstructurePending.nRes - 1;
        if (this.proteinstructurePending instanceof Helix) {
            this.renderPendingRocketSegment(this.endIndexPending, segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], renderArrowHead);
        } else if (this.proteinstructurePending instanceof Sheet && ((Sheet)this.proteinstructurePending).apolymer instanceof AminoPolymer) {
            this.renderPendingSheetPlank(segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], renderArrowHead);
        }
        this.tPending = false;
    }

    private void renderPendingRocketSegment(int i, P3 pointStart, P3 pointBeforeEnd, P3 pointEnd, boolean renderArrowHead) {
        if (this.g3d.setC(this.colix)) {
            this.tm.transformPt3f((T3)pointStart, this.screenA);
            this.tm.transformPt3f((T3)(renderArrowHead ? pointBeforeEnd : pointEnd), this.screenB);
            int zMid = (int)Math.floor((this.screenA.z + this.screenB.z) / 2.0f);
            int diameter = (int)this.vwr.tm.scaleToScreen(zMid, (int)this.mad);
            if (!renderArrowHead || pointStart != pointBeforeEnd) {
                this.g3d.fillCylinderBits((byte)2, diameter, this.screenA, this.screenB);
            }
            if (renderArrowHead) {
                this.screenA.sub2((T3)pointEnd, (T3)pointBeforeEnd);
                this.tm.transformPt3f((T3)pointEnd, this.screenC);
                int coneDiameter = (this.mad << 1) - (this.mad >> 1);
                coneDiameter = (int)this.vwr.tm.scaleToScreen((int)Math.floor(this.screenB.z), coneDiameter);
                this.g3d.fillConeScreen3f((byte)2, coneDiameter, this.screenB, this.screenC, false);
            }
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            P3 t = this.screenB;
            this.screenB = this.screenC;
            this.screenC = t;
        }
    }

    private void renderPendingSheetPlank(P3 ptStart, P3 pointBeforeEnd, P3 ptEnd, boolean renderArrowHead) {
        int i;
        if (!this.g3d.setC(this.colix)) {
            return;
        }
        if (this.corners == null) {
            this.ptC = new P3();
            this.ptTip = new P3();
            this.vW = new V3();
            this.vH = new V3();
            this.screenCorners = new P3[8];
            this.corners = new P3[8];
            i = 8;
            while (--i >= 0) {
                this.corners[i] = new P3();
                this.screenCorners[i] = new P3();
            }
        }
        if (renderArrowHead) {
            this.setBox(1.25f, 0.333f, pointBeforeEnd);
            this.ptTip.scaleAdd2(-0.5f, (T3)this.vH, (T3)ptEnd);
            i = 4;
            while (--i >= 0) {
                P3 corner = this.corners[i];
                corner.setT((T3)this.ptC);
                if ((i & 1) != 0) {
                    corner.add((T3)this.vW);
                }
                if ((i & 2) == 0) continue;
                corner.add((T3)this.vH);
            }
            this.corners[4].setT((T3)this.ptTip);
            this.corners[5].add2((T3)this.ptTip, (T3)this.vH);
            this.renderPart(arrowHeadFaces);
            ptEnd = pointBeforeEnd;
        }
        this.setBox(1.0f, 0.25f, ptStart);
        this.vtemp.sub2((T3)ptEnd, (T3)ptStart);
        if (this.vtemp.lengthSquared() == 0.0f) {
            return;
        }
        this.buildBox(this.ptC, this.vW, this.vH, this.vtemp);
        this.renderPart(boxFaces);
    }

    private void setBox(float w, float h, P3 pt) {
        ((Sheet)this.proteinstructurePending).setBox(w, h, pt, this.vW, this.vH, this.ptC, (float)this.mad / 1000.0f);
    }

    private void buildBox(P3 pointCorner, V3 scaledWidthVector, V3 scaledHeightVector, V3 lengthVector) {
        int i = 8;
        while (--i >= 0) {
            P3 corner = this.corners[i];
            corner.setT((T3)pointCorner);
            if ((i & 1) != 0) {
                corner.add((T3)scaledWidthVector);
            }
            if ((i & 2) != 0) {
                corner.add((T3)scaledHeightVector);
            }
            if ((i & 4) == 0) continue;
            corner.add((T3)lengthVector);
        }
    }

    private void renderPart(int[][] planes) {
        if (this.rr.exportType == 1) {
            if (this.meshSurface == null) {
                this.meshSurface = new MeshSurface();
                this.meshSurface.vs = this.corners;
                this.meshSurface.haveQuads = true;
                this.meshSurface.vc = this.corners.length;
            }
            this.meshSurface.pis = planes;
            this.meshSurface.pc = planes.length;
            this.g3d.drawSurface(this.meshSurface, this.colix);
        } else {
            int i = 8;
            while (--i >= 0) {
                this.tm.transformPt3f((T3)this.corners[i], this.screenCorners[i]);
            }
            i = planes.length;
            while (--i >= 0) {
                int[] f = planes[i];
                if (f.length == 3) {
                    this.g3d.fillTriangle3f(this.screenCorners[f[0]], this.screenCorners[f[1]], this.screenCorners[f[2]], true);
                    continue;
                }
                this.g3d.fillQuadrilateral(this.screenCorners[f[0]], this.screenCorners[f[1]], this.screenCorners[f[2]], this.screenCorners[f[3]], true);
            }
        }
    }
}

