/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class MapMover
extends MouseAdapter
implements Destroyable {
    public static final BooleanProperty PROP_ZOOM_REVERSE_WHEEL = new BooleanProperty("zoom.reverse-wheel", false);
    private MapViewState.MapViewPoint mousePosMoveStart;
    private final NavigatableComponent nc;
    private final ArrayList<Pair<ZoomerAction, Shortcut>> registeredShortcuts = new ArrayList();

    public MapMover(NavigatableComponent navComp) {
        this.nc = navComp;
        this.nc.addMouseListener(this);
        this.nc.addMouseMotionListener(this);
        this.nc.addMouseWheelListener(this);
        this.registerActionShortcut(new ZoomerAction("right"), Shortcut.registerShortcut("system:movefocusright", I18n.tr("Map: {0}", I18n.tr("Move right", new Object[0])), 39, 5006));
        this.registerActionShortcut(new ZoomerAction("left"), Shortcut.registerShortcut("system:movefocusleft", I18n.tr("Map: {0}", I18n.tr("Move left", new Object[0])), 37, 5006));
        this.registerActionShortcut(new ZoomerAction("up"), Shortcut.registerShortcut("system:movefocusup", I18n.tr("Map: {0}", I18n.tr("Move up", new Object[0])), 38, 5006));
        this.registerActionShortcut(new ZoomerAction("down"), Shortcut.registerShortcut("system:movefocusdown", I18n.tr("Map: {0}", I18n.tr("Move down", new Object[0])), 40, 5006));
        if (!Main.isPlatformOsx()) {
            this.registerActionShortcut(new ZoomerAction(",", "MapMover.Zoomer.in"), Shortcut.registerShortcut("view:zoominalternate", I18n.tr("Map: {0}", I18n.tr("Zoom In", new Object[0])), 44, 5006));
            this.registerActionShortcut(new ZoomerAction(".", "MapMover.Zoomer.out"), Shortcut.registerShortcut("view:zoomoutalternate", I18n.tr("Map: {0}", I18n.tr("Zoom Out", new Object[0])), 46, 5006));
        }
    }

    private void registerActionShortcut(ZoomerAction action, Shortcut shortcut) {
        MainApplication.registerActionShortcut(action, shortcut);
        this.registeredShortcuts.add(new Pair<ZoomerAction, Shortcut>(action, shortcut));
    }

    public boolean movementInProgress() {
        return this.mousePosMoveStart != null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean allowMovement;
        int offMask = 3072;
        boolean bl = allowMovement = (e.getModifiersEx() & (0x1000 | offMask)) == 4096;
        if (Main.isPlatformOsx()) {
            MapFrame map = MainApplication.getMap();
            int macMouseMask = 1152;
            boolean macMovement = e.getModifiersEx() == macMouseMask;
            boolean allowedMode = !map.mapModeSelect.equals(map.mapMode) || SelectAction.Mode.SELECT.equals((Object)map.mapModeSelect.getMode());
            allowMovement |= macMovement && allowedMode;
        }
        if (allowMovement) {
            this.doMoveForDrag(e);
        } else {
            this.endMovement();
        }
    }

    private void doMoveForDrag(MouseEvent e) {
        if (!this.movementInProgress()) {
            this.startMovement(e);
        }
        EastNorth center = this.nc.getCenter();
        EastNorth mouseCenter = this.nc.getEastNorth(e.getX(), e.getY());
        this.nc.zoomTo(this.mousePosMoveStart.getEastNorth().add(center).subtract(mouseCenter));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int offMask = 3072;
        int macMouseMask = 1152;
        if (e.getButton() == 3 && (e.getModifiersEx() & offMask) == 0 || Main.isPlatformOsx() && e.getModifiersEx() == macMouseMask) {
            this.startMovement(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3 || Main.isPlatformOsx() && e.getButton() == 1) {
            this.endMovement();
        }
    }

    private void startMovement(MouseEvent e) {
        if (this.movementInProgress()) {
            return;
        }
        this.mousePosMoveStart = this.nc.getState().getForView(e.getX(), e.getY());
        this.nc.setNewCursor(13, (Object)this);
    }

    private void endMovement() {
        if (!this.movementInProgress()) {
            return;
        }
        this.nc.resetCursor(this);
        this.mousePosMoveStart = null;
        MainApplication.getLayerManager().getLayers().forEach(AbstractMapViewPaintable::invalidate);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotation = PROP_ZOOM_REVERSE_WHEEL.get() != false ? -e.getWheelRotation() : e.getWheelRotation();
        this.nc.zoomManyTimes(e.getX(), e.getY(), rotation);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.movementInProgress()) {
            return;
        }
        if (Main.isPlatformOsx()) {
            if (e.getModifiersEx() == 128) {
                this.doMoveForDrag(e);
            } else {
                this.endMovement();
            }
        }
    }

    @Override
    public void destroy() {
        for (Pair<ZoomerAction, Shortcut> shortcut : this.registeredShortcuts) {
            MainApplication.unregisterActionShortcut((Action)shortcut.a, (Shortcut)shortcut.b);
        }
    }

    static {
        new JMapViewerUpdater();
    }

    private final class ZoomerAction
    extends AbstractAction {
        private final String action;

        ZoomerAction(String action) {
            this(action, "MapMover.Zoomer." + action);
        }

        ZoomerAction(String action, String name) {
            this.action = action;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (".".equals(this.action) || ",".equals(this.action)) {
                Point mouse = Optional.ofNullable(MapMover.this.nc.getMousePosition()).orElseGet(() -> new Point((int)MapMover.this.nc.getBounds().getCenterX(), (int)MapMover.this.nc.getBounds().getCenterY()));
                MapMover.this.mouseWheelMoved(new MouseWheelEvent((Component)MapMover.this.nc, e.getID(), e.getWhen(), e.getModifiers(), mouse.x, mouse.y, 0, false, 0, 1, ",".equals(this.action) ? -1 : 1));
            } else {
                EastNorth center = MapMover.this.nc.getCenter();
                EastNorth newcenter = MapMover.this.nc.getEastNorth(MapMover.this.nc.getWidth() / 2 + MapMover.this.nc.getWidth() / 5, MapMover.this.nc.getHeight() / 2 + MapMover.this.nc.getHeight() / 5);
                switch (this.action) {
                    case "left": {
                        MapMover.this.nc.zoomTo(new EastNorth(2.0 * center.east() - newcenter.east(), center.north()));
                        break;
                    }
                    case "right": {
                        MapMover.this.nc.zoomTo(new EastNorth(newcenter.east(), center.north()));
                        break;
                    }
                    case "up": {
                        MapMover.this.nc.zoomTo(new EastNorth(center.east(), 2.0 * center.north() - newcenter.north()));
                        break;
                    }
                    case "down": {
                        MapMover.this.nc.zoomTo(new EastNorth(center.east(), newcenter.north()));
                        break;
                    }
                }
            }
        }
    }

    private static class JMapViewerUpdater
    implements PreferenceChangedListener {
        JMapViewerUpdater() {
            Config.getPref().addPreferenceChangeListener(this);
            JMapViewerUpdater.updateJMapViewer();
        }

        @Override
        public void preferenceChanged(PreferenceChangeEvent e) {
            if (PROP_ZOOM_REVERSE_WHEEL.getKey().equals(e.getKey())) {
                JMapViewerUpdater.updateJMapViewer();
            }
        }

        private static void updateJMapViewer() {
            JMapViewer.zoomReverseWheel = PROP_ZOOM_REVERSE_WHEEL.get();
        }
    }
}

