/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import org.openstreetmap.josm.data.preferences.AbstractProperty;

public interface DownloadSourceSizingPolicy {
    public int getComponentHeight();

    public boolean isHeightAdjustable();

    default public void storeHeight(int height) {
        throw new UnsupportedOperationException("Setting the height is not supported for " + this.getClass().getCanonicalName());
    }

    public static class AdjustableDownloadSizePolicy
    implements DownloadSourceSizingPolicy {
        private final AbstractProperty<Integer> preference;

        public AdjustableDownloadSizePolicy(AbstractProperty<Integer> preference) {
            this.preference = preference;
        }

        @Override
        public int getComponentHeight() {
            return Math.max(1, this.preference.get());
        }

        @Override
        public boolean isHeightAdjustable() {
            return true;
        }

        @Override
        public void storeHeight(int height) {
            this.preference.put(height);
        }
    }

    public static class FixedDownloadSourceSizePolicy
    implements DownloadSourceSizingPolicy {
        private final Component base;

        public FixedDownloadSourceSizePolicy(Component base) {
            this.base = base;
        }

        @Override
        public int getComponentHeight() {
            return (int)this.base.getPreferredSize().getHeight();
        }

        @Override
        public boolean isHeightAdjustable() {
            return false;
        }
    }
}

