/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtilRt {
    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtilRt.toUpperCase(a) == StringUtilRt.toUpperCase(b) || StringUtilRt.toLowerCase(a) == StringUtilRt.toLowerCase(b);
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence toUpperCase(@NotNull CharSequence s) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(0);
        }
        StringBuilder answer = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            char upCased = StringUtilRt.toUpperCase(c);
            if (answer == null && upCased != c) {
                answer = new StringBuilder(s.length());
                answer.append(s.subSequence(0, i));
            }
            if (answer == null) continue;
            answer.append(upCased);
        }
        CharSequence charSequence = answer == null ? s : answer;
        if (charSequence == null) {
            StringUtilRt.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(2);
        }
        String string = StringUtilRt.convertLineSeparators(text2, false);
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(4);
        }
        String string = StringUtilRt.convertLineSeparators(text2, "\n", null, keepCarriageReturn);
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(6);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(7);
        }
        String string = StringUtilRt.convertLineSeparators(text2, newSeparator, null);
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(12);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(13);
        }
        String string = StringUtilRt.convertLineSeparators(text2, newSeparator, offsetsToKeep, false);
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(15);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(16);
        }
        String string = StringUtilRt.unifyLineSeparators(text2, newSeparator, offsetsToKeep, keepCarriageReturn).toString();
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static CharSequence unifyLineSeparators(@NotNull CharSequence text2, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(18);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(19);
        }
        StringBuilder buffer = null;
        int intactLength = 0;
        boolean newSeparatorIsSlashN = "\n".equals(newSeparator);
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                if (!newSeparatorIsSlashN) {
                    if (buffer == null) {
                        buffer = new StringBuilder(text2.length());
                        buffer.append(text2, 0, intactLength);
                    }
                    buffer.append(newSeparator);
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                    continue;
                }
                if (buffer == null) {
                    ++intactLength;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\r') {
                boolean followedByLineFeed;
                boolean bl = followedByLineFeed = i < text2.length() - 1 && text2.charAt(i + 1) == '\n';
                if (!followedByLineFeed && keepCarriageReturn) {
                    if (buffer == null) {
                        ++intactLength;
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text2.length());
                    buffer.append(text2, 0, intactLength);
                }
                buffer.append(newSeparator);
                if (followedByLineFeed) {
                    ++i;
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (buffer == null) {
                ++intactLength;
                continue;
            }
            buffer.append(c);
        }
        CharSequence charSequence = buffer == null ? text2 : buffer;
        if (charSequence == null) {
            StringUtilRt.$$$reportNull$$$0(20);
        }
        return charSequence;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i = 0; i < offsets.length; ++i) {
            int offset2 = offsets[i];
            if (offset2 < changeOffset + oldLength) continue;
            int n = i;
            offsets[n] = offsets[n] + shift;
        }
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtilRt.$$$reportNull$$$0(25);
        }
        String string = StringUtilRt.getShortName(fqName2, '.');
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2, char separator) {
        int lastPointIdx;
        if (fqName2 == null) {
            StringUtilRt.$$$reportNull$$$0(27);
        }
        if ((lastPointIdx = fqName2.lastIndexOf(separator)) >= 0) {
            String string = fqName2.substring(lastPointIdx + 1);
            if (string == null) {
                StringUtilRt.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = fqName2;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        int prefixLength;
        int stringLength;
        if (str == null) {
            StringUtilRt.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(31);
        }
        return (stringLength = str.length()) >= (prefixLength = prefix.length()) && str.regionMatches(true, 0, prefix, 0, prefixLength);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NonNls @NotNull CharSequence text2, @NonNls @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(32);
        }
        if (suffix == null) {
            StringUtilRt.$$$reportNull$$$0(33);
        }
        if ((l1 = text2.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (StringUtilRt.charsEqualIgnoreCase(text2.charAt(i), suffix.charAt(i + l2 - l1))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(34);
        }
        start = Math.max(start, 0);
        for (int i = Math.min(end, s.length()) - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toUpperCase";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyLineSeparators";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toUpperCase";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unifyLineSeparators";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

