/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.utils.DescriptionAware;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0018B\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0014\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016R\u0014\u0010\b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/config/ApiVersion;", "", "Lorg/jetbrains/kotlin/utils/DescriptionAware;", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "versionString", "", "(Lorg/jetbrains/kotlin/config/MavenComparableVersion;Ljava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "isStable", "", "()Z", "getVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "getVersionString", "compareTo", "", "other", "equals", "", "hashCode", "toString", "Companion", "util"})
public final class ApiVersion
implements Comparable<ApiVersion>,
DescriptionAware {
    @NotNull
    private final MavenComparableVersion version;
    @NotNull
    private final String versionString;
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_0;
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_1;
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_2;
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_3;
    @JvmField
    @NotNull
    public static final ApiVersion LATEST_STABLE;
    public static final Companion Companion;

    public final boolean isStable() {
        return this.compareTo(LATEST_STABLE) <= 0;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.isStable() ? this.versionString : this.versionString + " (EXPERIMENTAL)";
    }

    @Override
    public int compareTo(@NotNull ApiVersion other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.version.compareTo(other.version);
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (!(object instanceof ApiVersion)) {
            object = null;
        }
        ApiVersion apiVersion = (ApiVersion)object;
        return Intrinsics.areEqual(apiVersion != null ? apiVersion.version : null, this.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @NotNull
    public String toString() {
        return this.versionString;
    }

    @NotNull
    public final MavenComparableVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final String getVersionString() {
        return this.versionString;
    }

    private ApiVersion(MavenComparableVersion version, String versionString) {
        this.version = version;
        this.versionString = versionString;
    }

    static {
        Companion = new Companion(null);
        KOTLIN_1_0 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_0);
        KOTLIN_1_1 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_1);
        KOTLIN_1_2 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_2);
        KOTLIN_1_3 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_3);
        LATEST_STABLE = Companion.createByLanguageVersion(LanguageVersion.LATEST_STABLE);
    }

    public /* synthetic */ ApiVersion(@NotNull MavenComparableVersion version, @NotNull String versionString, DefaultConstructorMarker $constructor_marker) {
        this(version, versionString);
    }

    @JvmStatic
    @NotNull
    public static final ApiVersion createByLanguageVersion(@NotNull LanguageVersion version) {
        return Companion.createByLanguageVersion(version);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/config/ApiVersion$Companion;", "", "()V", "KOTLIN_1_0", "Lorg/jetbrains/kotlin/config/ApiVersion;", "KOTLIN_1_1", "KOTLIN_1_2", "KOTLIN_1_3", "LATEST_STABLE", "createByLanguageVersion", "version", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "parse", "versionString", "", "util"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ApiVersion createByLanguageVersion(@NotNull LanguageVersion version) {
            Intrinsics.checkParameterIsNotNull(version, "version");
            ApiVersion apiVersion = this.parse(version.getVersionString());
            if (apiVersion == null) {
                Intrinsics.throwNpe();
            }
            return apiVersion;
        }

        @Nullable
        public final ApiVersion parse(@NotNull String versionString) {
            ApiVersion apiVersion;
            Intrinsics.checkParameterIsNotNull(versionString, "versionString");
            try {
                apiVersion = new ApiVersion(new MavenComparableVersion(versionString), versionString, null);
            }
            catch (Exception e) {
                apiVersion = null;
            }
            return apiVersion;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

