/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import java.util.Set;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;

public class CompileTimeConstantUtils {
    private static final Set<String> ARRAY_CALL_NAMES = SetsKt.hashSetOf("kotlin.arrayOf", "kotlin.doubleArrayOf", "kotlin.floatArrayOf", "kotlin.longArrayOf", "kotlin.intArrayOf", "kotlin.charArrayOf", "kotlin.shortArrayOf", "kotlin.byteArrayOf", "kotlin.booleanArrayOf", "kotlin.emptyArray");

    public static void checkConstructorParametersType(@NotNull List<KtParameter> parameters2, @NotNull BindingTrace trace) {
        for (KtParameter parameter : parameters2) {
            VariableDescriptor parameterDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
            if (parameterDescriptor == null) continue;
            KotlinType parameterType = parameterDescriptor.getType();
            KtTypeReference typeReference = parameter.getTypeReference();
            if (typeReference == null) continue;
            if (parameterType.isMarkedNullable()) {
                trace.report(Errors.NULLABLE_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
                continue;
            }
            if (CompileTimeConstantUtils.isAcceptableTypeForAnnotationParameter(parameterType)) continue;
            trace.report(Errors.INVALID_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
        }
    }

    private static boolean isAcceptableTypeForAnnotationParameter(@NotNull KotlinType parameterType) {
        List<TypeProjection> arguments2;
        if (KotlinTypeKt.isError(parameterType)) {
            return true;
        }
        ClassDescriptor typeDescriptor = TypeUtils.getClassDescriptor(parameterType);
        if (typeDescriptor == null) {
            return false;
        }
        if (DescriptorUtils.isEnumClass(typeDescriptor) || DescriptorUtils.isAnnotationClass(typeDescriptor) || KotlinBuiltIns.isKClass(typeDescriptor) || KotlinBuiltIns.isPrimitiveArray(parameterType) || KotlinBuiltIns.isPrimitiveType(parameterType) || KotlinBuiltIns.isString(parameterType)) {
            return true;
        }
        if (KotlinBuiltIns.isArray(parameterType) && (arguments2 = parameterType.getArguments()).size() == 1) {
            KotlinType arrayType = arguments2.get(0).getType();
            if (arrayType.isMarkedNullable()) {
                return false;
            }
            ClassDescriptor arrayTypeDescriptor = TypeUtils.getClassDescriptor(arrayType);
            if (arrayTypeDescriptor != null) {
                return DescriptorUtils.isEnumClass(arrayTypeDescriptor) || DescriptorUtils.isAnnotationClass(arrayTypeDescriptor) || KotlinBuiltIns.isKClass(arrayTypeDescriptor) || KotlinBuiltIns.isString(arrayType);
            }
        }
        return false;
    }

    public static boolean isArrayFunctionCall(@NotNull ResolvedCall<?> resolvedCall2) {
        return ARRAY_CALL_NAMES.contains(DescriptorUtils.getFqName(resolvedCall2.getCandidateDescriptor()).asString());
    }

    public static boolean canBeReducedToBooleanConstant(@Nullable KtExpression expression2, @NotNull BindingContext context, @Nullable Boolean expectedValue) {
        KtExpression effectiveExpression = KtPsiUtil.deparenthesize(expression2);
        if (effectiveExpression == null) {
            return false;
        }
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.getConstant(effectiveExpression, context);
        if (!(compileTimeConstant instanceof TypedCompileTimeConstant) || compileTimeConstant.getUsesVariableAsConstant()) {
            return false;
        }
        ConstantValue constantValue = ((TypedCompileTimeConstant)compileTimeConstant).getConstantValue();
        if (!(constantValue instanceof BooleanValue)) {
            return false;
        }
        Boolean value = (Boolean)((BooleanValue)constantValue).getValue();
        return expectedValue == null || expectedValue.equals(value);
    }

    private CompileTimeConstantUtils() {
    }
}

