/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.Cell;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;

class CellUtils {
    private static final StringConverter defaultStringConverter = new StringConverter<Object>(){

        @Override
        public String toString(Object object) {
            return object == null ? null : object.toString();
        }

        @Override
        public Object fromString(String string) {
            return string;
        }
    };
    private static final StringConverter defaultTreeItemStringConverter = new StringConverter<TreeItem>(){

        @Override
        public String toString(TreeItem treeItem) {
            return treeItem == null || treeItem.getValue() == null ? "" : treeItem.getValue().toString();
        }

        @Override
        public TreeItem fromString(String string) {
            return new TreeItem<String>(string);
        }
    };

    CellUtils() {
    }

    static <T> StringConverter<T> defaultStringConverter() {
        return defaultStringConverter;
    }

    static <T> StringConverter<TreeItem<T>> defaultTreeItemStringConverter() {
        return defaultTreeItemStringConverter;
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> stringConverter) {
        return stringConverter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : stringConverter.toString(cell.getItem());
    }

    static <T> void updateItem(Cell<T> cell, ChoiceBox<T> choiceBox, StringConverter<T> stringConverter) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (choiceBox != null) {
                choiceBox.getSelectionModel().select(cell.getItem());
            }
            cell.setText(null);
            cell.setGraphic(choiceBox);
        } else {
            cell.setText(CellUtils.getItemText(cell, stringConverter));
            cell.setGraphic(null);
        }
    }

    static <T> ChoiceBox<T> createChoiceBox(final Cell<T> cell, ObservableList<T> observableList) {
        ChoiceBox<T> choiceBox = new ChoiceBox<T>(observableList);
        choiceBox.setMaxWidth(Double.MAX_VALUE);
        choiceBox.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<T>(){

            @Override
            public void changed(ObservableValue<? extends T> observableValue, T t, T t2) {
                if (cell.isEditing()) {
                    cell.commitEdit(t2);
                }
            }
        });
        return choiceBox;
    }

    static <T> void updateItem(Cell<T> cell, TextField textField, StringConverter<T> stringConverter) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (textField != null) {
                textField.setText(CellUtils.getItemText(cell, stringConverter));
            }
            cell.setText(null);
            cell.setGraphic(textField);
        } else {
            cell.setText(CellUtils.getItemText(cell, stringConverter));
            cell.setGraphic(null);
        }
    }

    static <T> void startEdit(Cell<T> cell, TextField textField, StringConverter<T> stringConverter) {
        if (textField == null) {
            textField = CellUtils.createTextField(cell, stringConverter);
        }
        textField.setText(CellUtils.getItemText(cell, stringConverter));
        cell.setText(null);
        cell.setGraphic(textField);
        textField.selectAll();
    }

    static <T> void cancelEdit(Cell<T> cell, StringConverter<T> stringConverter) {
        cell.setText(CellUtils.getItemText(cell, stringConverter));
        cell.setGraphic(null);
    }

    private static <T> TextField createTextField(final Cell<T> cell, final StringConverter<T> stringConverter) {
        final TextField textField = new TextField(CellUtils.getItemText(cell, stringConverter));
        textField.setOnKeyReleased((EventHandler<? super KeyEvent>)new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    if (stringConverter == null) {
                        throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
                    }
                    cell.commitEdit(stringConverter.fromString(textField.getText()));
                } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    cell.cancelEdit();
                }
            }
        });
        return textField;
    }

    static <T> void updateItem(Cell<T> cell, ComboBox<T> comboBox, StringConverter<T> stringConverter) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (comboBox != null) {
                comboBox.getSelectionModel().select(cell.getItem());
            }
            cell.setText(null);
            cell.setGraphic(comboBox);
        } else {
            cell.setText(CellUtils.getItemText(cell, stringConverter));
            cell.setGraphic(null);
        }
    }

    static <T> ComboBox<T> createComboBox(final Cell<T> cell, ObservableList<T> observableList) {
        ComboBox<T> comboBox = new ComboBox<T>(observableList);
        comboBox.setMaxWidth(Double.MAX_VALUE);
        comboBox.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<T>(){

            @Override
            public void changed(ObservableValue<? extends T> observableValue, T t, T t2) {
                if (cell.isEditing()) {
                    cell.commitEdit(t2);
                }
            }
        });
        return comboBox;
    }
}

