/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;

class PkiRealmBootstrapCheck
implements BootstrapCheck {
    private final SSLService sslService;
    private final List<SSLConfiguration> sslConfigurations;

    PkiRealmBootstrapCheck(Settings settings, SSLService sslService) {
        this.sslService = sslService;
        this.sslConfigurations = this.loadSslConfigurations(settings);
    }

    private List<SSLConfiguration> loadSslConfigurations(Settings settings) {
        ArrayList<SSLConfiguration> list = new ArrayList<SSLConfiguration>();
        if (((Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings)).booleanValue()) {
            list.add(this.sslService.sslConfiguration(SSLService.getHttpTransportSSLSettings((Settings)settings), Settings.EMPTY));
        }
        if (((Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings)).booleanValue()) {
            Settings transportSslSettings = settings.getByPrefix(SecurityField.setting((String)"transport.ssl."));
            list.add(this.sslService.sslConfiguration(transportSslSettings, Settings.EMPTY));
            settings.getGroups("transport.profiles.").values().stream().map(SecurityNetty4Transport::profileSslSettings).map(s -> this.sslService.sslConfiguration(s, transportSslSettings)).forEach(list::add);
        }
        return list;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        Settings settings = context.settings;
        boolean pkiRealmEnabled = settings.getGroups(RealmSettings.PREFIX).values().stream().filter(s -> "pki".equals(s.get("type"))).anyMatch(s -> s.getAsBoolean("enabled", Boolean.valueOf(true)));
        if (pkiRealmEnabled) {
            for (SSLConfiguration configuration : this.sslConfigurations) {
                if (!this.sslService.isSSLClientAuthEnabled(configuration)) continue;
                return BootstrapCheck.BootstrapCheckResult.success();
            }
            return BootstrapCheck.BootstrapCheckResult.failure((String)"a PKI realm is enabled but cannot be used as neither HTTP or Transport have SSL and client authentication enabled");
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    public boolean alwaysEnforce() {
        return true;
    }
}

