/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.KeyAndTimestamp;
import org.elasticsearch.xpack.core.security.authc.TokenMetaData;
import org.elasticsearch.xpack.security.SecurityLifecycleService;
import org.elasticsearch.xpack.security.authc.BytesKey;
import org.elasticsearch.xpack.security.authc.ExpiredTokenRemover;
import org.elasticsearch.xpack.security.authc.UserToken;

public final class TokenService
extends AbstractComponent {
    private static final int ITERATIONS = 100000;
    private static final String KDF_ALGORITHM = "PBKDF2withHMACSHA512";
    private static final int SALT_BYTES = 32;
    private static final int KEY_BYTES = 64;
    private static final int IV_BYTES = 12;
    private static final int VERSION_BYTES = 4;
    private static final String ENCRYPTION_CIPHER = "AES/GCM/NoPadding";
    private static final String EXPIRED_TOKEN_WWW_AUTH_VALUE = "Bearer realm=\"security\", error=\"invalid_token\", error_description=\"The access token expired\"";
    private static final String MALFORMED_TOKEN_WWW_AUTH_VALUE = "Bearer realm=\"security\", error=\"invalid_token\", error_description=\"The access token is malformed\"";
    private static final String TYPE = "doc";
    public static final String THREAD_POOL_NAME = "security-token-key";
    public static final Setting<SecureString> TOKEN_PASSPHRASE = SecureSetting.secureString((String)"xpack.security.authc.token.passphrase", null, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated});
    public static final Setting<TimeValue> TOKEN_EXPIRATION = Setting.timeSetting((String)"xpack.security.authc.token.timeout", (TimeValue)TimeValue.timeValueMinutes((long)20L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELETE_INTERVAL = Setting.timeSetting((String)"xpack.security.authc.token.delete.interval", (TimeValue)TimeValue.timeValueMinutes((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELETE_TIMEOUT = Setting.timeSetting((String)"xpack.security.authc.token.delete.timeout", (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final String INVALIDATED_TOKEN_DOC_TYPE = "invalidated-token";
    static final int MINIMUM_BYTES = 49;
    private static final int MINIMUM_BASE64_BYTES = Double.valueOf(Math.ceil(65.0)).intValue();
    private final SecureRandom secureRandom = new SecureRandom();
    private final ClusterService clusterService;
    private final Clock clock;
    private final TimeValue expirationDelay;
    private final TimeValue deleteInterval;
    private final Client client;
    private final SecurityLifecycleService lifecycleService;
    private final ExpiredTokenRemover expiredTokenRemover;
    private final boolean enabled;
    private volatile TokenKeys keyCache;
    private volatile long lastExpirationRunMs;
    private final AtomicLong createdTimeStamps = new AtomicLong(-1L);
    private final AtomicBoolean installTokenMetadataInProgress = new AtomicBoolean(false);

    public TokenService(Settings settings, Clock clock, Client client, SecurityLifecycleService lifecycleService, ClusterService clusterService) throws GeneralSecurityException {
        super(settings);
        byte[] saltArr = new byte[32];
        this.secureRandom.nextBytes(saltArr);
        SecureString tokenPassphraseValue = (SecureString)TOKEN_PASSPHRASE.get(settings);
        SecureString tokenPassphrase = tokenPassphraseValue.length() == 0 ? this.generateTokenKey() : tokenPassphraseValue;
        this.clock = clock.withZone(ZoneOffset.UTC);
        this.expirationDelay = (TimeValue)TOKEN_EXPIRATION.get(settings);
        this.client = client;
        this.lifecycleService = lifecycleService;
        this.lastExpirationRunMs = client.threadPool().relativeTimeInMillis();
        this.deleteInterval = (TimeValue)DELETE_INTERVAL.get(settings);
        this.enabled = TokenService.isTokenServiceEnabled(settings);
        this.expiredTokenRemover = new ExpiredTokenRemover(settings, client);
        this.ensureEncryptionCiphersSupported();
        KeyAndCache keyAndCache = new KeyAndCache(new KeyAndTimestamp(tokenPassphrase, this.createdTimeStamps.incrementAndGet()), new BytesKey(saltArr));
        this.keyCache = new TokenKeys(Collections.singletonMap(keyAndCache.getKeyHash(), keyAndCache), keyAndCache.getKeyHash());
        this.clusterService = clusterService;
        this.initialize(clusterService);
        this.getTokenMetaData();
    }

    public static Boolean isTokenServiceEnabled(Settings settings) {
        return (Boolean)XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(settings);
    }

    public void createUserToken(Authentication authentication, Authentication originatingClientAuth, ActionListener<Tuple<UserToken, String>> listener, Map<String, Object> metadata) throws IOException {
        this.ensureEnabled();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication must be provided"));
        } else if (originatingClientAuth == null) {
            listener.onFailure((Exception)new IllegalArgumentException("originating client authentication must be provided"));
        } else {
            Instant created = this.clock.instant();
            Instant expiration = this.getExpirationTime(created);
            Version version = this.clusterService.state().nodes().getMinNodeVersion();
            Authentication matchingVersionAuth = version.equals((Object)authentication.getVersion()) ? authentication : new Authentication(authentication.getUser(), authentication.getAuthenticatedBy(), authentication.getLookedUpBy(), version);
            UserToken userToken = new UserToken(version, matchingVersionAuth, expiration, metadata);
            String refreshToken = UUIDs.randomBase64UUID();
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                builder.startObject();
                builder.field("doc_type", "token");
                builder.field("creation_time", created.toEpochMilli());
                builder.startObject("refresh_token").field("token", refreshToken).field("invalidated", false).field("refreshed", false).startObject("client").field("type", "unassociated_client").field("user", originatingClientAuth.getUser().principal()).field("realm", originatingClientAuth.getAuthenticatedBy().getName()).endObject().endObject();
                builder.startObject("access_token").field("invalidated", false).field("user_token", (ToXContent)userToken).field("realm", authentication.getAuthenticatedBy().getName()).endObject();
                builder.endObject();
                IndexRequest request = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", TYPE, TokenService.getTokenDocumentId(userToken)).setOpType(DocWriteRequest.OpType.CREATE).setSource(builder).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL)).request();
                this.lifecycleService.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (Action)IndexAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(indexResponse -> listener.onResponse((Object)new Tuple((Object)userToken, (Object)refreshToken)), arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
            }
        }
    }

    void getAndValidateToken(ThreadContext ctx, ActionListener<UserToken> listener) {
        if (this.enabled) {
            String token = this.getFromHeader(ctx);
            if (token == null) {
                listener.onResponse(null);
            } else {
                try {
                    this.decodeAndValidateToken(token, (ActionListener<UserToken>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                        if (e instanceof IOException) {
                            this.logger.debug("invalid token", (Throwable)e);
                            listener.onResponse(null);
                        } else {
                            listener.onFailure(e);
                        }
                    }));
                }
                catch (IOException e2) {
                    this.logger.debug("invalid token", (Throwable)e2);
                    listener.onResponse(null);
                }
            }
        } else {
            listener.onResponse(null);
        }
    }

    public void getAuthenticationAndMetaData(String token, ActionListener<Tuple<Authentication, Map<String, Object>>> listener) throws IOException {
        this.decodeToken(token, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
            if (userToken == null) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("supplied token is not valid", new Object[0])));
            } else {
                listener.onResponse((Object)new Tuple((Object)userToken.getAuthentication(), userToken.getMetadata()));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void decodeAndValidateToken(String token, ActionListener<UserToken> listener) throws IOException {
        this.decodeToken(token, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
            if (userToken != null) {
                Instant currentTime = this.clock.instant();
                if (currentTime.isAfter(userToken.getExpirationTime())) {
                    listener.onFailure((Exception)((Object)TokenService.expiredTokenException()));
                } else {
                    this.checkIfTokenIsRevoked((UserToken)userToken, listener);
                }
            } else {
                listener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    void decodeToken(String token, ActionListener<UserToken> listener) throws IOException {
        byte[] bytes = token.getBytes(StandardCharsets.UTF_8);
        InputStreamStreamInput in = new InputStreamStreamInput(Base64.getDecoder().wrap(new ByteArrayInputStream(bytes)), (long)bytes.length);
        if (in.available() < MINIMUM_BASE64_BYTES) {
            this.logger.debug("invalid token");
            listener.onResponse(null);
        } else {
            Version version = Version.readVersion((StreamInput)in);
            in.setVersion(version);
            BytesKey decodedSalt = new BytesKey(in.readByteArray());
            BytesKey passphraseHash = version.onOrAfter(Version.V_6_0_0_beta2) ? new BytesKey(in.readByteArray()) : this.keyCache.currentTokenKeyHash;
            KeyAndCache keyAndCache = this.keyCache.get(passphraseHash);
            if (keyAndCache != null) {
                this.getKeyAsync(decodedSalt, keyAndCache, (ActionListener<SecretKey>)ActionListener.wrap(arg_0 -> this.lambda$decodeToken$9((StreamInput)in, version, decodedSalt, listener, arg_0), arg_0 -> TokenService.lambda$decodeToken$10((StreamInput)in, listener, arg_0)));
            } else {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                this.logger.debug("invalid key {} key: {}", (Object)passphraseHash, this.keyCache.cache.keySet());
                listener.onResponse(null);
            }
        }
    }

    private void getKeyAsync(BytesKey decodedSalt, KeyAndCache keyAndCache, ActionListener<SecretKey> listener) {
        SecretKey decodeKey = keyAndCache.getKey(decodedSalt);
        if (decodeKey != null) {
            listener.onResponse((Object)decodeKey);
        } else {
            this.client.threadPool().executor(THREAD_POOL_NAME).submit((Runnable)((Object)new KeyComputingRunnable(decodedSalt, listener, keyAndCache)));
        }
    }

    private static void decryptToken(StreamInput in, Cipher cipher, Version version, ActionListener<UserToken> listener) throws IOException {
        try (CipherInputStream cis = new CipherInputStream((InputStream)in, cipher);
             InputStreamStreamInput decryptedInput = new InputStreamStreamInput((InputStream)cis);){
            decryptedInput.setVersion(version);
            listener.onResponse((Object)new UserToken((StreamInput)decryptedInput));
        }
    }

    private static void decryptTokenId(StreamInput in, Cipher cipher, Version version, ActionListener<String> listener) throws IOException {
        try (CipherInputStream cis = new CipherInputStream((InputStream)in, cipher);
             InputStreamStreamInput decryptedInput = new InputStreamStreamInput((InputStream)cis);){
            decryptedInput.setVersion(version);
            listener.onResponse((Object)decryptedInput.readString());
        }
    }

    public void invalidateAccessToken(String tokenString, ActionListener<Boolean> listener) {
        this.ensureEnabled();
        if (Strings.isNullOrEmpty((String)tokenString)) {
            listener.onFailure((Exception)new IllegalArgumentException("token must be provided"));
        } else {
            this.maybeStartTokenRemover();
            try {
                this.decodeToken(tokenString, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
                    if (userToken == null) {
                        listener.onFailure((Exception)((Object)TokenService.malformedTokenException()));
                    } else {
                        long expirationEpochMilli = this.getExpirationTime().toEpochMilli();
                        this.indexBwcInvalidation((UserToken)userToken, listener, new AtomicInteger(0), expirationEpochMilli);
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            catch (IOException e) {
                this.logger.error("received a malformed token as part of a invalidation request", (Throwable)e);
                listener.onFailure((Exception)((Object)TokenService.malformedTokenException()));
            }
        }
    }

    public void invalidateAccessToken(UserToken userToken, ActionListener<Boolean> listener) {
        this.ensureEnabled();
        if (userToken == null) {
            listener.onFailure((Exception)new IllegalArgumentException("token must be provided"));
        } else {
            this.maybeStartTokenRemover();
            long expirationEpochMilli = this.getExpirationTime().toEpochMilli();
            this.indexBwcInvalidation(userToken, listener, new AtomicInteger(0), expirationEpochMilli);
        }
    }

    public void invalidateRefreshToken(String refreshToken, ActionListener<Boolean> listener) {
        this.ensureEnabled();
        if (Strings.isNullOrEmpty((String)refreshToken)) {
            listener.onFailure((Exception)new IllegalArgumentException("refresh token must be provided"));
        } else {
            this.maybeStartTokenRemover();
            this.findTokenFromRefreshToken(refreshToken, (ActionListener<Tuple<SearchResponse, AtomicInteger>>)ActionListener.wrap(tuple -> {
                String docId = ((SearchResponse)tuple.v1()).getHits().getAt(0).getId();
                long docVersion = ((SearchResponse)tuple.v1()).getHits().getAt(0).getVersion();
                this.indexInvalidation(docId, Version.CURRENT, listener, (AtomicInteger)tuple.v2(), "refresh_token", docVersion);
            }, arg_0 -> listener.onFailure(arg_0)), new AtomicInteger(0));
        }
    }

    private void indexBwcInvalidation(UserToken userToken, ActionListener<Boolean> listener, AtomicInteger attemptCount, long expirationEpochMilli) {
        if (attemptCount.get() > 5) {
            listener.onFailure((Exception)((Object)TokenService.invalidGrantException("failed to invalidate token")));
        } else {
            String invalidatedTokenId = TokenService.getInvalidatedTokenDocumentId(userToken);
            IndexRequest indexRequest = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", TYPE, invalidatedTokenId).setOpType(DocWriteRequest.OpType.CREATE).setSource(new Object[]{"doc_type", INVALIDATED_TOKEN_DOC_TYPE, "expiration_time", expirationEpochMilli}).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL)).request();
            String tokenDocId = TokenService.getTokenDocumentId(userToken);
            Version version = userToken.getVersion();
            this.lifecycleService.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(indexResponse -> {
                ActionListener wrappedListener = ActionListener.wrap(ignore -> listener.onResponse((Object)true), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                this.indexInvalidation(tokenDocId, version, (ActionListener<Boolean>)wrappedListener, attemptCount, "access_token", 1L);
            }, e -> {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof VersionConflictEngineException) {
                    ActionListener wrappedListener = ActionListener.wrap(ignore -> listener.onResponse((Object)false), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                    this.indexInvalidation(tokenDocId, version, (ActionListener<Boolean>)wrappedListener, attemptCount, "access_token", 1L);
                } else if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                    attemptCount.incrementAndGet();
                    this.indexBwcInvalidation(userToken, listener, attemptCount, expirationEpochMilli);
                } else {
                    listener.onFailure(e);
                }
            }), (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1)));
        }
    }

    private void indexInvalidation(String tokenDocId, Version version, ActionListener<Boolean> listener, AtomicInteger attemptCount, String srcPrefix, long documentVersion) {
        if (attemptCount.get() > 5) {
            listener.onFailure((Exception)((Object)TokenService.invalidGrantException("failed to invalidate token")));
        } else {
            UpdateRequest request = (UpdateRequest)((UpdateRequestBuilder)this.client.prepareUpdate(".security", TYPE, tokenDocId).setDoc(new Object[]{srcPrefix, Collections.singletonMap("invalidated", true)}).setVersion(documentVersion).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL)).request();
            this.lifecycleService.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)ActionListener.wrap(updateResponse -> {
                if (updateResponse.getGetResult() != null && updateResponse.getGetResult().sourceAsMap().containsKey(srcPrefix) && ((Map)updateResponse.getGetResult().sourceAsMap().get(srcPrefix)).containsKey("invalidated")) {
                    boolean prevInvalidated = (Boolean)((Map)updateResponse.getGetResult().sourceAsMap().get(srcPrefix)).get("invalidated");
                    listener.onResponse((Object)(!prevInvalidated ? 1 : 0));
                } else {
                    listener.onResponse((Object)true);
                }
            }, e -> {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof DocumentMissingException) {
                    if (version.onOrAfter(Version.V_6_2_0)) {
                        listener.onFailure(e);
                    } else {
                        listener.onResponse((Object)false);
                    }
                } else if (cause instanceof VersionConflictEngineException || TransportActions.isShardNotAvailableException((Throwable)cause)) {
                    attemptCount.incrementAndGet();
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((GetRequest)this.client.prepareGet(".security", TYPE, tokenDocId).request()), (ActionListener)ActionListener.wrap(getResult -> {
                        if (getResult.isExists()) {
                            Map source = getResult.getSource();
                            Map accessTokenSource = (Map)source.get("access_token");
                            if (accessTokenSource == null) {
                                listener.onFailure((Exception)new IllegalArgumentException("token document is missing access_token field"));
                            } else {
                                Boolean invalidated = (Boolean)accessTokenSource.get("invalidated");
                                if (invalidated == null) {
                                    listener.onFailure((Exception)new IllegalStateException("token document missing invalidated value"));
                                } else if (invalidated.booleanValue()) {
                                    listener.onResponse((Object)false);
                                } else {
                                    this.indexInvalidation(tokenDocId, version, listener, attemptCount, srcPrefix, getResult.getVersion());
                                }
                            }
                        } else if (version.onOrAfter(Version.V_6_2_0)) {
                            this.logger.warn("could not find token document [{}] but there should be one as token has version [{}]", (Object)tokenDocId, (Object)version);
                            listener.onFailure((Exception)((Object)TokenService.invalidGrantException("could not invalidate the token")));
                        } else {
                            listener.onResponse((Object)false);
                        }
                    }, e1 -> {
                        if (TransportActions.isShardNotAvailableException((Throwable)e1)) {
                            this.indexInvalidation(tokenDocId, version, listener, attemptCount, srcPrefix, documentVersion);
                        } else {
                            listener.onFailure(e1);
                        }
                    }), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
                } else {
                    listener.onFailure(e);
                }
            }), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
        }
    }

    public void refreshToken(String refreshToken, ActionListener<Tuple<UserToken, String>> listener) {
        this.ensureEnabled();
        this.findTokenFromRefreshToken(refreshToken, (ActionListener<Tuple<SearchResponse, AtomicInteger>>)ActionListener.wrap(tuple -> {
            Authentication userAuth = Authentication.readFromContext((ThreadContext)this.client.threadPool().getThreadContext());
            String tokenDocId = ((SearchResponse)tuple.v1()).getHits().getHits()[0].getId();
            this.innerRefresh(tokenDocId, userAuth, listener, (AtomicInteger)tuple.v2());
        }, arg_0 -> listener.onFailure(arg_0)), new AtomicInteger(0));
    }

    private void findTokenFromRefreshToken(String refreshToken, ActionListener<Tuple<SearchResponse, AtomicInteger>> listener, AtomicInteger attemptCount) {
        if (attemptCount.get() > 5) {
            listener.onFailure((Exception)((Object)TokenService.invalidGrantException("could not refresh the requested token")));
        } else {
            SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)"token")).filter((QueryBuilder)QueryBuilders.termQuery((String)"refresh_token.token", (String)refreshToken))).setVersion(true).request();
            this.lifecycleService.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)ActionListener.wrap(searchResponse -> {
                if (searchResponse.isTimedOut()) {
                    attemptCount.incrementAndGet();
                    this.findTokenFromRefreshToken(refreshToken, listener, attemptCount);
                } else if (searchResponse.getHits().getHits().length < 1) {
                    this.logger.info("could not find token document with refresh_token [{}]", (Object)refreshToken);
                    listener.onFailure((Exception)((Object)TokenService.invalidGrantException("could not refresh the requested token")));
                } else if (searchResponse.getHits().getHits().length > 1) {
                    listener.onFailure((Exception)new IllegalStateException("multiple tokens share the same refresh token"));
                } else {
                    listener.onResponse((Object)new Tuple(searchResponse, (Object)attemptCount));
                }
            }, e -> {
                if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                    this.logger.debug("failed to search for token document, retrying", (Throwable)e);
                    attemptCount.incrementAndGet();
                    this.findTokenFromRefreshToken(refreshToken, listener, attemptCount);
                } else {
                    listener.onFailure(e);
                }
            }), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1)));
        }
    }

    private void innerRefresh(String tokenDocId, Authentication userAuth, ActionListener<Tuple<UserToken, String>> listener, AtomicInteger attemptCount) {
        if (attemptCount.getAndIncrement() > 5) {
            listener.onFailure((Exception)((Object)TokenService.invalidGrantException("could not refresh the requested token")));
        } else {
            GetRequest getRequest = (GetRequest)this.client.prepareGet(".security", TYPE, tokenDocId).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(response -> {
                if (response.isExists()) {
                    Map source = response.getSource();
                    Optional<ElasticsearchSecurityException> invalidSource = this.checkTokenDocForRefresh(source, userAuth);
                    if (invalidSource.isPresent()) {
                        listener.onFailure((Exception)((Object)invalidSource.get()));
                    } else {
                        Map userTokenSource = (Map)((Map)source.get("access_token")).get("user_token");
                        String authString = (String)userTokenSource.get("authentication");
                        Integer version = (Integer)userTokenSource.get("version");
                        Map metadata = (Map)userTokenSource.get("metadata");
                        Version authVersion = Version.fromId((int)version);
                        StreamInput in = StreamInput.wrap((byte[])Base64.getDecoder().decode(authString));
                        Throwable throwable = null;
                        try {
                            in.setVersion(authVersion);
                            Authentication authentication = new Authentication(in);
                            UpdateRequest updateRequest = (UpdateRequest)((UpdateRequestBuilder)this.client.prepareUpdate(".security", TYPE, tokenDocId).setVersion(response.getVersion()).setDoc(new Object[]{"refresh_token", Collections.singletonMap("refreshed", true)}).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL)).request();
                            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(updateResponse -> this.createUserToken(authentication, userAuth, listener, metadata), e -> {
                                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                                if (cause instanceof VersionConflictEngineException || TransportActions.isShardNotAvailableException((Throwable)e)) {
                                    this.innerRefresh(tokenDocId, userAuth, listener, attemptCount);
                                } else {
                                    listener.onFailure(e);
                                }
                            }), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in != null) {
                                TokenService.$closeResource(throwable, (AutoCloseable)in);
                            }
                        }
                    }
                } else {
                    this.logger.info("could not find token document [{}] for refresh", (Object)tokenDocId);
                    listener.onFailure((Exception)((Object)TokenService.invalidGrantException("could not refresh the requested token")));
                }
            }, e -> {
                if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                    this.innerRefresh(tokenDocId, userAuth, listener, attemptCount);
                } else {
                    listener.onFailure(e);
                }
            }), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
        }
    }

    private Optional<ElasticsearchSecurityException> checkTokenDocForRefresh(Map<String, Object> source, Authentication userAuth) {
        Map refreshTokenSrc = (Map)source.get("refresh_token");
        Map accessTokenSrc = (Map)source.get("access_token");
        if (refreshTokenSrc == null || refreshTokenSrc.isEmpty()) {
            return Optional.of(TokenService.invalidGrantException("token document is missing the refresh_token object"));
        }
        if (accessTokenSrc == null || accessTokenSrc.isEmpty()) {
            return Optional.of(TokenService.invalidGrantException("token document is missing the access_token object"));
        }
        Boolean refreshed = (Boolean)refreshTokenSrc.get("refreshed");
        Boolean invalidated = (Boolean)refreshTokenSrc.get("invalidated");
        Long creationEpochMilli = (Long)source.get("creation_time");
        Instant creationTime = creationEpochMilli == null ? null : Instant.ofEpochMilli(creationEpochMilli);
        Map userTokenSrc = (Map)accessTokenSrc.get("user_token");
        if (refreshed == null) {
            return Optional.of(TokenService.invalidGrantException("token document is missing refreshed value"));
        }
        if (invalidated == null) {
            return Optional.of(TokenService.invalidGrantException("token document is missing invalidated value"));
        }
        if (creationEpochMilli == null) {
            return Optional.of(TokenService.invalidGrantException("token document is missing creation time value"));
        }
        if (refreshed.booleanValue()) {
            return Optional.of(TokenService.invalidGrantException("token has already been refreshed"));
        }
        if (invalidated.booleanValue()) {
            return Optional.of(TokenService.invalidGrantException("token has been invalidated"));
        }
        if (this.clock.instant().isAfter(creationTime.plus(24L, ChronoUnit.HOURS))) {
            return Optional.of(TokenService.invalidGrantException("refresh token is expired"));
        }
        if (userTokenSrc == null || userTokenSrc.isEmpty()) {
            return Optional.of(TokenService.invalidGrantException("token document is missing the user token info"));
        }
        if (userTokenSrc.get("authentication") == null) {
            return Optional.of(TokenService.invalidGrantException("token is missing authentication info"));
        }
        if (userTokenSrc.get("version") == null) {
            return Optional.of(TokenService.invalidGrantException("token is missing version value"));
        }
        if (userTokenSrc.get("metadata") == null) {
            return Optional.of(TokenService.invalidGrantException("token is missing metadata"));
        }
        return this.checkClient(refreshTokenSrc, userAuth);
    }

    private Optional<ElasticsearchSecurityException> checkClient(Map<String, Object> refreshTokenSource, Authentication userAuth) {
        Map clientInfo = (Map)refreshTokenSource.get("client");
        if (clientInfo == null) {
            return Optional.of(TokenService.invalidGrantException("token is missing client information"));
        }
        if (!userAuth.getUser().principal().equals(clientInfo.get("user"))) {
            return Optional.of(TokenService.invalidGrantException("tokens must be refreshed by the creating client"));
        }
        if (!userAuth.getAuthenticatedBy().getName().equals(clientInfo.get("realm"))) {
            return Optional.of(TokenService.invalidGrantException("tokens must be refreshed by the creating client"));
        }
        return Optional.empty();
    }

    public void findActiveTokensForRealm(String realmName, ActionListener<Collection<Tuple<UserToken, String>>> listener) {
        this.ensureEnabled();
        if (Strings.isNullOrEmpty((String)realmName)) {
            listener.onFailure((Exception)new IllegalArgumentException("Realm name is required"));
            return;
        }
        Instant now = this.clock.instant();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)"token")).filter((QueryBuilder)QueryBuilders.termQuery((String)"access_token.realm", (String)realmName)).filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"access_token.invalidated", (boolean)false)).must((QueryBuilder)QueryBuilders.rangeQuery((String)"access_token.user_token.expiration_time").gte((Object)now.toEpochMilli()))).should((QueryBuilder)QueryBuilders.termQuery((String)"refresh_token.invalidated", (boolean)false)));
        SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll(TimeValue.timeValueSeconds((long)10L)).setQuery((QueryBuilder)boolQuery).setVersion(false).setSize(1000).setFetchSource(true).request();
        Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
        this.lifecycleService.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> this.lambda$findActiveTokensForRealm$31(request, (Supplier)supplier, listener));
    }

    private Tuple<UserToken, String> parseHit(SearchHit hit) {
        Map source = hit.getSourceAsMap();
        if (source == null) {
            throw new IllegalStateException("token document did not have source but source should have been fetched");
        }
        try {
            return this.parseTokensFromDocument(source);
        }
        catch (IOException e) {
            throw TokenService.invalidGrantException("cannot read token from document");
        }
    }

    private Tuple<UserToken, String> parseTokensFromDocument(Map<String, Object> source) throws IOException {
        String refreshToken = (String)((Map)source.get("refresh_token")).get("token");
        Map userTokenSource = (Map)((Map)source.get("access_token")).get("user_token");
        String id = (String)userTokenSource.get("id");
        Integer version = (Integer)userTokenSource.get("version");
        String authString = (String)userTokenSource.get("authentication");
        Long expiration = (Long)userTokenSource.get("expiration_time");
        Map metadata = (Map)userTokenSource.get("metadata");
        Version authVersion = Version.fromId((int)version);
        try (StreamInput in = StreamInput.wrap((byte[])Base64.getDecoder().decode(authString));){
            in.setVersion(authVersion);
            Authentication authentication = new Authentication(in);
            Tuple tuple = new Tuple((Object)new UserToken(id, Version.fromId((int)version), authentication, Instant.ofEpochMilli(expiration), metadata), (Object)refreshToken);
            return tuple;
        }
    }

    private static String getInvalidatedTokenDocumentId(UserToken userToken) {
        return TokenService.getInvalidatedTokenDocumentId(userToken.getId());
    }

    private static String getInvalidatedTokenDocumentId(String id) {
        return "invalidated-token_" + id;
    }

    private static String getTokenDocumentId(UserToken userToken) {
        return TokenService.getTokenDocumentId(userToken.getId());
    }

    private static String getTokenDocumentId(String id) {
        return "token_" + id;
    }

    private void ensureEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("tokens are not enabled");
        }
    }

    private void checkIfTokenIsRevoked(final UserToken userToken, final ActionListener<UserToken> listener) {
        if (!this.lifecycleService.isSecurityIndexExisting()) {
            listener.onResponse((Object)userToken);
        } else {
            this.lifecycleService.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                MultiGetRequest mGetRequest = (MultiGetRequest)this.client.prepareMultiGet().add(".security", TYPE, TokenService.getInvalidatedTokenDocumentId(userToken)).add(".security", TYPE, TokenService.getTokenDocumentId(userToken)).request();
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)mGetRequest, (ActionListener)new ActionListener<MultiGetResponse>(){

                    public void onResponse(MultiGetResponse response) {
                        MultiGetItemResponse[] itemResponse = response.getResponses();
                        if (itemResponse[0].isFailed()) {
                            this.onFailure(itemResponse[0].getFailure().getFailure());
                        } else if (itemResponse[0].getResponse().isExists()) {
                            listener.onFailure((Exception)((Object)TokenService.expiredTokenException()));
                        } else if (itemResponse[1].isFailed()) {
                            this.onFailure(itemResponse[1].getFailure().getFailure());
                        } else if (itemResponse[1].getResponse().isExists()) {
                            Map source = itemResponse[1].getResponse().getSource();
                            Map accessTokenSource = (Map)source.get("access_token");
                            if (accessTokenSource == null) {
                                listener.onFailure((Exception)new IllegalStateException("token document is missing access_token field"));
                            } else {
                                Boolean invalidated = (Boolean)accessTokenSource.get("invalidated");
                                if (invalidated == null) {
                                    listener.onFailure((Exception)new IllegalStateException("token document is missing invalidated field"));
                                } else if (invalidated.booleanValue()) {
                                    listener.onFailure((Exception)((Object)TokenService.expiredTokenException()));
                                } else {
                                    listener.onResponse((Object)userToken);
                                }
                            }
                        } else if (userToken.getVersion().onOrAfter(Version.V_6_2_0)) {
                            listener.onFailure((Exception)new IllegalStateException("token document is missing and must be present"));
                        } else {
                            listener.onResponse((Object)userToken);
                        }
                    }

                    public void onFailure(Exception e) {
                        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                            TokenService.this.logger.warn("failed to get token [{}] since index is not available", (Object)userToken.getId());
                            listener.onResponse(null);
                        } else {
                            TokenService.this.logger.error((Message)new ParameterizedMessage("failed to get token [{}]", (Object)userToken.getId()), (Throwable)e);
                            listener.onFailure(e);
                        }
                    }
                }, (arg_0, arg_1) -> ((Client)this.client).multiGet(arg_0, arg_1));
            });
        }
    }

    public TimeValue getExpirationDelay() {
        return this.expirationDelay;
    }

    private Instant getExpirationTime() {
        return this.getExpirationTime(this.clock.instant());
    }

    private Instant getExpirationTime(Instant now) {
        return now.plusSeconds(this.expirationDelay.getSeconds());
    }

    private void maybeStartTokenRemover() {
        if (this.lifecycleService.isSecurityIndexAvailable() && this.client.threadPool().relativeTimeInMillis() - this.lastExpirationRunMs > this.deleteInterval.getMillis()) {
            this.expiredTokenRemover.submit(this.client.threadPool());
            this.lastExpirationRunMs = this.client.threadPool().relativeTimeInMillis();
        }
    }

    String getFromHeader(ThreadContext threadContext) {
        String header = threadContext.getHeader("Authorization");
        if (Strings.hasLength((String)header) && header.startsWith("Bearer ") && header.length() > "Bearer ".length()) {
            return header.substring("Bearer ".length());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public String getUserTokenString(UserToken userToken) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ensureEncryptionCiphersSupported() throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher.getInstance(ENCRYPTION_CIPHER);
        SecretKeyFactory.getInstance(KDF_ALGORITHM);
    }

    private Cipher getEncryptionCipher(byte[] iv, KeyAndCache keyAndCache, Version version) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_CIPHER);
        BytesKey salt = keyAndCache.getSalt();
        try {
            cipher.init(1, (Key)keyAndCache.getOrComputeKey(salt), new GCMParameterSpec(128, iv), this.secureRandom);
        }
        catch (ExecutionException e) {
            throw new ElasticsearchSecurityException("Failed to compute secret key for active salt", (Exception)e, new Object[0]);
        }
        cipher.updateAAD(ByteBuffer.allocate(4).putInt(version.id).array());
        cipher.updateAAD(salt.bytes);
        return cipher;
    }

    private Cipher getDecryptionCipher(byte[] iv, SecretKey key, Version version, BytesKey salt) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_CIPHER);
        cipher.init(2, (Key)key, new GCMParameterSpec(128, iv), this.secureRandom);
        cipher.updateAAD(ByteBuffer.allocate(4).putInt(version.id).array());
        cipher.updateAAD(salt.bytes);
        return cipher;
    }

    private byte[] getNewInitializationVector() {
        byte[] initializationVector = new byte[12];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }

    static SecretKey computeSecretKey(char[] rawPassword, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(KDF_ALGORITHM);
        PBEKeySpec keySpec = new PBEKeySpec(rawPassword, salt, 100000, 128);
        SecretKey tmp = secretKeyFactory.generateSecret(keySpec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    private static ElasticsearchSecurityException expiredTokenException() {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("token expired", RestStatus.UNAUTHORIZED, new Object[0]);
        e.addHeader("WWW-Authenticate", new String[]{EXPIRED_TOKEN_WWW_AUTH_VALUE});
        return e;
    }

    private static ElasticsearchSecurityException malformedTokenException() {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("token malformed", RestStatus.UNAUTHORIZED, new Object[0]);
        e.addHeader("WWW-Authenticate", new String[]{MALFORMED_TOKEN_WWW_AUTH_VALUE});
        return e;
    }

    private static ElasticsearchSecurityException invalidGrantException(String detail) {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("invalid_grant", RestStatus.BAD_REQUEST, new Object[0]);
        e.addHeader("error_description", new String[]{detail});
        return e;
    }

    boolean isExpiredTokenException(ElasticsearchSecurityException e) {
        List headers = e.getHeader("WWW-Authenticate");
        return headers != null && headers.stream().anyMatch(EXPIRED_TOKEN_WWW_AUTH_VALUE::equals);
    }

    boolean isExpirationInProgress() {
        return this.expiredTokenRemover.isExpirationInProgress();
    }

    synchronized TokenMetaData generateSpareKey() {
        KeyAndCache currentKey = this.keyCache.activeKeyCache;
        KeyAndCache maxKey = this.keyCache.cache.values().stream().max(Comparator.comparingLong(v -> ((KeyAndCache)v).keyAndTimestamp.getTimestamp())).get();
        if (currentKey == maxKey) {
            KeyAndCache keyAndCache;
            long timestamp = this.createdTimeStamps.incrementAndGet();
            do {
                byte[] saltArr = new byte[32];
                this.secureRandom.nextBytes(saltArr);
                SecureString tokenKey = this.generateTokenKey();
                keyAndCache = new KeyAndCache(new KeyAndTimestamp(tokenKey, timestamp), new BytesKey(saltArr));
            } while (this.keyCache.cache.containsKey(keyAndCache.getKeyHash()));
            return this.newTokenMetaData(this.keyCache.currentTokenKeyHash, Iterables.concat((Iterable[])new Iterable[]{this.keyCache.cache.values(), Collections.singletonList(keyAndCache)}));
        }
        return this.newTokenMetaData(this.keyCache.currentTokenKeyHash, this.keyCache.cache.values());
    }

    synchronized TokenMetaData rotateToSpareKey() {
        KeyAndCache maxKey = this.keyCache.cache.values().stream().max(Comparator.comparingLong(v -> ((KeyAndCache)v).keyAndTimestamp.getTimestamp())).get();
        if (maxKey == this.keyCache.activeKeyCache) {
            throw new IllegalStateException("call generateSpareKey first");
        }
        return this.newTokenMetaData(maxKey.getKeyHash(), this.keyCache.cache.values());
    }

    synchronized TokenMetaData pruneKeys(int numKeysToKeep) {
        if (this.keyCache.cache.size() <= numKeysToKeep) {
            return this.getTokenMetaData();
        }
        HashMap<BytesKey, KeyAndCache> map = new HashMap<BytesKey, KeyAndCache>(this.keyCache.cache.size() + 1);
        KeyAndCache currentKey = this.keyCache.get(this.keyCache.currentTokenKeyHash);
        ArrayList<KeyAndCache> entries = new ArrayList<KeyAndCache>(this.keyCache.cache.values());
        Collections.sort(entries, (left, right) -> Long.compare(((KeyAndCache)right).keyAndTimestamp.getTimestamp(), ((KeyAndCache)left).keyAndTimestamp.getTimestamp()));
        for (KeyAndCache value : entries) {
            if (map.size() < numKeysToKeep || value.keyAndTimestamp.getTimestamp() >= currentKey.keyAndTimestamp.getTimestamp()) {
                this.logger.debug("keeping key {} ", (Object)value.getKeyHash());
                map.put(value.getKeyHash(), value);
                continue;
            }
            this.logger.debug("prune key {} ", (Object)value.getKeyHash());
        }
        assert (!map.isEmpty());
        assert (map.containsKey(this.keyCache.currentTokenKeyHash));
        return this.newTokenMetaData(this.keyCache.currentTokenKeyHash, map.values());
    }

    public synchronized TokenMetaData getTokenMetaData() {
        return this.newTokenMetaData(this.keyCache.currentTokenKeyHash, this.keyCache.cache.values());
    }

    private TokenMetaData newTokenMetaData(BytesKey activeTokenKey, Iterable<KeyAndCache> iterable) {
        ArrayList<KeyAndTimestamp> list = new ArrayList<KeyAndTimestamp>();
        for (KeyAndCache v : iterable) {
            list.add(v.keyAndTimestamp);
        }
        return new TokenMetaData(list, activeTokenKey.bytes);
    }

    synchronized void refreshMetaData(TokenMetaData metaData) {
        BytesKey currentUsedKeyHash = new BytesKey(metaData.getCurrentKeyHash());
        byte[] saltArr = new byte[32];
        HashMap<BytesKey, KeyAndCache> map = new HashMap<BytesKey, KeyAndCache>(metaData.getKeys().size());
        long maxTimestamp = this.createdTimeStamps.get();
        for (KeyAndTimestamp key : metaData.getKeys()) {
            this.secureRandom.nextBytes(saltArr);
            KeyAndCache keyAndCache = new KeyAndCache(key, new BytesKey(saltArr));
            maxTimestamp = Math.max(keyAndCache.keyAndTimestamp.getTimestamp(), maxTimestamp);
            if (!this.keyCache.cache.containsKey(keyAndCache.getKeyHash())) {
                map.put(keyAndCache.getKeyHash(), keyAndCache);
                continue;
            }
            map.put(keyAndCache.getKeyHash(), this.keyCache.get(keyAndCache.getKeyHash()));
        }
        if (!map.containsKey(currentUsedKeyHash)) {
            throw new IllegalStateException("Current key is not in the map: " + map.keySet() + " key: " + currentUsedKeyHash);
        }
        this.createdTimeStamps.set(maxTimestamp);
        this.keyCache = new TokenKeys(Collections.unmodifiableMap(map), currentUsedKeyHash);
        this.logger.debug("refreshed keys current: {}, keys: {}", (Object)currentUsedKeyHash, this.keyCache.cache.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecureString generateTokenKey() {
        byte[] keyBytes = new byte[64];
        byte[] encode = new byte[]{};
        char[] ref = new char[]{};
        try {
            this.secureRandom.nextBytes(keyBytes);
            encode = Base64.getUrlEncoder().withoutPadding().encode(keyBytes);
            ref = new char[encode.length];
            int len = UnicodeUtil.UTF8toUTF16((byte[])encode, (int)0, (int)encode.length, (char[])ref);
            SecureString secureString = new SecureString(Arrays.copyOfRange(ref, 0, len));
            return secureString;
        }
        finally {
            Arrays.fill(keyBytes, (byte)0);
            Arrays.fill(encode, (byte)0);
            Arrays.fill(ref, '\u0000');
        }
    }

    synchronized String getActiveKeyHash() {
        return new BytesRef(Base64.getUrlEncoder().withoutPadding().encode(this.keyCache.currentTokenKeyHash.bytes)).utf8ToString();
    }

    void rotateKeysOnMaster(ActionListener<ClusterStateUpdateResponse> listener) {
        this.logger.info("rotate keys on master");
        TokenMetaData tokenMetaData = this.generateSpareKey();
        this.clusterService.submitStateUpdateTask("publish next key to prepare key rotation", (ClusterStateTaskConfig)new TokenMetadataPublishAction((ActionListener<ClusterStateUpdateResponse>)ActionListener.wrap(res -> {
            if (res.isAcknowledged()) {
                TokenMetaData metaData = this.rotateToSpareKey();
                this.clusterService.submitStateUpdateTask("publish next key to prepare key rotation", (ClusterStateTaskConfig)new TokenMetadataPublishAction(listener, metaData));
            } else {
                listener.onFailure((Exception)new IllegalStateException("not acked"));
            }
        }, arg_0 -> listener.onFailure(arg_0)), tokenMetaData));
    }

    private void initialize(ClusterService clusterService) {
        clusterService.addListener(event -> {
            ClusterState state = event.state();
            if (state.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
                return;
            }
            TokenMetaData custom = (TokenMetaData)event.state().custom("security_tokens");
            if (state.nodes().isLocalNodeElectedMaster() && custom == null) {
                if (XPackPlugin.isReadyForXPackCustomMetadata((ClusterState)state)) {
                    this.installTokenMetadata();
                } else {
                    this.logger.debug("cannot add token metadata to cluster as the following nodes might not understand the metadata: {}", new org.apache.logging.log4j.util.Supplier[]{() -> XPackPlugin.nodesNotReadyForXPackCustomMetadata((ClusterState)state)});
                }
            }
            if (custom != null && !custom.equals((Object)this.getTokenMetaData())) {
                this.logger.info("refresh keys");
                try {
                    this.refreshMetaData(custom);
                }
                catch (Exception e) {
                    this.logger.warn("refreshing metadata failed", (Throwable)e);
                }
                this.logger.info("refreshed keys");
            }
        });
    }

    private void installTokenMetadata() {
        if (this.installTokenMetadataInProgress.compareAndSet(false, true)) {
            this.clusterService.submitStateUpdateTask("install-token-metadata", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT){

                public ClusterState execute(ClusterState currentState) {
                    XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)currentState);
                    if (currentState.custom("security_tokens") == null) {
                        return ClusterState.builder((ClusterState)currentState).putCustom("security_tokens", (ClusterState.Custom)TokenService.this.getTokenMetaData()).build();
                    }
                    return currentState;
                }

                public void onFailure(String source, Exception e) {
                    TokenService.this.installTokenMetadataInProgress.set(false);
                    TokenService.this.logger.error("unable to install token metadata", (Throwable)e);
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    TokenService.this.installTokenMetadataInProgress.set(false);
                }
            });
        }
    }

    void clearActiveKeyCache() {
        this.keyCache.activeKeyCache.keyCache.invalidateAll();
    }

    private /* synthetic */ void lambda$findActiveTokensForRealm$31(SearchRequest request, Supplier supplier, ActionListener listener) {
        ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), this::parseHit);
    }

    private static /* synthetic */ void lambda$decodeToken$10(StreamInput in, ActionListener listener, Exception e) {
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        listener.onFailure(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$decodeToken$9(StreamInput in, Version version, BytesKey decodedSalt, ActionListener listener, SecretKey decodeKey) throws Exception {
        try {
            byte[] iv = in.readByteArray();
            Cipher cipher = this.getDecryptionCipher(iv, decodeKey, version, decodedSalt);
            if (version.onOrAfter(Version.V_6_2_0)) {
                TokenService.decryptTokenId(in, cipher, version, (ActionListener<String>)ActionListener.wrap(tokenId -> this.lifecycleService.prepareIndexIfNeededThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> {
                    GetRequest getRequest = (GetRequest)this.client.prepareGet(".security", TYPE, TokenService.getTokenDocumentId(tokenId)).request();
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(response -> {
                        if (response.isExists()) {
                            Map accessTokenSource = (Map)response.getSource().get("access_token");
                            if (accessTokenSource == null) {
                                listener.onFailure((Exception)new IllegalStateException("token document is missing the access_token field"));
                            } else if (!accessTokenSource.containsKey("user_token")) {
                                listener.onFailure((Exception)new IllegalStateException("token document is missing the user_token field"));
                            } else {
                                Map userTokenSource = (Map)accessTokenSource.get("user_token");
                                listener.onResponse((Object)UserToken.fromSourceMap(userTokenSource));
                            }
                        } else {
                            listener.onFailure((Exception)new IllegalStateException("token document is missing and must be present"));
                        }
                    }, e -> {
                        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                            this.logger.warn("failed to get token [{}] since index is not available", tokenId);
                            listener.onResponse(null);
                        } else {
                            this.logger.error((Message)new ParameterizedMessage("failed to get token [{}]", tokenId), (Throwable)e);
                            listener.onFailure(e);
                        }
                    }), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
                }), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                TokenService.decryptToken(in, cipher, version, (ActionListener<UserToken>)listener);
            }
        }
        catch (GeneralSecurityException e) {
            this.logger.warn("invalid token", (Throwable)e);
            listener.onResponse(null);
        }
        finally {
            in.close();
        }
    }

    private static final class TokenKeys {
        final Map<BytesKey, KeyAndCache> cache;
        final BytesKey currentTokenKeyHash;
        final KeyAndCache activeKeyCache;

        private TokenKeys(Map<BytesKey, KeyAndCache> cache, BytesKey currentTokenKeyHash) {
            this.cache = cache;
            this.currentTokenKeyHash = currentTokenKeyHash;
            this.activeKeyCache = cache.get(currentTokenKeyHash);
        }

        KeyAndCache get(BytesKey passphraseHash) {
            return this.cache.get(passphraseHash);
        }
    }

    static final class KeyAndCache
    implements Closeable {
        private final KeyAndTimestamp keyAndTimestamp;
        private final Cache<BytesKey, SecretKey> keyCache;
        private final BytesKey salt;
        private final BytesKey keyHash;

        private KeyAndCache(KeyAndTimestamp keyAndTimestamp, BytesKey salt) {
            this.keyAndTimestamp = keyAndTimestamp;
            this.keyCache = CacheBuilder.builder().setExpireAfterAccess(TimeValue.timeValueMinutes((long)60L)).setMaximumWeight(500L).build();
            try {
                SecretKey secretKey = TokenService.computeSecretKey(keyAndTimestamp.getKey().getChars(), salt.bytes);
                this.keyCache.put((Object)salt, (Object)secretKey);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.salt = salt;
            this.keyHash = KeyAndCache.calculateKeyHash(keyAndTimestamp.getKey());
        }

        private SecretKey getKey(BytesKey salt) {
            return (SecretKey)this.keyCache.get((Object)salt);
        }

        public SecretKey getOrComputeKey(BytesKey decodedSalt) throws ExecutionException {
            return (SecretKey)this.keyCache.computeIfAbsent((Object)decodedSalt, salt -> {
                try (SecureString closeableChars = this.keyAndTimestamp.getKey().clone();){
                    SecretKey secretKey = TokenService.computeSecretKey(closeableChars.getChars(), salt.bytes);
                    return secretKey;
                }
            });
        }

        @Override
        public void close() {
            this.keyAndTimestamp.getKey().close();
        }

        BytesKey getKeyHash() {
            return this.keyHash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static BytesKey calculateKeyHash(SecureString key) {
            MessageDigest messageDigest = MessageDigests.sha256();
            BytesRefBuilder b = new BytesRefBuilder();
            try {
                BytesKey bytesKey;
                b.copyChars((CharSequence)key);
                BytesRef bytesRef = b.toBytesRef();
                try {
                    messageDigest.update(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                    bytesKey = new BytesKey(Arrays.copyOfRange(messageDigest.digest(), 0, 8));
                }
                catch (Throwable throwable) {
                    Arrays.fill(bytesRef.bytes, (byte)0);
                    throw throwable;
                }
                Arrays.fill(bytesRef.bytes, (byte)0);
                return bytesKey;
            }
            finally {
                Arrays.fill(b.bytes(), (byte)0);
            }
        }

        BytesKey getSalt() {
            return this.salt;
        }
    }

    private final class TokenMetadataPublishAction
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final TokenMetaData tokenMetaData;

        protected TokenMetadataPublishAction(ActionListener<ClusterStateUpdateResponse> listener, TokenMetaData tokenMetaData) {
            super(new AckedRequest(){

                public TimeValue ackTimeout() {
                    return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
                }

                public TimeValue masterNodeTimeout() {
                    return AcknowledgedRequest.DEFAULT_MASTER_NODE_TIMEOUT;
                }
            }, listener);
            this.tokenMetaData = tokenMetaData;
        }

        public ClusterState execute(ClusterState currentState) throws Exception {
            XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)currentState);
            if (this.tokenMetaData.equals((Object)currentState.custom("security_tokens"))) {
                return currentState;
            }
            return ClusterState.builder((ClusterState)currentState).putCustom("security_tokens", (ClusterState.Custom)this.tokenMetaData).build();
        }

        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }
    }

    private class KeyComputingRunnable
    extends AbstractRunnable {
        private final BytesKey decodedSalt;
        private final ActionListener<SecretKey> listener;
        private final KeyAndCache keyAndCache;

        KeyComputingRunnable(BytesKey decodedSalt, ActionListener<SecretKey> listener, KeyAndCache keyAndCache) {
            this.decodedSalt = decodedSalt;
            this.listener = listener;
            this.keyAndCache = keyAndCache;
        }

        protected void doRun() {
            try {
                SecretKey computedKey = this.keyAndCache.getOrComputeKey(this.decodedSalt);
                this.listener.onResponse((Object)computedKey);
            }
            catch (ExecutionException e) {
                if (e.getCause() != null && (e.getCause() instanceof GeneralSecurityException || e.getCause() instanceof IOException || e.getCause() instanceof IllegalArgumentException)) {
                    TokenService.this.logger.debug("unable to decode bearer token", (Throwable)e);
                    this.listener.onResponse(null);
                }
                this.listener.onFailure((Exception)e);
            }
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

