/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.Watcher;

public class WatcherClientHelper {
    public static <T extends ActionResponse> T execute(Watch watch, Client client, Supplier<T> supplier) {
        if (watch.status().getHeaders().isEmpty()) {
            try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"watcher");){
                ActionResponse actionResponse = (ActionResponse)supplier.get();
                return (T)actionResponse;
            }
        }
        try (ThreadContext.StoredContext ignored = client.threadPool().getThreadContext().stashContext();){
            Map<String, String> filteredHeaders = watch.status().getHeaders().entrySet().stream().filter(e -> Watcher.HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            client.threadPool().getThreadContext().copyHeaders(filteredHeaders.entrySet());
            ActionResponse actionResponse = (ActionResponse)supplier.get();
            return (T)actionResponse;
        }
    }
}

