/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.token;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class CreateTokenResponse
extends ActionResponse
implements ToXContentObject {
    private String tokenString;
    private TimeValue expiresIn;
    private String scope;
    private String refreshToken;

    CreateTokenResponse() {
    }

    public CreateTokenResponse(String tokenString, TimeValue expiresIn, String scope, String refreshToken) {
        this.tokenString = Objects.requireNonNull(tokenString);
        this.expiresIn = Objects.requireNonNull(expiresIn);
        this.scope = scope;
        this.refreshToken = refreshToken;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getScope() {
        return this.scope;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.tokenString);
        out.writeTimeValue(this.expiresIn);
        out.writeOptionalString(this.scope);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeString(this.refreshToken);
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tokenString = in.readString();
        this.expiresIn = in.readTimeValue();
        this.scope = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
            this.refreshToken = in.readString();
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("access_token", this.tokenString).field("type", "Bearer").field("expires_in", this.expiresIn.seconds());
        if (this.refreshToken != null) {
            builder.field("refresh_token", this.refreshToken);
        }
        if (this.scope != null) {
            builder.field("scope", this.scope);
        }
        return builder.endObject();
    }
}

