/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authc.ldap.ActiveDirectorySessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapUserSearchSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapMetaDataResolverSettings;
import org.elasticsearch.xpack.core.security.authc.support.CachingUsernamePasswordRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.mapper.CompositeRoleMapperSettings;

public final class LdapRealmSettings {
    public static final String LDAP_TYPE = "ldap";
    public static final String AD_TYPE = "active_directory";
    public static final Setting<TimeValue> EXECUTION_TIMEOUT = Setting.timeSetting((String)"timeout.execution", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    private LdapRealmSettings() {
    }

    public static Set<Setting<?>> getSettings(String type) {
        HashSet settings = new HashSet();
        settings.addAll(CachingUsernamePasswordRealmSettings.getCachingSettings());
        settings.addAll(CompositeRoleMapperSettings.getSettings());
        settings.add(EXECUTION_TIMEOUT);
        if (AD_TYPE.equals(type)) {
            settings.addAll(ActiveDirectorySessionFactorySettings.getSettings());
        } else {
            assert (LDAP_TYPE.equals(type)) : "type [" + type + "] is unknown. expected one of [" + "active_directory" + ", " + "ldap" + "]";
            settings.addAll(LdapSessionFactorySettings.getSettings());
            settings.addAll(LdapUserSearchSessionFactorySettings.getSettings());
        }
        settings.addAll(LdapMetaDataResolverSettings.getSettings());
        return settings;
    }
}

