/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.keyvalue.mapping.config;

import org.grails.datastore.mapping.config.AbstractGormMappingFactory;
import org.grails.datastore.mapping.keyvalue.mapping.config.Family;
import org.grails.datastore.mapping.keyvalue.mapping.config.KeyValue;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;

public class GormKeyValueMappingFactory
extends AbstractGormMappingFactory<Family, KeyValue> {
    private String keyspace;

    public GormKeyValueMappingFactory(String keyspace) {
        this.keyspace = keyspace;
    }

    @Override
    public Family createMappedForm(PersistentEntity entity) {
        Family family = (Family)super.createMappedForm(entity);
        if (family.getKeyspace() == null) {
            family.setKeyspace(this.keyspace);
        }
        if (family.getFamily() == null) {
            family.setFamily(entity.getName());
        }
        return family;
    }

    @Override
    public KeyValue createMappedForm(PersistentProperty mpp) {
        KeyValue kv = (KeyValue)super.createMappedForm(mpp);
        if (kv.getKey() == null) {
            kv.setKey(mpp.getName());
        }
        return kv;
    }

    @Override
    protected Class<KeyValue> getPropertyMappedFormType() {
        return KeyValue.class;
    }

    @Override
    protected Class<Family> getEntityMappedFormType() {
        return Family.class;
    }

    @Override
    protected IdentityMapping getIdentityMappedForm(ClassMapping classMapping, KeyValue property) {
        if (property != null) {
            return this.createDefaultIdentityMapping(classMapping, property);
        }
        return super.getIdentityMappedForm(classMapping, null);
    }
}

