/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.grails.datastore.mapping.config.AbstractGormMappingFactory;
import org.grails.datastore.mapping.config.ConfigurationUtils;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.engine.BeanEntityAccess;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.IllegalMappingException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.lifecycle.Initializable;
import org.grails.datastore.mapping.model.types.conversion.DefaultConversionService;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.proxy.JavassistProxyFactory;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.proxy.ProxyHandler;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.grails.datastore.mapping.reflect.FieldEntityAccess;
import org.grails.datastore.mapping.validation.ValidatorRegistry;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Validator;

public abstract class AbstractMappingContext
implements MappingContext,
Initializable {
    public static final String GROOVY_PROXY_FACTORY_NAME = "org.grails.datastore.gorm.proxy.GroovyProxyFactory";
    public static final String JAVASIST_PROXY_FACTORY = "javassist.util.proxy.ProxyFactory";
    public static final String CONFIGURATION_PREFIX = "grails.gorm.";
    protected Collection<PersistentEntity> persistentEntities = new ConcurrentLinkedQueue<PersistentEntity>();
    protected Map<String, PersistentEntity> persistentEntitiesByName = new ConcurrentHashMap<String, PersistentEntity>();
    protected Map<PersistentEntity, Map<String, PersistentEntity>> persistentEntitiesByDiscriminator = new ConcurrentHashMap<PersistentEntity, Map<String, PersistentEntity>>();
    protected Map<PersistentEntity, Collection<PersistentEntity>> persistentEntitiesByParent = new ConcurrentHashMap<PersistentEntity, Collection<PersistentEntity>>();
    protected Map<PersistentEntity, Validator> entityValidators = new ConcurrentHashMap<PersistentEntity, Validator>();
    protected Collection<MappingContext.Listener> eventListeners = new ConcurrentLinkedQueue<MappingContext.Listener>();
    protected GenericConversionService conversionService = new DefaultConversionService();
    protected ProxyFactory proxyFactory;
    protected ValidatorRegistry validatorRegistry;
    private boolean canInitializeEntities = true;
    private boolean initialized;
    private MultiTenancySettings.MultiTenancyMode multiTenancyMode;

    public AbstractMappingContext() {
        this.multiTenancyMode = MultiTenancySettings.MultiTenancyMode.NONE;
    }

    public AbstractMappingContext(ConnectionSourceSettings settings) {
        FieldEntityAccess.clearReflectors();
        this.initialize(settings);
    }

    @Override
    public MultiTenancySettings.MultiTenancyMode getMultiTenancyMode() {
        return this.multiTenancyMode;
    }

    protected void initialize(ConnectionSourceSettings settings) {
        this.multiTenancyMode = settings.getMultiTenancy().getMode();
        MappingFactory mappingFactory = this.getMappingFactory();
        Iterable<CustomTypeMarshaller> customTypeMarshallers = ConfigurationUtils.findServices(settings.getCustom().getTypes(), CustomTypeMarshaller.class);
        for (CustomTypeMarshaller customTypeMarshaller : customTypeMarshallers) {
            if (!customTypeMarshaller.supports(this)) continue;
            mappingFactory.registerCustomType(customTypeMarshaller);
        }
        if (mappingFactory instanceof AbstractGormMappingFactory) {
            AbstractGormMappingFactory gormMappingFactory = (AbstractGormMappingFactory)mappingFactory;
            gormMappingFactory.setDefaultConstraints(settings.getDefault().getConstraints());
            gormMappingFactory.setDefaultMapping(settings.getDefault().getMapping());
        }
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public ConverterRegistry getConverterRegistry() {
        return this.conversionService;
    }

    public void setCanInitializeEntities(boolean canInitializeEntities) {
        this.canInitializeEntities = canInitializeEntities;
    }

    @Override
    public abstract MappingFactory getMappingFactory();

    public void configure(PropertyResolver configuration) {
        String suffix;
        if (configuration == null) {
            return;
        }
        String simpleName = Introspector.decapitalize(this.getClass().getSimpleName());
        if (simpleName.endsWith(suffix = "MappingContext")) {
            simpleName = simpleName.substring(0, simpleName.length() - suffix.length());
        }
        String prefix = CONFIGURATION_PREFIX + simpleName;
        String configurationKey = prefix + ".custom.types";
        Iterable<CustomTypeMarshaller> customTypeMarshallers = ConfigurationUtils.findServices(configuration, configurationKey, CustomTypeMarshaller.class);
        for (CustomTypeMarshaller customTypeMarshaller : customTypeMarshallers) {
            if (!customTypeMarshaller.supports(this)) continue;
            this.getMappingFactory().registerCustomType(customTypeMarshaller);
        }
    }

    @Override
    public ProxyHandler getProxyHandler() {
        return this.getProxyFactory();
    }

    @Override
    public ProxyFactory getProxyFactory() {
        if (this.proxyFactory == null) {
            ClassLoader classLoader = AbstractMappingContext.class.getClassLoader();
            if (ClassUtils.isPresent((String)JAVASIST_PROXY_FACTORY, (ClassLoader)classLoader)) {
                this.proxyFactory = DefaultProxyFactoryCreator.create();
            } else if (ClassUtils.isPresent((String)GROOVY_PROXY_FACTORY_NAME, (ClassLoader)classLoader)) {
                try {
                    this.proxyFactory = (ProxyFactory)BeanUtils.instantiate((Class)ClassUtils.forName((String)GROOVY_PROXY_FACTORY_NAME, (ClassLoader)classLoader));
                }
                catch (ClassNotFoundException e) {
                    this.proxyFactory = DefaultProxyFactoryCreator.create();
                }
            } else {
                this.proxyFactory = DefaultProxyFactoryCreator.create();
            }
        }
        return this.proxyFactory;
    }

    @Override
    public void addMappingContextListener(MappingContext.Listener listener) {
        if (listener != null) {
            this.eventListeners.add(listener);
        }
    }

    @Override
    public void setProxyFactory(ProxyFactory factory) {
        if (factory != null) {
            this.proxyFactory = factory;
        }
    }

    @Override
    public void setValidatorRegistry(ValidatorRegistry validatorRegistry) {
        this.validatorRegistry = validatorRegistry;
    }

    @Override
    public ValidatorRegistry getValidatorRegistry() {
        return this.validatorRegistry;
    }

    @Override
    public void addTypeConverter(Converter converter) {
        this.conversionService.addConverter(converter);
    }

    @Override
    public Validator getEntityValidator(PersistentEntity entity) {
        if (entity != null) {
            Validator v;
            Validator validator = this.entityValidators.get(entity);
            if (validator == null && this.validatorRegistry != null && (v = this.validatorRegistry.getValidator(entity)) != null) {
                this.entityValidators.put(entity, v);
                return v;
            }
            return validator;
        }
        return null;
    }

    @Override
    public void addEntityValidator(PersistentEntity entity, Validator validator) {
        if (entity != null && validator != null) {
            this.entityValidators.put(entity, validator);
        }
    }

    @Override
    public PersistentEntity addExternalPersistentEntity(Class javaClass) {
        Assert.notNull((Object)javaClass, (String)"PersistentEntity class cannot be null");
        PersistentEntity entity = this.persistentEntitiesByName.get(javaClass.getName());
        if (entity == null) {
            entity = this.addPersistentEntityInternal(javaClass, true, this.canInitializeEntities);
        }
        return entity;
    }

    @Override
    public PersistentEntity addPersistentEntity(Class javaClass, boolean override) {
        Assert.notNull((Object)javaClass, (String)"PersistentEntity class cannot be null");
        if (override) {
            return this.addPersistentEntityInternal(javaClass, false, this.canInitializeEntities);
        }
        return this.addPersistentEntity(javaClass);
    }

    @Override
    public Collection<PersistentEntity> addPersistentEntities(Class ... javaClasses) {
        ArrayList<PersistentEntity> entities = new ArrayList<PersistentEntity>();
        for (Class javaClass : javaClasses) {
            PersistentEntity entity = this.createPersistentEntity(javaClass);
            if (entity == null) continue;
            this.registerEntityWithContext(entity);
            entities.add(entity);
        }
        if (this.canInitializeEntities) {
            for (PersistentEntity entity : entities) {
                this.initializePersistentEntity(entity);
            }
        }
        for (MappingContext.Listener eventListener : this.eventListeners) {
            for (PersistentEntity entity : entities) {
                eventListener.persistentEntityAdded(entity);
            }
        }
        ClassPropertyFetcher.clearCache();
        return entities;
    }

    @Override
    public PersistentEntity addPersistentEntity(Class javaClass) {
        Assert.notNull((Object)javaClass, (String)"PersistentEntity class cannot be null");
        PersistentEntity entity = this.persistentEntitiesByName.get(javaClass.getName());
        if (entity == null) {
            entity = this.addPersistentEntityInternal(javaClass, false, this.canInitializeEntities);
        }
        return entity;
    }

    private PersistentEntity addPersistentEntityInternal(Class javaClass, boolean isExternal, boolean isInitialize) {
        PersistentEntity entity = this.createPersistentEntity(javaClass, isExternal);
        if (entity == null) {
            return null;
        }
        entity.setExternal(isExternal);
        this.registerEntityWithContext(entity);
        if (isInitialize) {
            this.initializePersistentEntity(entity);
        }
        for (MappingContext.Listener eventListener : this.eventListeners) {
            eventListener.persistentEntityAdded(entity);
        }
        ClassPropertyFetcher.clearCache();
        return entity;
    }

    private void registerEntityWithContext(PersistentEntity entity) {
        this.persistentEntities.remove(entity);
        this.persistentEntities.add(entity);
        this.persistentEntitiesByName.put(entity.getName(), entity);
    }

    @Override
    public void initialize() {
        for (PersistentEntity entity : this.persistentEntities) {
            this.initializePersistentEntity(entity);
            FieldEntityAccess.getOrIntializeReflector(entity);
        }
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private void initializePersistentEntity(PersistentEntity entity) {
        try {
            entity.initialize();
        }
        catch (IllegalMappingException x) {
            this.persistentEntities.remove(entity);
            this.persistentEntitiesByName.remove(entity.getName());
            throw x;
        }
        if (!entity.isRoot()) {
            PersistentEntity parent = entity.getParentEntity();
            Collection<PersistentEntity> directChildren = this.persistentEntitiesByParent.get(parent);
            if (directChildren == null) {
                directChildren = new HashSet<PersistentEntity>();
                this.persistentEntitiesByParent.put(parent, directChildren);
            }
            directChildren.add(entity);
            while (parent != null) {
                Map<String, PersistentEntity> children;
                if (!parent.isInitialized()) {
                    parent.initialize();
                }
                if ((children = this.persistentEntitiesByDiscriminator.get(parent)) == null) {
                    children = new ConcurrentHashMap<String, PersistentEntity>();
                    this.persistentEntitiesByDiscriminator.put(parent, children);
                }
                children.put(entity.getDiscriminator(), entity);
                parent = parent.getParentEntity();
            }
        }
    }

    @Override
    public boolean isInInheritanceHierarchy(PersistentEntity entity) {
        if (entity != null) {
            if (!entity.isRoot()) {
                return true;
            }
            PersistentEntity rootEntity = entity.getRootEntity();
            Map<String, PersistentEntity> children = this.persistentEntitiesByDiscriminator.get(rootEntity);
            if (children != null && !children.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<PersistentEntity> getChildEntities(PersistentEntity root) {
        Map<String, PersistentEntity> children = this.persistentEntitiesByDiscriminator.get(root);
        if (children != null) {
            return Collections.unmodifiableCollection(children.values());
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<PersistentEntity> getDirectChildEntities(PersistentEntity root) {
        Collection<PersistentEntity> entities = this.persistentEntitiesByParent.get(root);
        if (entities == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(entities);
    }

    @Override
    public PersistentEntity getChildEntityByDiscriminator(PersistentEntity root, String discriminator) {
        Map<String, PersistentEntity> children = this.persistentEntitiesByDiscriminator.get(root);
        if (children != null) {
            return children.get(discriminator);
        }
        return null;
    }

    protected abstract PersistentEntity createPersistentEntity(Class var1);

    protected Object resolveMappingStrategy(Class javaClass) {
        try {
            Field field = javaClass.getDeclaredField("mapWith");
            if (field == null) break block4;
            if (Modifier.isStatic(field.getModifiers())) {
                field.setAccessible(true);
                return field.get(javaClass);
            }
        }
        finally {
            return null;
        }
        {
            block4: {
            }
        }
    }

    protected boolean isValidMappingStrategy(Class javaClass, Object mappingStrategy) {
        String suffix;
        if (mappingStrategy == null) {
            return true;
        }
        String name = this.getClass().getSimpleName();
        if (name.endsWith(suffix = MappingContext.class.getSimpleName())) {
            name = name.substring(0, name.length() - suffix.length()).toLowerCase(Locale.ENGLISH);
            return name.equalsIgnoreCase(mappingStrategy.toString());
        }
        return false;
    }

    protected PersistentEntity createPersistentEntity(Class javaClass, boolean external) {
        return this.createPersistentEntity(javaClass);
    }

    @Override
    public PersistentEntity createEmbeddedEntity(Class type) {
        EmbeddedPersistentEntity embedded = new EmbeddedPersistentEntity(type, this);
        embedded.initialize();
        return embedded;
    }

    @Override
    public Collection<PersistentEntity> getPersistentEntities() {
        return this.persistentEntities;
    }

    @Override
    public boolean isPersistentEntity(Class type) {
        return type != null && this.getPersistentEntity(type.getName()) != null;
    }

    @Override
    public boolean isPersistentEntity(Object value) {
        return value != null && this.isPersistentEntity(value.getClass());
    }

    @Override
    public PersistentEntity getPersistentEntity(String name) {
        int proxyIndicator = name.indexOf("_$$_");
        if (proxyIndicator > -1) {
            name = name.substring(0, proxyIndicator);
        }
        return this.persistentEntitiesByName.get(name);
    }

    @Override
    public EntityReflector getEntityReflector(PersistentEntity entity) {
        return FieldEntityAccess.getOrIntializeReflector(entity);
    }

    @Override
    public EntityAccess createEntityAccess(PersistentEntity entity, Object instance) {
        ProxyFactory proxyFactory = this.getProxyFactory();
        instance = proxyFactory.unwrap(instance);
        if (entity != null) {
            PersistentEntity subEntity;
            if (entity.getJavaClass() != instance.getClass() && (subEntity = this.getPersistentEntity(instance.getClass().getName())) != null) {
                entity = subEntity;
            }
            return new FieldEntityAccess(entity, instance, this.getConversionService());
        }
        EntityReflector reflector = FieldEntityAccess.getReflector(instance.getClass().getName());
        if (reflector != null) {
            return new FieldEntityAccess(reflector.getPersitentEntity(), instance, (ConversionService)this.conversionService);
        }
        return new BeanEntityAccess(null, instance);
    }

    private static class DefaultProxyFactoryCreator {
        private DefaultProxyFactoryCreator() {
        }

        public static ProxyFactory create() {
            return new JavassistProxyFactory();
        }
    }
}

