/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.spi.preferences.Config;

public class BoundingXYVisitor
implements OsmPrimitiveVisitor,
PrimitiveVisitor {
    private ProjectionBounds bounds;

    @Override
    public void visit(Node n) {
        this.visit((ILatLon)n);
    }

    @Override
    public void visit(Way w) {
        this.visit((IWay<?>)w);
    }

    @Override
    public void visit(Relation r) {
        this.visit((IRelation<?>)r);
    }

    @Override
    public void visit(INode n) {
        this.visit((ILatLon)n);
    }

    @Override
    public void visit(IWay<?> w) {
        if (w.isIncomplete()) {
            return;
        }
        for (INode n : w.getNodes()) {
            this.visit(n);
        }
    }

    @Override
    public void visit(IRelation<?> r) {
        for (IRelationMember m : r.getMembers()) {
            if (m.isRelation()) continue;
            m.getMember().accept(this);
        }
    }

    public void visit(Bounds b) {
        if (b != null) {
            Main.getProjection().visitOutline(b, this::visit);
        }
    }

    public void visit(ProjectionBounds b) {
        if (b != null) {
            this.visit(b.getMin());
            this.visit(b.getMax());
        }
    }

    public void visit(ILatLon latlon) {
        if (latlon != null) {
            this.visit(latlon.getEastNorth(Main.getProjection()));
        }
    }

    public void visit(LatLon latlon) {
        this.visit((ILatLon)latlon);
    }

    public void visit(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.bounds == null) {
                this.bounds = new ProjectionBounds(eastNorth);
            } else {
                this.bounds.extend(eastNorth);
            }
        }
    }

    public boolean hasExtend() {
        return this.bounds != null && this.bounds.hasExtend();
    }

    public ProjectionBounds getBounds() {
        return this.bounds;
    }

    public void enlargeBoundingBox() {
        this.enlargeBoundingBox(Config.getPref().getDouble("edit.zoom-enlarge-bbox", 0.002));
    }

    public void enlargeBoundingBox(double enlargeDegree) {
        if (this.bounds == null) {
            return;
        }
        LatLon minLatlon = Main.getProjection().eastNorth2latlon(this.bounds.getMin());
        LatLon maxLatlon = Main.getProjection().eastNorth2latlon(this.bounds.getMax());
        this.bounds = new ProjectionBounds(new LatLon(Math.max(-90.0, minLatlon.lat() - enlargeDegree), Math.max(-180.0, minLatlon.lon() - enlargeDegree)).getEastNorth(Main.getProjection()), new LatLon(Math.min(90.0, maxLatlon.lat() + enlargeDegree), Math.min(180.0, maxLatlon.lon() + enlargeDegree)).getEastNorth(Main.getProjection()));
    }

    public void enlargeBoundingBoxLogarithmically(double maxEnlargePercent) {
        if (this.bounds == null) {
            return;
        }
        double diffEast = this.bounds.getMax().east() - this.bounds.getMin().east();
        double diffNorth = this.bounds.getMax().north() - this.bounds.getMin().north();
        double enlargeEast = Math.min(maxEnlargePercent - 10.0 * Math.log(diffEast), 1.0) / 100.0;
        double enlargeNorth = Math.min(maxEnlargePercent - 10.0 * Math.log(diffNorth), 1.0) / 100.0;
        this.visit(this.bounds.getMin().add(-enlargeEast / 2.0, -enlargeNorth / 2.0));
        this.visit(this.bounds.getMax().add(enlargeEast / 2.0, enlargeNorth / 2.0));
    }

    public void enlargeToMinSize(double size) {
        if (this.bounds == null) {
            return;
        }
        MapFrame map = MainApplication.getMap();
        double enSize = size * map.mapView.getScale() / map.mapView.getDist100Pixel() * 100.0;
        this.visit(this.bounds.getMin().add(-enSize / 2.0, -enSize / 2.0));
        this.visit(this.bounds.getMax().add(enSize / 2.0, enSize / 2.0));
    }

    public String toString() {
        return "BoundingXYVisitor[" + this.bounds + ']';
    }

    public void computeBoundingBox(Collection<? extends IPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        for (IPrimitive iPrimitive : primitives) {
            if (iPrimitive == null) continue;
            iPrimitive.accept(this);
        }
    }
}

