/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractTagPaster
extends AbstractOsmDataPaster {
    AbstractTagPaster(DataFlavor df) {
        super(df);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support, OsmDataLayer layer, EastNorth pasteAt) throws UnsupportedFlavorException, IOException {
        Collection selection = layer.data.getSelected();
        if (selection.isEmpty()) {
            return false;
        }
        return this.importTagsOn(support, selection);
    }

    @Override
    public boolean importTagsOn(TransferHandler.TransferSupport support, Collection<? extends OsmPrimitive> selection) throws UnsupportedFlavorException, IOException {
        ChangePropertyCommand command = new ChangePropertyCommand(Main.main.getEditDataSet(), selection, this.getTags(support));
        AbstractTagPaster.commitCommands(selection, Collections.singletonList(command));
        return true;
    }

    protected static void commitCommands(Collection<? extends OsmPrimitive> selection, List<Command> commands) {
        if (!commands.isEmpty()) {
            String title1 = I18n.trn("Pasting {0} tag", "Pasting {0} tags", commands.size(), commands.size());
            String title2 = I18n.trn("to {0} object", "to {0} objects", selection.size(), selection.size());
            String title = title1 + ' ' + title2;
            MainApplication.undoRedo.add(new SequenceCommand(title, commands));
        }
    }

    protected abstract Map<String, String> getTags(TransferHandler.TransferSupport var1) throws UnsupportedFlavorException, IOException;
}

