/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTree;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ChildRelationBrowser
extends JPanel {
    private RelationTree childTree;
    private transient RelationTreeModel model;
    private transient OsmDataLayer layer;
    private EditAction editAction;

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.childTree = new RelationTree(this.model);
        JScrollPane pane = new JScrollPane(this.childTree);
        this.add((Component)pane, "Center");
        this.add((Component)this.buildButtonPanel(), "South");
        this.childTree.setToggleClickCount(0);
        this.childTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!(e.getClickCount() != 2 || e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isMetaDown() || e.isShiftDown() || ChildRelationBrowser.this.childTree.getRowForLocation(e.getX(), e.getY()) != ChildRelationBrowser.this.childTree.getMinSelectionRow())) {
                    Relation r = (Relation)ChildRelationBrowser.this.childTree.getLastSelectedPathComponent();
                    if (r.isIncomplete()) {
                        ChildRelationBrowser.this.childTree.expandPath(ChildRelationBrowser.this.childTree.getSelectionPath());
                    } else {
                        ChildRelationBrowser.this.editAction.actionPerformed(new ActionEvent(e.getSource(), 1001, null));
                    }
                }
            }
        });
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        DownloadAllChildRelationsAction downloadAction = new DownloadAllChildRelationsAction();
        pnl.add(new JButton(downloadAction));
        DownloadSelectedAction downloadSelectedAction = new DownloadSelectedAction();
        this.childTree.addTreeSelectionListener(downloadSelectedAction);
        pnl.add(new JButton(downloadSelectedAction));
        this.editAction = new EditAction();
        this.childTree.addTreeSelectionListener(this.editAction);
        pnl.add(new JButton(this.editAction));
        return pnl;
    }

    public ChildRelationBrowser(OsmDataLayer layer) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.model = new RelationTreeModel();
        this.build();
    }

    public ChildRelationBrowser(OsmDataLayer layer, Relation root) {
        this(layer);
        this.populate(root);
    }

    public void populate(Relation r) {
        this.model.populate(r);
    }

    public void populate(List<RelationMember> members) {
        this.model.populate(members);
    }

    protected Dialog getParentDialog() {
        Container c;
        for (c = this; c != null && !(c instanceof Dialog); c = c.getParent()) {
        }
        return (Dialog)c;
    }

    class DownloadRelationSetTask
    extends DownloadTask {
        private final Set<Relation> relations;

        DownloadRelationSetTask(Dialog parent, Set<Relation> relations) {
            super(I18n.tr("Download relation members", new Object[0]), parent);
            this.relations = relations;
        }

        protected void mergeDataSet(DataSet dataSet) {
            if (dataSet != null) {
                DataSetMerger visitor = new DataSetMerger(ChildRelationBrowser.this.getLayer().getDataSet(), dataSet);
                visitor.merge();
                if (!visitor.getConflicts().isEmpty()) {
                    ChildRelationBrowser.this.getLayer().getConflicts().add(visitor.getConflicts());
                    this.conflictsCount += visitor.getConflicts().size();
                }
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                Iterator<Relation> it = this.relations.iterator();
                while (it.hasNext() && !this.canceled) {
                    Relation r = it.next();
                    if (r.isNew()) continue;
                    this.progressMonitor.setCustomText(I18n.tr("Downloading relation {0}", r.getDisplayName(DefaultNameFormatter.getInstance())));
                    OsmServerObjectReader reader = new OsmServerObjectReader(r.getId(), OsmPrimitiveType.RELATION, true);
                    DataSet dataSet = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                    this.mergeDataSet(dataSet);
                    this.refreshView(r);
                }
            }
            catch (OsmTransferException e) {
                if (this.canceled) {
                    Logging.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }

    class DownloadAllChildrenTask
    extends DownloadTask {
        private final Stack<Relation> relationsToDownload;
        private final Set<Long> downloadedRelationIds;

        DownloadAllChildrenTask(Dialog parent, Relation r) {
            super(I18n.tr("Download relation members", new Object[0]), parent);
            this.relationsToDownload = new Stack();
            this.downloadedRelationIds = new HashSet<Long>();
            this.relationsToDownload.push(r);
        }

        protected void warnBecauseOfDeletedRelation(Relation r) {
            String message = I18n.tr("<html>The child relation<br>{0}<br>is deleted on the server. It cannot be loaded</html>", Utils.escapeReservedCharactersHTML(r.getDisplayName(DefaultNameFormatter.getInstance())));
            JOptionPane.showMessageDialog(Main.parent, message, I18n.tr("Relation is deleted", new Object[0]), 2);
        }

        protected void rememberChildRelationsToDownload(Relation parent) {
            this.downloadedRelationIds.add(parent.getId());
            for (RelationMember member : parent.getMembers()) {
                Relation child;
                if (!member.isRelation() || this.downloadedRelationIds.contains((child = member.getRelation()).getId())) continue;
                this.relationsToDownload.push(child);
            }
        }

        protected void mergeDataSet(DataSet ds) {
            if (ds != null) {
                DataSetMerger visitor = new DataSetMerger(ChildRelationBrowser.this.getLayer().getDataSet(), ds);
                visitor.merge();
                if (!visitor.getConflicts().isEmpty()) {
                    ChildRelationBrowser.this.getLayer().getConflicts().add(visitor.getConflicts());
                    this.conflictsCount += visitor.getConflicts().size();
                }
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                while (!this.relationsToDownload.isEmpty() && !this.canceled) {
                    Relation r = this.relationsToDownload.pop();
                    if (r.isNew()) continue;
                    this.rememberChildRelationsToDownload(r);
                    this.progressMonitor.setCustomText(I18n.tr("Downloading relation {0}", r.getDisplayName(DefaultNameFormatter.getInstance())));
                    OsmServerObjectReader reader = new OsmServerObjectReader(r.getId(), OsmPrimitiveType.RELATION, true);
                    DataSet dataSet = null;
                    try {
                        dataSet = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                    }
                    catch (OsmApiException e) {
                        if (e.getResponseCode() == 410) {
                            this.warnBecauseOfDeletedRelation(r);
                            continue;
                        }
                        throw e;
                    }
                    this.mergeDataSet(dataSet);
                    this.refreshView(r);
                }
                SwingUtilities.invokeLater(MainApplication.getMap()::repaint);
            }
            catch (OsmTransferException e) {
                if (this.canceled) {
                    Logging.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }

    abstract class DownloadTask
    extends PleaseWaitRunnable {
        protected boolean canceled;
        protected int conflictsCount;
        protected Exception lastException;

        DownloadTask(String title, Dialog parent) {
            super(title, new PleaseWaitProgressMonitor(parent), false);
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            OsmApi.getOsmApi().cancel();
        }

        protected void refreshView(Relation relation) {
            for (int i = 0; i < ChildRelationBrowser.this.childTree.getRowCount(); ++i) {
                Relation reference = (Relation)ChildRelationBrowser.this.childTree.getPathForRow(i).getLastPathComponent();
                if (reference != relation) continue;
                ChildRelationBrowser.this.model.refreshNode(ChildRelationBrowser.this.childTree.getPathForRow(i));
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.conflictsCount > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("There was {0} conflict during import.", "There were {0} conflicts during import.", this.conflictsCount, this.conflictsCount), I18n.trn("Conflict in data", "Conflicts in data", this.conflictsCount, new Object[0]), 2);
            }
        }
    }

    class DownloadSelectedAction
    extends AbstractAction
    implements TreeSelectionListener {
        DownloadSelectedAction() {
            this.putValue("ShortDescription", I18n.tr("Download selected relations", new Object[0]));
            new ImageProvider("download").getResource().attachImageIcon(this, true);
            this.putValue("Name", I18n.tr("Download Selected Children", new Object[0]));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            this.setEnabled(selection != null && selection.length > 0);
        }

        public void run() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            if (selection == null || selection.length == 0) {
                return;
            }
            HashSet<Relation> relations = new HashSet<Relation>();
            for (TreePath aSelection : selection) {
                relations.add((Relation)aSelection.getLastPathComponent());
            }
            MainApplication.worker.submit(new DownloadRelationSetTask(ChildRelationBrowser.this.getParentDialog(), relations));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class DownloadAllChildRelationsAction
    extends AbstractAction {
        DownloadAllChildRelationsAction() {
            this.putValue("ShortDescription", I18n.tr("Download all child relations (recursively)", new Object[0]));
            new ImageProvider("download").getResource().attachImageIcon(this, true);
            this.putValue("Name", I18n.tr("Download All Children", new Object[0]));
        }

        public void run() {
            MainApplication.worker.submit(new DownloadAllChildrenTask(ChildRelationBrowser.this.getParentDialog(), (Relation)ChildRelationBrowser.this.model.getRoot()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }
    }

    class EditAction
    extends AbstractAction
    implements TreeSelectionListener {
        EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to", new Object[0]));
            new ImageProvider("dialogs", "edit").getResource().attachImageIcon(this, true);
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            this.setEnabled(selection != null && selection.length > 0);
        }

        public void run() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            if (selection == null || selection.length == 0) {
                return;
            }
            for (int i = 0; i < Math.min(selection.length, 10); ++i) {
                Relation r = (Relation)selection[i].getLastPathComponent();
                if (r.isIncomplete()) continue;
                RelationEditor editor = RelationEditor.getEditor(ChildRelationBrowser.this.getLayer(), r, null);
                editor.setVisible(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.refreshEnabled();
        }
    }
}

