/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class ParentRelationLoadingTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private DataSet referrers;
    private final boolean full;
    private final OsmDataLayer layer;
    private final Relation child;
    private final List<Relation> parents;
    private Runnable continuation;

    public ParentRelationLoadingTask(Relation child, OsmDataLayer layer, boolean full, PleaseWaitProgressMonitor monitor) {
        super(I18n.tr("Download referring relations", new Object[0]), monitor, false);
        CheckParameterUtil.ensure(child, "child", "id > 0", ch -> ch.getUniqueId() > 0L);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (!layer.isDownloadable()) {
            throw new IllegalArgumentException("Non-downloadable layer: " + layer);
        }
        this.referrers = null;
        this.layer = layer;
        this.parents = new ArrayList<Relation>();
        this.child = child;
        this.full = full;
    }

    public void setContinuation(Runnable continuation) {
        this.continuation = continuation;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean hasError() {
        return this.lastException != null;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public List<Relation> getParents() {
        return this.parents;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
        OsmApi.getOsmApi().cancel();
    }

    protected void showLastException() {
        JOptionPane.showMessageDialog(Main.parent, Optional.ofNullable(this.lastException.getMessage()).orElseGet(this.lastException::toString), I18n.tr("Error", new Object[0]), 0);
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            this.showLastException();
            return;
        }
        this.parents.clear();
        for (Relation parent : this.referrers.getRelations()) {
            this.parents.add((Relation)this.getLayer().data.getPrimitiveById(parent));
        }
        if (this.continuation != null) {
            this.continuation.run();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.progressMonitor.indeterminateSubTask(null);
            OsmServerBackreferenceReader reader = new OsmServerBackreferenceReader(this.child, this.full);
            this.referrers = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(1, false));
            if (this.referrers != null) {
                DataSetMerger visitor = new DataSetMerger(this.getLayer().getDataSet(), this.referrers);
                visitor.merge();
                this.getLayer().getDataSet().addDataSources(this.referrers.getDataSources());
                SwingUtilities.invokeLater(this.getLayer()::onPostDownloadFromServer);
                if (visitor.getConflicts().isEmpty()) {
                    return;
                }
                this.getLayer().getConflicts().add(visitor.getConflicts());
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", visitor.getConflicts().size()), I18n.tr("Warning", new Object[0]), 2);
            }
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                Logging.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                return;
            }
            this.lastException = e;
        }
    }
}

