/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.io.NameFinder;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PlaceSelection
implements DownloadSelection {
    private static final String HISTORY_KEY = "download.places.history";
    private HistoryComboBox cbSearchExpression;
    private NamedResultTableModel model;
    private NamedResultTableColumnModel columnmodel;
    private JTable tblSearchResults;
    private DownloadDialog parent;
    private static final Server[] SERVERS = new Server[]{new Server("Nominatim", "https://nominatim.openstreetmap.org/search?format=xml&q=", I18n.tr("Class Type", new Object[0]), I18n.tr("Bounds", new Object[0]))};
    private final JosmComboBox<Server> server = new JosmComboBox<Server>(SERVERS);

    protected JPanel buildSearchPanel() {
        JPanel lpanel = new JPanel(new GridLayout(2, 2));
        JPanel panel = new JPanel(new GridBagLayout());
        lpanel.add(new JLabel(I18n.tr("Choose the server for searching:", new Object[0])));
        lpanel.add(this.server);
        String s = Config.getPref().get("namefinder.server", PlaceSelection.SERVERS[0].name);
        for (int i = 0; i < SERVERS.length; ++i) {
            if (!PlaceSelection.SERVERS[i].name.equals(s)) continue;
            this.server.setSelectedIndex(i);
        }
        lpanel.add(new JLabel(I18n.tr("Enter a place name to search for:", new Object[0])));
        this.cbSearchExpression = new HistoryComboBox();
        this.cbSearchExpression.setToolTipText(I18n.tr("Enter a place name to search for", new Object[0]));
        LinkedList<String> cmtHistory = new LinkedList<String>(Config.getPref().getList(HISTORY_KEY, new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        this.cbSearchExpression.setPossibleItems(cmtHistory);
        lpanel.add(this.cbSearchExpression);
        panel.add((Component)lpanel, GBC.std().fill(2).insets(5, 5, 0, 5));
        SearchAction searchAction = new SearchAction();
        JButton btnSearch = new JButton(searchAction);
        this.cbSearchExpression.getEditorComponent().getDocument().addDocumentListener(searchAction);
        this.cbSearchExpression.getEditorComponent().addActionListener(searchAction);
        panel.add((Component)btnSearch, GBC.eol().insets(5, 5, 0, 5));
        return panel;
    }

    @Override
    public void addGui(DownloadDialog gui) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildSearchPanel(), "North");
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new NamedResultTableModel(selectionModel);
        this.columnmodel = new NamedResultTableColumnModel();
        this.tblSearchResults = new JTable(this.model, this.columnmodel);
        this.tblSearchResults.setSelectionModel(selectionModel);
        JScrollPane scrollPane = new JScrollPane(this.tblSearchResults);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        panel.add((Component)scrollPane, "Center");
        if (gui != null) {
            gui.addDownloadAreaSelector(panel, I18n.tr("Areas around places", new Object[0]));
        }
        scrollPane.setPreferredSize(scrollPane.getPreferredSize());
        this.tblSearchResults.getSelectionModel().setSelectionMode(0);
        this.tblSearchResults.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
        this.tblSearchResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NameFinder.SearchResult sr;
                if (e.getClickCount() > 1 && (sr = PlaceSelection.this.model.getSelectedSearchResult()) != null) {
                    PlaceSelection.this.parent.startDownload(sr.getDownloadArea());
                }
            }
        });
        this.parent = gui;
    }

    @Override
    public void setDownloadArea(Bounds area) {
        this.tblSearchResults.clearSelection();
    }

    static class NamedResultCellRenderer
    extends JLabel
    implements TableCellRenderer {
        NamedResultCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        protected void reset() {
            this.setText("");
            this.setIcon(null);
        }

        protected void renderColor(boolean selected) {
            if (selected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("Table.foreground"));
                this.setBackground(UIManager.getColor("Table.background"));
            }
        }

        protected String lineWrapDescription(String description) {
            StringBuilder ret = new StringBuilder();
            StringBuilder line = new StringBuilder();
            StringTokenizer tok = new StringTokenizer(description, " ");
            while (tok.hasMoreElements()) {
                String t = tok.nextToken();
                if (line.length() == 0) {
                    line.append(t);
                    continue;
                }
                if (line.length() < 80) {
                    line.append(' ').append(t);
                    continue;
                }
                line.append(' ').append(t).append("<br>");
                ret.append((CharSequence)line);
                line = new StringBuilder();
            }
            ret.insert(0, "<html>");
            ret.append("</html>");
            return ret.toString();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.reset();
            this.renderColor(isSelected);
            if (value == null) {
                return this;
            }
            NameFinder.SearchResult sr = (NameFinder.SearchResult)value;
            switch (column) {
                case 0: {
                    this.setText(sr.getName());
                    break;
                }
                case 1: {
                    this.setText(sr.getInfo());
                    break;
                }
                case 2: {
                    this.setText(sr.getNearestPlace());
                    break;
                }
                case 3: {
                    if (sr.getBounds() != null) {
                        this.setText(sr.getBounds().toShortString(new DecimalFormat("0.000")));
                        break;
                    }
                    this.setText(sr.getZoom() != 0 ? Integer.toString(sr.getZoom()) : I18n.tr("unknown", new Object[0]));
                    break;
                }
            }
            this.setToolTipText(this.lineWrapDescription(sr.getDescription()));
            return this;
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            NameFinder.SearchResult r = PlaceSelection.this.model.getSelectedSearchResult();
            if (r != null) {
                PlaceSelection.this.parent.boundingBoxChanged(r.getDownloadArea(), PlaceSelection.this);
            }
        }
    }

    static class NamedResultTableColumnModel
    extends DefaultTableColumnModel {
        private TableColumn col3;
        private TableColumn col4;

        NamedResultTableColumnModel() {
            this.createColumns();
        }

        protected final void createColumns() {
            NamedResultCellRenderer renderer = new NamedResultCellRenderer();
            TableColumn col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("Name", new Object[0]));
            col.setResizable(true);
            col.setPreferredWidth(200);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("Type", new Object[0]));
            col.setResizable(true);
            col.setPreferredWidth(100);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            this.col3 = new TableColumn(2);
            this.col3.setHeaderValue(SERVERS[0].thirdcol);
            this.col3.setResizable(true);
            this.col3.setPreferredWidth(100);
            this.col3.setCellRenderer(renderer);
            this.addColumn(this.col3);
            this.col4 = new TableColumn(3);
            this.col4.setHeaderValue(SERVERS[0].fourthcol);
            this.col4.setResizable(true);
            this.col4.setPreferredWidth(50);
            this.col4.setCellRenderer(renderer);
            this.addColumn(this.col4);
        }

        public void setHeadlines(String third, String fourth) {
            this.col3.setHeaderValue(third);
            this.col4.setHeaderValue(fourth);
            this.fireColumnMarginChanged();
        }
    }

    static class NamedResultTableModel
    extends DefaultTableModel {
        private transient List<NameFinder.SearchResult> data = new ArrayList<NameFinder.SearchResult>();
        private final transient ListSelectionModel selectionModel;

        NamedResultTableModel(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.data != null ? this.data.get(row) : null;
        }

        public void setData(List<NameFinder.SearchResult> data) {
            if (data == null) {
                this.data.clear();
            } else {
                this.data = new ArrayList<NameFinder.SearchResult>(data);
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public NameFinder.SearchResult getSelectedSearchResult() {
            if (this.selectionModel.getMinSelectionIndex() < 0) {
                return null;
            }
            return this.data.get(this.selectionModel.getMinSelectionIndex());
        }
    }

    class NameQueryTask
    extends PleaseWaitRunnable {
        private final String searchExpression;
        private HttpClient connection;
        private List<NameFinder.SearchResult> data;
        private boolean canceled;
        private final Server useserver;
        private Exception lastException;

        NameQueryTask(String searchExpression) {
            super(I18n.tr("Querying name server", new Object[0]), false);
            this.searchExpression = searchExpression;
            this.useserver = (Server)PlaceSelection.this.server.getSelectedItem();
            Config.getPref().put("namefinder.server", this.useserver.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            this.canceled = true;
            NameQueryTask nameQueryTask = this;
            synchronized (nameQueryTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            PlaceSelection.this.columnmodel.setHeadlines(this.useserver.thirdcol, this.useserver.fourthcol);
            PlaceSelection.this.model.setData(this.data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            block19: {
                String urlString = this.useserver.url + Utils.encodeUrl(this.searchExpression);
                try {
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Querying name server ...", new Object[0]));
                    URL url = new URL(urlString);
                    NameQueryTask nameQueryTask = this;
                    synchronized (nameQueryTask) {
                        this.connection = HttpClient.create(url);
                        this.connection.connect();
                    }
                    try (BufferedReader reader = this.connection.getResponse().getContentReader();){
                        this.data = NameFinder.parseSearchResults(reader);
                    }
                }
                catch (SAXParseException e) {
                    if (!this.canceled) {
                        Logging.log(Logging.LEVEL_WARN, I18n.tr("Error occured with query ''{0}'': ''{1}''", urlString, e.getMessage()), e);
                        GuiHelper.runInEDTAndWait(() -> HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Name server returned invalid data. Please try again.", new Object[0]), I18n.tr("Bad response", new Object[0]), 2, null));
                    }
                }
                catch (IOException | ParserConfigurationException e) {
                    if (this.canceled) break block19;
                    OsmTransferException ex = new OsmTransferException(e);
                    ex.setUrl(urlString);
                    this.lastException = ex;
                }
            }
        }
    }

    class SearchAction
    extends AbstractAction
    implements DocumentListener {
        SearchAction() {
            this.putValue("Name", I18n.tr("Search...", new Object[0]));
            new ImageProvider("dialogs", "search").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Click to start searching for places", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled() || PlaceSelection.this.cbSearchExpression.getText().trim().isEmpty()) {
                return;
            }
            PlaceSelection.this.cbSearchExpression.addCurrentItemToHistory();
            Config.getPref().putList(PlaceSelection.HISTORY_KEY, PlaceSelection.this.cbSearchExpression.getHistory());
            NameQueryTask task = new NameQueryTask(PlaceSelection.this.cbSearchExpression.getText());
            MainApplication.worker.submit(task);
        }

        protected final void updateEnabledState() {
            this.setEnabled(!PlaceSelection.this.cbSearchExpression.getText().trim().isEmpty());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }
    }

    private static class Server {
        public final String name;
        public final String url;
        public final String thirdcol;
        public final String fourthcol;

        Server(String n, String u, String t, String f) {
            this.name = n;
            this.url = u;
            this.thirdcol = t;
            this.fourthcol = f;
        }

        public String toString() {
            return this.name;
        }
    }
}

