/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.io.CustomConfigurator;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class ExportProfileAction
extends AbstractAction {
    private final String prefPattern;
    private final String schemaKey;
    private final transient Preferences prefs;

    public ExportProfileAction(Preferences prefs, String schemaKey, String prefPattern) {
        super(I18n.tr("Save {0} profile", I18n.tr(schemaKey, new Object[0])));
        this.prefs = prefs;
        this.prefPattern = prefPattern;
        this.schemaKey = schemaKey;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        ArrayList<String> keys = new ArrayList<String>();
        Map<String, Setting<?>> all = this.prefs.getAllSettings();
        for (String key : all.keySet()) {
            if (!key.matches(this.prefPattern)) continue;
            keys.add(key);
        }
        if (keys.isEmpty()) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("All the preferences of this group are default, nothing to save", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            }
            return;
        }
        File f = this.askUserForCustomSettingsFile();
        if (f != null) {
            CustomConfigurator.exportPreferencesKeysToFile(f.getAbsolutePath(), false, keys);
        }
    }

    private File askUserForCustomSettingsFile() {
        AbstractFileChooser fc;
        String title = I18n.tr("Choose profile file", new Object[0]);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || Utils.hasExtension(f, "xml") && f.getName().toLowerCase(Locale.ENGLISH).startsWith(ExportProfileAction.this.schemaKey);
            }

            @Override
            public String getDescription() {
                return I18n.tr("JOSM custom settings files (*.xml)", new Object[0]);
            }
        };
        if (!GraphicsEnvironment.isHeadless() && (fc = DiskAccessAction.createAndOpenFileChooser(false, false, title, filter, 0, "customsettings.lastDirectory")) != null) {
            File sel = fc.getSelectedFile();
            if (!sel.getName().endsWith(".xml")) {
                sel = new File(sel.getAbsolutePath() + ".xml");
            }
            if (!sel.getName().startsWith(this.schemaKey)) {
                sel = new File(sel.getParentFile().getAbsolutePath() + '/' + this.schemaKey + '_' + sel.getName());
            }
            return sel;
        }
        return null;
    }
}

