/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SchemaFactoryConfigurationError;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlUtils {
    private XmlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaFactory newXmlSchemaFactory() {
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        catch (SchemaFactoryConfigurationError e) {
            Logging.debug(e);
            Thread currentThread = Thread.currentThread();
            ClassLoader old = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(null);
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                return schemaFactory;
            }
            finally {
                currentThread.setContextClassLoader(old);
            }
        }
    }

    public static DocumentBuilder newSafeDOMBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        builderFactory.setNamespaceAware(true);
        builderFactory.setValidating(false);
        return builderFactory.newDocumentBuilder();
    }

    public static Document parseSafeDOM(InputStream is) throws ParserConfigurationException, IOException, SAXException {
        long start = System.currentTimeMillis();
        Logging.debug("Starting DOM parsing of {0}", is);
        Document result = XmlUtils.newSafeDOMBuilder().parse(is);
        if (Logging.isDebugEnabled()) {
            Logging.debug("DOM parsing done in {0}", Utils.getDurationString(System.currentTimeMillis() - start));
        }
        return result;
    }

    public static SAXParser newSafeSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        parserFactory.setNamespaceAware(true);
        return parserFactory.newSAXParser();
    }

    public static void parseSafeSAX(InputSource is, DefaultHandler dh) throws ParserConfigurationException, SAXException, IOException {
        long start = System.currentTimeMillis();
        Logging.debug("Starting SAX parsing of {0} using {1}", is, dh);
        XmlUtils.newSafeSAXParser().parse(is, dh);
        if (Logging.isDebugEnabled()) {
            Logging.debug("SAX parsing done in {0}", Utils.getDurationString(System.currentTimeMillis() - start));
        }
    }

    public static XMLInputFactory newSafeXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return factory;
    }

    public static TransformerFactory newSafeTransformerFactory() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory;
    }
}

