/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.util.Message;

public class LogReportOutputter
implements ReportOutputter {
    @Override
    public String getName() {
        return "console";
    }

    @Override
    public void output(ResolveReport resolveReport, ResolutionCacheManager resolutionCacheManager, ResolveOptions resolveOptions) throws IOException {
        ArtifactDownloadReport[] artifactDownloadReportArray;
        String[] stringArray;
        int n;
        Object[] objectArray;
        Object object;
        IvySettings ivySettings = IvyContext.getContext().getSettings();
        if (ivySettings.logModulesInUse() && "default".equals(resolveOptions.getLog())) {
            Message.info("\t:: modules in use:");
            object = new ArrayList(resolveReport.getDependencies());
            Collections.sort(object);
            if (object.size() > 0) {
                objectArray = resolveReport.getConfigurations();
                for (n = 0; n < object.size(); ++n) {
                    stringArray = (String[])object.get(n);
                    if (stringArray.isCompletelyEvicted() || stringArray.hasProblem()) continue;
                    ArrayList<char> arrayList = new ArrayList<char>(objectArray.length);
                    for (int i = 0; i < objectArray.length; ++i) {
                        char c = objectArray[i];
                        if (!resolveReport.getConfigurationReport((String)c).getModuleRevisionIds().contains(stringArray.getResolvedId())) continue;
                        arrayList.add(c);
                    }
                    Message.info("\t" + stringArray + " from " + stringArray.getModuleRevision().getResolver().getName() + " in " + arrayList);
                }
            }
        }
        if (((IvyNode[])(object = resolveReport.getEvictedNodes())).length > 0 && "default".equals(resolveOptions.getLog())) {
            Message.info("\t:: evicted modules:");
            for (int i = 0; i < ((Object)object).length; ++i) {
                Collection collection = ((IvyNode)object[i]).getAllEvictingNodesDetails();
                if (collection == null) {
                    Message.info("\t" + object[i] + " transitively in " + Arrays.asList(((IvyNode)object[i]).getEvictedConfs()));
                } else if (collection.isEmpty()) {
                    Message.info("\t" + object[i] + " by [] (" + ((IvyNode)object[i]).getAllEvictingConflictManagers() + ") in " + Arrays.asList(((IvyNode)object[i]).getEvictedConfs()));
                } else {
                    Message.info("\t" + object[i] + " by " + collection + " in " + Arrays.asList(((IvyNode)object[i]).getEvictedConfs()));
                }
                stringArray = ((IvyNode)object[i]).getEvictedConfs();
                for (int j = 0; j < stringArray.length; ++j) {
                    IvyNodeEviction.EvictionData evictionData = ((IvyNode)object[i]).getEvictedData(stringArray[j]);
                    if (evictionData.getParent() == null) continue;
                    Message.verbose("\t  in " + evictionData.getParent() + " with " + evictionData.getConflictManager());
                }
            }
        }
        if ("default".equals(resolveOptions.getLog())) {
            objectArray = new char[69];
            Arrays.fill(objectArray, '-');
            Message.rawinfo("\t" + new String((char[])objectArray));
            StringBuffer stringBuffer = new StringBuffer("\t");
            this.append(stringBuffer, "", 18);
            this.append(stringBuffer, "modules", 31);
            stringBuffer.append("|");
            this.append(stringBuffer, "artifacts", 15);
            stringBuffer.append("|");
            Message.rawinfo(stringBuffer.toString());
            stringBuffer = new StringBuffer("\t");
            this.append(stringBuffer, "conf", 18);
            this.append(stringBuffer, "number", 7);
            this.append(stringBuffer, "search", 7);
            this.append(stringBuffer, "dwnlded", 7);
            this.append(stringBuffer, "evicted", 7);
            stringBuffer.append("|");
            this.append(stringBuffer, "number", 7);
            this.append(stringBuffer, "dwnlded", 7);
            stringBuffer.append("|");
            Message.rawinfo(stringBuffer.toString());
            Message.rawinfo("\t" + new String((char[])objectArray));
            stringArray = resolveReport.getConfigurations();
            for (int i = 0; i < stringArray.length; ++i) {
                this.output(resolveReport.getConfigurationReport(stringArray[i]));
            }
            Message.rawinfo("\t" + new String((char[])objectArray));
        }
        if ((objectArray = (Object[])resolveReport.getUnresolvedDependencies()).length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
            Message.warn("\t::          UNRESOLVED DEPENDENCIES         ::");
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
        }
        for (n = 0; n < objectArray.length; ++n) {
            Message.warn("\t:: " + objectArray[n] + ": " + objectArray[n].getProblemMessage());
        }
        if (objectArray.length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::\n");
        }
        if ((artifactDownloadReportArray = resolveReport.getFailedArtifactsReports()).length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
            Message.warn("\t::              FAILED DOWNLOADS            ::");
            Message.warn("\t:: ^ see resolution messages for details  ^ ::");
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
        }
        for (int i = 0; i < artifactDownloadReportArray.length; ++i) {
            Message.warn("\t:: " + artifactDownloadReportArray[i].getArtifact());
        }
        if (artifactDownloadReportArray.length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::\n");
        }
    }

    public void output(ConfigurationResolveReport configurationResolveReport) {
        StringBuffer stringBuffer = new StringBuffer("\t");
        this.append(stringBuffer, configurationResolveReport.getConfiguration(), 18);
        this.append(stringBuffer, String.valueOf(configurationResolveReport.getNodesNumber()), 7);
        this.append(stringBuffer, String.valueOf(configurationResolveReport.getSearchedNodes().length), 7);
        this.append(stringBuffer, String.valueOf(configurationResolveReport.getDownloadedNodes().length), 7);
        this.append(stringBuffer, String.valueOf(configurationResolveReport.getEvictedNodes().length), 7);
        stringBuffer.append("|");
        this.append(stringBuffer, String.valueOf(configurationResolveReport.getArtifactsNumber()), 7);
        this.append(stringBuffer, String.valueOf(configurationResolveReport.getDownloadedArtifactsReports().length), 7);
        stringBuffer.append("|");
        Message.rawinfo(stringBuffer.toString());
    }

    private void append(StringBuffer stringBuffer, Object object, int n) {
        String string = String.valueOf(object);
        if (string.length() >= n) {
            string = string.substring(0, n);
        } else {
            int n2 = n - string.length();
            int n3 = n2 / 2;
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            System.arraycopy(string.toCharArray(), 0, cArray, n2 - n3, string.length());
            string = new String(cArray);
        }
        stringBuffer.append("|");
        stringBuffer.append(string);
    }
}

