/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.Vec3f;
import com.sun.javafx.geom.transform.BaseTransform;

public class PickRay {
    private Vec3d origin = new Vec3d();
    private Vec3d direction = new Vec3d();
    static final double EPS = (double)1.0E-5f;
    private static final double EPSILON_ABSOLUTE = 1.0E-5;
    private final Vec3d tempV3d = new Vec3d();
    private final Vec3d vec0 = new Vec3d();
    private final Vec3d vec1 = new Vec3d();
    private final Vec3d pNrm = new Vec3d();
    private final Vec3d endPt = new Vec3d();

    public PickRay() {
    }

    public PickRay(Vec3d vec3d, Vec3d vec3d2) {
        this.setOrigin(vec3d);
        this.setDirection(vec3d2);
    }

    public PickRay copy() {
        return new PickRay(this.origin, this.direction);
    }

    public void setOrigin(Vec3d vec3d) {
        this.origin.set(vec3d);
    }

    public Vec3d getOrigin(Vec3d vec3d) {
        if (vec3d == null) {
            vec3d = new Vec3d();
        }
        vec3d.set(this.origin);
        return vec3d;
    }

    public Vec3d getOriginNoClone() {
        return this.origin;
    }

    public void setDirection(Vec3d vec3d) {
        this.direction.set(vec3d);
    }

    public Vec3d getDirection(Vec3d vec3d) {
        if (vec3d == null) {
            vec3d = new Vec3d();
        }
        vec3d.set(this.direction);
        return vec3d;
    }

    public Vec3d getDirectionNoClone() {
        return this.direction;
    }

    public double distance(Vec3d vec3d) {
        double d = vec3d.x - this.origin.x;
        double d2 = vec3d.y - this.origin.y;
        double d3 = vec3d.z - this.origin.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public boolean intersect(Vec3f[] vec3fArray, double[] dArray, Vec3d vec3d) {
        return this.intersectRayOrSegment(vec3fArray, this.origin, this.direction, dArray, vec3d, false);
    }

    public Point2D projectToZeroPlane(BaseTransform baseTransform, boolean bl, Vec3d vec3d, Point2D point2D) {
        if (vec3d == null) {
            vec3d = new Vec3d();
        }
        baseTransform.transform(this.origin, vec3d);
        double d = vec3d.x;
        double d2 = vec3d.y;
        double d3 = vec3d.z;
        vec3d.add(this.origin, this.direction);
        baseTransform.transform(vec3d, vec3d);
        double d4 = vec3d.x - d;
        double d5 = vec3d.y - d2;
        double d6 = vec3d.z - d3;
        if (PickRay.almostZero(d6)) {
            return null;
        }
        double d7 = -d3 / d6;
        if (bl && d7 < 0.0) {
            return null;
        }
        if (point2D == null) {
            point2D = new Point2D();
        }
        point2D.setLocation((float)(d + d4 * d7), (float)(d2 + d5 * d7));
        return point2D;
    }

    static boolean almostZero(double d) {
        return d < 1.0E-5 && d > -1.0E-5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean intersectRayOrSegment(Vec3f[] vec3fArray, Vec3d vec3d, Vec3d vec3d2, double[] dArray, Vec3d vec3d3, boolean bl) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < vec3fArray.length; ++n) {
            n3 = n != vec3fArray.length - 1 ? n + 1 : 0;
            this.vec0.sub(vec3fArray[n3], vec3fArray[n]);
            if ((double)this.vec0.length() > 0.0) break;
        }
        for (int i = n3; i < vec3fArray.length; ++i) {
            n2 = i != vec3fArray.length - 1 ? i + 1 : 0;
            this.vec1.sub(vec3fArray[n2], vec3fArray[i]);
            if ((double)this.vec1.length() > 0.0) break;
        }
        this.pNrm.cross(this.vec0, this.vec1);
        if (this.vec1.length() == 0.0f) return false;
        if (this.pNrm.length() == 0.0f) {
            return false;
        }
        d2 = this.pNrm.dot(vec3d2);
        if (d2 == 0.0) {
            return false;
        }
        this.tempV3d.set(vec3fArray[0]);
        d = this.pNrm.dot(this.tempV3d);
        this.tempV3d.set(vec3d);
        dArray[0] = (d - this.pNrm.dot(this.tempV3d)) / d2;
        if (dArray[0] < (double)-1.0E-5f) return false;
        if (bl && dArray[0] > 1.0000099999997474) {
            return false;
        }
        if (vec3d3 == null) {
            vec3d3 = new Vec3d();
        }
        vec3d3.x = vec3d.x + vec3d2.x * dArray[0];
        vec3d3.y = vec3d.y + vec3d2.y * dArray[0];
        vec3d3.z = vec3d.z + vec3d2.z * dArray[0];
        double d3 = Math.abs(this.pNrm.x);
        double d4 = Math.abs(this.pNrm.y);
        double d5 = Math.abs(this.pNrm.z);
        double d6 = 0.0;
        Vec3f vec3f = vec3fArray[vec3fArray.length - 1];
        Vec3f vec3f2 = vec3fArray[0];
        bl2 = true;
        if (d3 > d4) {
            if (d3 < d5) {
                for (n = 0; n < vec3fArray.length; ++n) {
                    vec3f = vec3fArray[n];
                    vec3f2 = n != vec3fArray.length - 1 ? vec3fArray[n + 1] : vec3fArray[0];
                    double d7 = (vec3d3.y - (double)vec3f.y) * (double)(vec3f2.x - vec3f.x) - (vec3d3.x - (double)vec3f.x) * (double)(vec3f2.y - vec3f.y);
                    if (PickRay.isNonZero(d7)) {
                        if (d7 * d6 < 0.0) {
                            return false;
                        }
                        d6 = d7;
                        continue;
                    }
                    double d8 = vec3f2.y - vec3f.y;
                    if (PickRay.isNonZero(d8)) {
                        if (!((d8 = (vec3d3.y - (double)vec3f.y) / d8) > (double)-1.0E-5f)) return false;
                        if (!(d8 < 1.0000099999997474)) return false;
                        boolean bl3 = true;
                        bl2 = bl3;
                    } else {
                        d8 = vec3f2.x - vec3f.x;
                        if (!PickRay.isNonZero(d8)) continue;
                        if (!((d8 = (vec3d3.x - (double)vec3f.x) / d8) > (double)-1.0E-5f)) return false;
                        if (!(d8 < 1.0000099999997474)) return false;
                        boolean bl4 = true;
                        bl2 = bl4;
                    }
                    break;
                }
            } else {
                for (n = 0; n < vec3fArray.length; ++n) {
                    vec3f = vec3fArray[n];
                    vec3f2 = n != vec3fArray.length - 1 ? vec3fArray[n + 1] : vec3fArray[0];
                    double d9 = (vec3d3.y - (double)vec3f.y) * (double)(vec3f2.z - vec3f.z) - (vec3d3.z - (double)vec3f.z) * (double)(vec3f2.y - vec3f.y);
                    if (PickRay.isNonZero(d9)) {
                        if (d9 * d6 < 0.0) {
                            return false;
                        }
                        d6 = d9;
                        continue;
                    }
                    double d10 = vec3f2.y - vec3f.y;
                    if (PickRay.isNonZero(d10)) {
                        if (!((d10 = (vec3d3.y - (double)vec3f.y) / d10) > (double)-1.0E-5f)) return false;
                        if (!(d10 < 1.0000099999997474)) return false;
                        boolean bl5 = true;
                        bl2 = bl5;
                    } else {
                        d10 = vec3f2.z - vec3f.z;
                        if (!PickRay.isNonZero(d10)) continue;
                        if (!((d10 = (vec3d3.z - (double)vec3f.z) / d10) > (double)-1.0E-5f)) return false;
                        if (!(d10 < 1.0000099999997474)) return false;
                        boolean bl6 = true;
                        bl2 = bl6;
                    }
                    break;
                }
            }
        } else if (d4 < d5) {
            for (n = 0; n < vec3fArray.length; ++n) {
                vec3f = vec3fArray[n];
                vec3f2 = n != vec3fArray.length - 1 ? vec3fArray[n + 1] : vec3fArray[0];
                double d11 = (vec3d3.y - (double)vec3f.y) * (double)(vec3f2.x - vec3f.x) - (vec3d3.x - (double)vec3f.x) * (double)(vec3f2.y - vec3f.y);
                if (PickRay.isNonZero(d11)) {
                    if (d11 * d6 < 0.0) {
                        return false;
                    }
                    d6 = d11;
                    continue;
                }
                double d12 = vec3f2.y - vec3f.y;
                if (PickRay.isNonZero(d12)) {
                    if (!((d12 = (vec3d3.y - (double)vec3f.y) / d12) > (double)-1.0E-5f)) return false;
                    if (!(d12 < 1.0000099999997474)) return false;
                    boolean bl7 = true;
                    bl2 = bl7;
                } else {
                    d12 = vec3f2.x - vec3f.x;
                    if (!PickRay.isNonZero(d12)) continue;
                    if (!((d12 = (vec3d3.x - (double)vec3f.x) / d12) > (double)-1.0E-5f)) return false;
                    if (!(d12 < 1.0000099999997474)) return false;
                    boolean bl8 = true;
                    bl2 = bl8;
                }
                break;
            }
        } else {
            for (n = 0; n < vec3fArray.length; ++n) {
                vec3f = vec3fArray[n];
                vec3f2 = n != vec3fArray.length - 1 ? vec3fArray[n + 1] : vec3fArray[0];
                double d13 = (vec3d3.x - (double)vec3f.x) * (double)(vec3f2.z - vec3f.z) - (vec3d3.z - (double)vec3f.z) * (double)(vec3f2.x - vec3f.x);
                if (PickRay.isNonZero(d13)) {
                    if (d13 * d6 < 0.0) {
                        return false;
                    }
                    d6 = d13;
                    continue;
                }
                double d14 = vec3f2.x - vec3f.x;
                if (PickRay.isNonZero(d14)) {
                    if (!((d14 = (vec3d3.x - (double)vec3f.x) / d14) > (double)-1.0E-5f)) return false;
                    if (!(d14 < 1.0000099999997474)) return false;
                    boolean bl9 = true;
                    bl2 = bl9;
                } else {
                    d14 = vec3f2.z - vec3f.z;
                    if (!PickRay.isNonZero(d14)) continue;
                    if (!((d14 = (vec3d3.z - (double)vec3f.z) / d14) > (double)-1.0E-5f)) return false;
                    if (!(d14 < 1.0000099999997474)) return false;
                    boolean bl10 = true;
                    bl2 = bl10;
                }
                break;
            }
        }
        if (!bl2) return bl2;
        dArray[0] = dArray[0] * (double)vec3d2.length();
        return bl2;
    }

    private static boolean isNonZero(double d) {
        return d > (double)1.0E-5f || d < (double)-1.0E-5f;
    }

    public void transform(BaseTransform baseTransform) {
        this.endPt.add(this.origin, this.direction);
        baseTransform.transform(this.origin, this.origin);
        baseTransform.transform(this.endPt, this.endPt);
        this.direction.sub(this.endPt, this.origin);
        this.direction.normalize();
    }

    public PickRay project(BaseTransform baseTransform, boolean bl, Vec3d vec3d, Point2D point2D) {
        if (vec3d == null) {
            vec3d = new Vec3d();
        }
        baseTransform.transform(this.origin, vec3d);
        double d = vec3d.x;
        double d2 = vec3d.y;
        double d3 = vec3d.z;
        vec3d.add(this.origin, this.direction);
        baseTransform.transform(vec3d, vec3d);
        double d4 = vec3d.x - d;
        double d5 = vec3d.y - d2;
        double d6 = vec3d.z - d3;
        PickRay pickRay = new PickRay();
        pickRay.origin.x = d;
        pickRay.origin.y = d2;
        pickRay.origin.z = d3;
        pickRay.direction.x = d4;
        pickRay.direction.y = d5;
        pickRay.direction.z = d6;
        return pickRay;
    }

    public String toString() {
        return "origin: " + this.origin + "  direction: " + this.direction;
    }
}

