/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.core.multitabs.TabDecorator;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.core.windows.view.ui.tabcontrol.Utilities;
import org.netbeans.swing.tabcontrol.TabData;
import org.openide.awt.CloseButtonFactory;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class TabDataRenderer
implements TableCellRenderer {
    private final RendererPanel renderer = new RendererPanel();
    private final List<TabDecorator> decorators = TabDataRenderer.getDecorators();
    private static final boolean SHOW_CLOSE_BUTTON = !Boolean.getBoolean("nb.tabs.suppressCloseButton");

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.renderer.clear();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        this.renderer.setSize(rectangle.width, rectangle.height);
        if (object instanceof TabData) {
            TabData tabData = (TabData)object;
            String string = tabData.getText();
            Icon icon = tabData.getIcon();
            Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
            Color color2 = bl ? jTable.getSelectionForeground() : jTable.getForeground();
            for (TabDecorator tabDecorator : this.decorators) {
                Icon icon2;
                String string2;
                Color color3 = tabDecorator.getBackground(tabData, bl);
                if (null != color3) {
                    color = color3;
                }
                if (null != (color3 = tabDecorator.getForeground(tabData, bl))) {
                    color2 = color3;
                }
                if (null != (string2 = tabDecorator.getText(tabData))) {
                    string = string2;
                }
                if (null == (icon2 = tabDecorator.getIcon(tabData))) continue;
                icon = icon2;
            }
            this.renderer.label.setText(string);
            this.renderer.label.setIcon(icon);
            this.renderer.label.setFont(jTable.getFont());
            this.renderer.setBackground(color);
            this.renderer.label.setForeground(color2);
            this.renderer.tabData = tabData;
            this.renderer.isSelected = bl;
            if (jTable instanceof TabTable) {
                TabTable tabTable = (TabTable)jTable;
                if (TabDataRenderer.isClosable(tabData)) {
                    boolean bl3 = tabTable.isCloseButtonHighlighted(n, n2);
                    this.renderer.closeButton.setVisible(true);
                    this.renderer.closeButton.getModel().setRollover(bl3);
                    this.renderer.closeButton.getModel().setArmed(bl3);
                } else {
                    this.renderer.closeButton.setVisible(false);
                }
            }
        }
        return this.renderer;
    }

    boolean isInCloseButton(Rectangle rectangle, Point point) {
        return this.renderer.isInCloseButton(rectangle, point);
    }

    static boolean isClosable(TabData tabData) {
        if (!SHOW_CLOSE_BUTTON) {
            return false;
        }
        if (!Utilities.isEditorTopComponentClosingEnabled()) {
            return false;
        }
        Component component = tabData.getComponent();
        if (component instanceof TopComponent) {
            return !Boolean.TRUE.equals(((TopComponent)component).getClientProperty((Object)"netbeans.winsys.tc.closing_disabled"));
        }
        return true;
    }

    int getPreferredWidth(Object object) {
        int n = -1;
        this.renderer.clear();
        if (object instanceof TabData) {
            TabData tabData = (TabData)object;
            String string = tabData.getText();
            Icon icon = tabData.getIcon();
            for (TabDecorator tabDecorator : this.decorators) {
                Icon icon2;
                String string2 = tabDecorator.getText(tabData);
                if (null != string2) {
                    string = string2;
                }
                if (null == (icon2 = tabDecorator.getIcon(tabData))) continue;
                icon = icon2;
            }
            this.renderer.label.setText(string);
            this.renderer.label.setIcon(icon);
            this.renderer.tabData = tabData;
            n = this.renderer.getPreferredSize().width;
        }
        return n;
    }

    static int getPreferredTableRowHeight() {
        JLabel jLabel = new JLabel("ABC");
        return 4 + Math.max(16, jLabel.getPreferredSize().height);
    }

    private static List<TabDecorator> getDecorators() {
        return new ArrayList<TabDecorator>(Lookup.getDefault().lookupAll(TabDecorator.class));
    }

    private class RendererPanel
    extends JPanel {
        private final JLabel label;
        private final JButton closeButton;
        private TabData tabData;
        private boolean isSelected;

        public RendererPanel() {
            super(new BorderLayout(0, 0));
            this.label = new JLabel();
            this.label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 3));
            this.add((Component)this.label, "Center");
            this.closeButton = CloseButtonFactory.createCloseButton();
            this.add((Component)this.closeButton, "East");
        }

        void clear() {
            this.label.setText(null);
            this.label.setIcon(null);
            this.setOpaque(true);
            this.tabData = null;
            this.isSelected = false;
            this.closeButton.getModel().setArmed(false);
            this.closeButton.getModel().setRollover(false);
            this.closeButton.setVisible(true);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            for (TabDecorator tabDecorator : TabDataRenderer.this.decorators) {
                tabDecorator.paintAfter(this.tabData, graphics, rectangle, this.isSelected);
            }
        }

        private boolean isInCloseButton(Rectangle rectangle, Point point) {
            if (rectangle.contains(point) && this.closeButton.isVisible()) {
                Dimension dimension = this.closeButton.getPreferredSize();
                Rectangle rectangle2 = new Rectangle(dimension);
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width - 3;
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width - 3;
                rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
                return rectangle2.contains(point);
            }
            return false;
        }
    }
}

