/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsServer;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.util.Arrays;

public abstract class DefaultTlsServer
extends AbstractTlsServer {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52392, 49200, 49199, 49192, 49191, 49172, 49171, 52394, 159, 158, 107, 103, 57, 51, 157, 156, 61, 60, 53, 47};
    protected int[] supportedCipherSuites;

    public DefaultTlsServer(TlsCrypto tlsCrypto) {
        super(tlsCrypto);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(tlsCrypto, BASE_CIPHER_SUITES);
    }

    public DefaultTlsServer(TlsCrypto tlsCrypto, TlsKeyExchangeFactory tlsKeyExchangeFactory) {
        super(tlsCrypto, tlsKeyExchangeFactory);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(tlsCrypto, BASE_CIPHER_SUITES);
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getECDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected int[] getCipherSuites() {
        return Arrays.clone((int[])this.supportedCipherSuites);
    }

    public TlsCredentials getCredentials() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 3: {
                return this.getDSASignerCredentials();
            }
            case 11: 
            case 20: {
                return null;
            }
            case 17: {
                return this.getECDSASignerCredentials();
            }
            case 5: 
            case 19: {
                return this.getRSASignerCredentials();
            }
            case 1: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(n);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(n);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(n);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(n);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createDHKeyExchangeServer(n, this.supportedSignatureAlgorithms, this.selectDHConfig());
    }

    protected TlsKeyExchange createDHEKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createDHEKeyExchangeServer(n, this.supportedSignatureAlgorithms, this.selectDHConfig());
    }

    protected TlsKeyExchange createECDHKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createECDHKeyExchangeServer(n, this.supportedSignatureAlgorithms, this.selectECConfig(), this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createECDHEKeyExchangeServer(n, this.supportedSignatureAlgorithms, this.selectECConfig(), this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() throws IOException {
        return this.keyExchangeFactory.createRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

