/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.Matf;
import org.gephi.lib.gleem.linalg.Vec2f;

public class Mat2f {
    private float[] data = new float[4];

    public void makeIdent() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (i == j) {
                    this.set(i, j, 1.0f);
                    continue;
                }
                this.set(i, j, 0.0f);
            }
        }
    }

    public float get(int i, int j) {
        return this.data[2 * i + j];
    }

    public void set(int i, int j, float val) {
        this.data[2 * i + j] = val;
    }

    public void setCol(int i, Vec2f v) {
        this.set(0, i, v.x());
        this.set(1, i, v.y());
    }

    public void setRow(int i, Vec2f v) {
        this.set(i, 0, v.x());
        this.set(i, 1, v.y());
    }

    public void transpose() {
        float t = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, t);
    }

    public float determinant() {
        return this.get(0, 0) * this.get(1, 1) - this.get(1, 0) * this.get(0, 1);
    }

    public boolean invert() {
        float det = this.determinant();
        if (det == 0.0f) {
            return false;
        }
        float t = this.get(0, 0);
        this.set(0, 0, this.get(1, 1));
        this.set(1, 1, t);
        this.set(0, 1, -this.get(0, 1));
        this.set(1, 0, -this.get(1, 0));
        int i = 0;
        while (i < 4) {
            int n = i++;
            this.data[n] = this.data[n] / det;
        }
        return true;
    }

    public void xformVec(Vec2f src, Vec2f dest) {
        dest.set(this.get(0, 0) * src.x() + this.get(0, 1) * src.y(), this.get(1, 0) * src.x() + this.get(1, 1) * src.y());
    }

    public Mat2f mul(Mat2f b) {
        Mat2f tmp = new Mat2f();
        tmp.mul(this, b);
        return tmp;
    }

    public void mul(Mat2f a, Mat2f b) {
        for (int rc = 0; rc < 2; ++rc) {
            for (int cc = 0; cc < 2; ++cc) {
                float tmp = 0.0f;
                for (int i = 0; i < 2; ++i) {
                    tmp += a.get(rc, i) * b.get(i, cc);
                }
                this.set(rc, cc, tmp);
            }
        }
    }

    public Matf toMatf() {
        Matf out = new Matf(2, 2);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                out.set(i, j, this.get(i, j));
            }
        }
        return out;
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        return "(" + this.get(0, 0) + ", " + this.get(0, 1) + endl + this.get(1, 0) + ", " + this.get(1, 1) + ")";
    }
}

