/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public final class ProxyURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final Map<String, Lookup.Result<URLStreamHandler>> results = new HashMap<String, Lookup.Result<URLStreamHandler>>();
    private final Map<String, URLStreamHandler> handlers = new HashMap<String, URLStreamHandler>();
    private static final Set<String> STANDARD_PROTOCOLS = new HashSet<String>(Arrays.asList("jar", "file", "http", "https", "resource"));

    @Override
    public synchronized URLStreamHandler createURLStreamHandler(final String string) {
        if (STANDARD_PROTOCOLS.contains(string)) {
            return null;
        }
        if (!this.results.containsKey(string)) {
            final Lookup.Result result = Lookups.forPath((String)("URLStreamHandler/" + string)).lookupResult(URLStreamHandler.class);
            LookupListener lookupListener = new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    ProxyURLStreamHandlerFactory proxyURLStreamHandlerFactory = ProxyURLStreamHandlerFactory.this;
                    synchronized (proxyURLStreamHandlerFactory) {
                        Collection collection = result.allInstances();
                        ProxyURLStreamHandlerFactory.this.handlers.put(string, collection.isEmpty() ? null : (URLStreamHandler)collection.iterator().next());
                    }
                }
            };
            result.addLookupListener(lookupListener);
            lookupListener.resultChanged(null);
            this.results.put(string, (Lookup.Result<URLStreamHandler>)result);
        }
        return this.handlers.get(string);
    }
}

