/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;
    protected SSLException deferredException = null;

    protected ProvSSLEngine(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLEngine(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) {
        super(string, n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public synchronized void beginHandshake() throws SSLException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol tlsClientProtocol = new TlsClientProtocol();
                this.protocol = tlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this);
                this.protocolPeer = provTlsClient;
                tlsClientProtocol.connect(provTlsClient);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else {
                TlsServerProtocol tlsServerProtocol = new TlsServerProtocol();
                this.protocol = tlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this);
                this.protocolPeer = provTlsServer;
                tlsServerProtocol.accept(provTlsServer);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
    }

    public synchronized void closeInbound() throws SSLException {
        try {
            this.protocol.closeInput();
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
    }

    public synchronized void closeOutbound() {
        try {
            this.protocol.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public synchronized SSLSession getSession() {
        return this.connection == null ? ProvSSLSessionImpl.NULL_SESSION.getExportSession() : this.connection.getSession();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized boolean isInboundDone() {
        return this.protocol != null && this.protocol.isClosed();
    }

    public synchronized boolean isOutboundDone() {
        return this.protocol != null && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        if (!this.context.isSupportedCipherSuites(stringArray)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(stringArray);
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (!this.context.isSupportedProtocols(stringArray)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(stringArray);
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sSLParameters);
    }

    public synchronized void setUseClientMode(boolean bl) {
        if (this.initialHandshakeBegun && bl != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = bl;
    }

    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        Object object;
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n3 = 0;
        int n4 = 0;
        if (this.protocol.isClosed()) {
            status = SSLEngineResult.Status.CLOSED;
        } else {
            try {
                object = this.getRecordPreview(byteBuffer);
                if (object == null || byteBuffer.remaining() < object.getRecordSize()) {
                    status = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                } else if (this.hasInsufficientSpace(byteBufferArray, n, n2, object.getApplicationDataLimit())) {
                    status = SSLEngineResult.Status.BUFFER_OVERFLOW;
                } else {
                    byte[] byArray = new byte[object.getRecordSize()];
                    byteBuffer.get(byArray);
                    this.protocol.offerInput(byArray);
                    n3 += byArray.length;
                    int n5 = this.protocol.getAvailableInputBytes();
                    for (int i = 0; i < n2 && n5 > 0; ++i) {
                        ByteBuffer byteBuffer2 = byteBufferArray[n + i];
                        int n6 = Math.min(byteBuffer2.remaining(), n5);
                        if (n6 <= 0) continue;
                        byte[] byArray2 = new byte[n6];
                        int n7 = this.protocol.readInput(byArray2, 0, n6);
                        assert (n7 == n6);
                        byteBuffer2.put(byArray2);
                        n4 += n6;
                        n5 -= n6;
                    }
                    if (n5 != 0) {
                        throw new TlsFatalAlert(22);
                    }
                }
            }
            catch (IOException iOException) {
                if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException(iOException);
                }
                if (this.deferredException == null) {
                    this.deferredException = new SSLException(iOException);
                }
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n3, n4);
            }
        }
        object = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.protocol.getAvailableOutputBytes() > 0) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                object = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        return new SSLEngineResult(status, (SSLEngineResult.HandshakeStatus)((Object)object), n3, n4);
    }

    public synchronized SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        int n3;
        Object object;
        int n4;
        if (this.deferredException != null) {
            SSLException sSLException = this.deferredException;
            this.deferredException = null;
            throw sSLException;
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n5 = 0;
        int n6 = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                status = SSLEngineResult.Status.CLOSED;
            } else if (this.protocol.getAvailableOutputBytes() <= 0) {
                try {
                    n4 = this.getTotalRemaining(byteBufferArray, n, n2, this.protocol.getApplicationDataLimit());
                    if (n4 > 0) {
                        object = this.protocol.previewOutputRecord(n4);
                        int n7 = ((RecordPreview)object).getApplicationDataLimit();
                        n3 = ((RecordPreview)object).getRecordSize();
                        if (byteBuffer.remaining() < n3) {
                            status = SSLEngineResult.Status.BUFFER_OVERFLOW;
                        } else {
                            for (int i = 0; i < n2 && n7 > 0; ++i) {
                                ByteBuffer byteBuffer2 = byteBufferArray[n + i];
                                int n8 = Math.min(byteBuffer2.remaining(), n7);
                                if (n8 <= 0) continue;
                                byte[] byArray = new byte[n8];
                                byteBuffer2.get(byArray);
                                this.protocol.writeApplicationData(byArray, 0, n8);
                                n5 += n8;
                                n7 -= n8;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new SSLException(iOException);
                }
            }
        }
        if ((n4 = this.protocol.getAvailableOutputBytes()) > 0) {
            int n9 = Math.min(byteBuffer.remaining(), n4);
            if (n9 > 0) {
                byte[] byArray = new byte[n9];
                n3 = this.protocol.readOutput(byArray, 0, n9);
                assert (n3 == n9);
                byteBuffer.put(byArray);
                n6 += n9;
                n4 -= n9;
            } else {
                status = SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        object = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && n4 <= 0) {
            if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            } else {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                object = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return new SSLEngineResult(status, (SSLEngineResult.HandshakeStatus)((Object)object), n5, n6);
    }

    public String getPeerHost() {
        return super.getPeerHost();
    }

    public int getPeerPort() {
        return super.getPeerPort();
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager x509TrustManager = this.contextData.getTrustManager();
        if (x509TrustManager != null) {
            try {
                x509TrustManager.checkClientTrusted(x509CertificateArray, string);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager x509TrustManager = this.contextData.getTrustManager();
        if (x509TrustManager != null) {
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        this.connection = provSSLConnection;
    }

    private RecordPreview getRecordPreview(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() < 5) {
            return null;
        }
        byte[] byArray = new byte[5];
        int n = byteBuffer.position();
        byteBuffer.get(byArray);
        byteBuffer.position(n);
        return this.protocol.previewInputRecord(byArray);
    }

    private int getTotalRemaining(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[n + i];
            int n5 = byteBuffer.remaining();
            if (n5 >= n3 - n4) {
                return n3;
            }
            n4 += n5;
        }
        return n4;
    }

    private boolean hasInsufficientSpace(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        return this.getTotalRemaining(byteBufferArray, n, n2, n3) < n3;
    }
}

