/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyLocalJumpError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.runtime.builtin.IRubyObject;

public class JumpException
extends RuntimeException {
    private static final long serialVersionUID = -228162532535826617L;
    public static final SpecialJump SPECIAL_JUMP = new SpecialJump();

    public JumpException() {
    }

    public JumpException(String msg) {
        super(msg);
    }

    public JumpException(String msg, Throwable cause2) {
        super(msg, cause2);
    }

    @Override
    public Throwable fillInStackTrace() {
        if (RubyInstanceConfig.JUMPS_HAVE_BACKTRACE) {
            return this.originalFillInStackTrace();
        }
        return this;
    }

    protected Throwable originalFillInStackTrace() {
        return super.fillInStackTrace();
    }

    public static class SpecialJump
    extends FlowControlException {
        public SpecialJump() {
            super(RubyLocalJumpError.Reason.NOREASON);
        }
    }

    public static class FlowControlException
    extends JumpException
    implements Unrescuable {
        protected int target;
        protected Object value;
        protected final RubyLocalJumpError.Reason reason;

        public FlowControlException(RubyLocalJumpError.Reason reason2) {
            this.reason = reason2;
        }

        public FlowControlException(RubyLocalJumpError.Reason reason2, int target, Object value2) {
            this.reason = reason2;
            this.target = target;
            this.value = value2;
        }

        public int getTarget() {
            return this.target;
        }

        public void setTarget(int target) {
            this.target = target;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value2) {
            this.value = value2;
        }

        public RaiseException buildException(Ruby runtime2) {
            switch (this.reason) {
                case RETURN: 
                case BREAK: 
                case NEXT: {
                    return runtime2.newLocalJumpError(this.reason, (IRubyObject)this.value, "unexpected " + (Object)((Object)this.reason));
                }
                case REDO: 
                case RETRY: {
                    return runtime2.newLocalJumpError(this.reason, runtime2.getNil(), "unexpected " + (Object)((Object)this.reason));
                }
            }
            return runtime2.newLocalJumpError(this.reason, runtime2.getNil(), "no reason");
        }
    }
}

