/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.util.CharUtilities;

public final class CharScript {
    public static final int SCRIPT_HEBREW = 125;
    public static final int SCRIPT_MONGOLIAN = 145;
    public static final int SCRIPT_ARABIC = 160;
    public static final int SCRIPT_GREEK = 200;
    public static final int SCRIPT_LATIN = 215;
    public static final int SCRIPT_CYRILLIC = 220;
    public static final int SCRIPT_GEORGIAN = 240;
    public static final int SCRIPT_BOPOMOFO = 285;
    public static final int SCRIPT_HANGUL = 286;
    public static final int SCRIPT_GURMUKHI = 310;
    public static final int SCRIPT_GURMUKHI_2 = 1310;
    public static final int SCRIPT_DEVANAGARI = 315;
    public static final int SCRIPT_DEVANAGARI_2 = 1315;
    public static final int SCRIPT_GUJARATI = 320;
    public static final int SCRIPT_GUJARATI_2 = 1320;
    public static final int SCRIPT_BENGALI = 326;
    public static final int SCRIPT_BENGALI_2 = 1326;
    public static final int SCRIPT_ORIYA = 327;
    public static final int SCRIPT_ORIYA_2 = 1327;
    public static final int SCRIPT_TIBETAN = 330;
    public static final int SCRIPT_TELUGU = 340;
    public static final int SCRIPT_TELUGU_2 = 1340;
    public static final int SCRIPT_KANNADA = 345;
    public static final int SCRIPT_KANNADA_2 = 1345;
    public static final int SCRIPT_TAMIL = 346;
    public static final int SCRIPT_TAMIL_2 = 1346;
    public static final int SCRIPT_MALAYALAM = 347;
    public static final int SCRIPT_MALAYALAM_2 = 1347;
    public static final int SCRIPT_SINHALESE = 348;
    public static final int SCRIPT_BURMESE = 350;
    public static final int SCRIPT_THAI = 352;
    public static final int SCRIPT_KHMER = 355;
    public static final int SCRIPT_LAO = 356;
    public static final int SCRIPT_HIRAGANA = 410;
    public static final int SCRIPT_ETHIOPIC = 430;
    public static final int SCRIPT_HAN = 500;
    public static final int SCRIPT_KATAKANA = 410;
    public static final int SCRIPT_MATH = 995;
    public static final int SCRIPT_SYMBOL = 996;
    public static final int SCRIPT_UNDETERMINED = 998;
    public static final int SCRIPT_UNCODED = 999;
    private static final boolean USE_V2_INDIC = true;
    private static Map<Integer, String> scriptTagsMap;
    private static Map<String, Integer> scriptCodeMap;

    private CharScript() {
    }

    public static boolean isPunctuation(int c) {
        if (c >= 33 && c <= 47) {
            return true;
        }
        if (c >= 58 && c <= 64) {
            return true;
        }
        if (c >= 95 && c <= 96) {
            return true;
        }
        if (c >= 126 && c <= 126) {
            return true;
        }
        if (c >= 161 && c <= 191) {
            return true;
        }
        if (c >= 215 && c <= 215) {
            return true;
        }
        if (c >= 247 && c <= 247) {
            return true;
        }
        return c >= 8192 && c <= 8303;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isHebrew(int c) {
        if (c >= 1424 && c <= 1535) {
            return true;
        }
        return c >= 64256 && c <= 64335;
    }

    public static boolean isMongolian(int c) {
        return c >= 6144 && c <= 6319;
    }

    public static boolean isArabic(int c) {
        if (c >= 1536 && c <= 1791) {
            return true;
        }
        if (c >= 1872 && c <= 1919) {
            return true;
        }
        if (c >= 64336 && c <= 65023) {
            return true;
        }
        return c >= 65136 && c <= 65279;
    }

    public static boolean isGreek(int c) {
        if (c >= 880 && c <= 1023) {
            return true;
        }
        return c >= 7936 && c <= 8191;
    }

    public static boolean isLatin(int c) {
        if (c >= 65 && c <= 90) {
            return true;
        }
        if (c >= 97 && c <= 122) {
            return true;
        }
        if (c >= 192 && c <= 214) {
            return true;
        }
        if (c >= 216 && c <= 223) {
            return true;
        }
        if (c >= 224 && c <= 246) {
            return true;
        }
        if (c >= 248 && c <= 255) {
            return true;
        }
        if (c >= 256 && c <= 383) {
            return true;
        }
        if (c >= 384 && c <= 591) {
            return true;
        }
        if (c >= 7680 && c <= 7935) {
            return true;
        }
        if (c >= 11360 && c <= 11391) {
            return true;
        }
        if (c >= 42784 && c <= 43007) {
            return true;
        }
        return c >= 64256 && c <= 64271;
    }

    public static boolean isCyrillic(int c) {
        if (c >= 1024 && c <= 1279) {
            return true;
        }
        if (c >= 1280 && c <= 1327) {
            return true;
        }
        if (c >= 11744 && c <= 11775) {
            return true;
        }
        return c >= 42560 && c <= 42655;
    }

    public static boolean isGeorgian(int c) {
        if (c >= 4256 && c <= 4351) {
            return true;
        }
        return c >= 11520 && c <= 11567;
    }

    public static boolean isHangul(int c) {
        if (c >= 4352 && c <= 4607) {
            return true;
        }
        if (c >= 12592 && c <= 12687) {
            return true;
        }
        if (c >= 43360 && c <= 43391) {
            return true;
        }
        if (c >= 44032 && c <= 55203) {
            return true;
        }
        return c >= 55216 && c <= 55295;
    }

    public static boolean isGurmukhi(int c) {
        return c >= 2560 && c <= 2687;
    }

    public static boolean isDevanagari(int c) {
        if (c >= 2304 && c <= 2431) {
            return true;
        }
        return c >= 43232 && c <= 43263;
    }

    public static boolean isGujarati(int c) {
        return c >= 2688 && c <= 2815;
    }

    public static boolean isBengali(int c) {
        return c >= 2432 && c <= 2559;
    }

    public static boolean isOriya(int c) {
        return c >= 2816 && c <= 2943;
    }

    public static boolean isTibetan(int c) {
        return c >= 3840 && c <= 4095;
    }

    public static boolean isTelugu(int c) {
        return c >= 3072 && c <= 3199;
    }

    public static boolean isKannada(int c) {
        return c >= 3072 && c <= 3199;
    }

    public static boolean isTamil(int c) {
        return c >= 2944 && c <= 3071;
    }

    public static boolean isMalayalam(int c) {
        return c >= 3328 && c <= 3455;
    }

    public static boolean isSinhalese(int c) {
        return c >= 3456 && c <= 3583;
    }

    public static boolean isBurmese(int c) {
        if (c >= 4096 && c <= 4255) {
            return true;
        }
        return c >= 43616 && c <= 43647;
    }

    public static boolean isThai(int c) {
        return c >= 3584 && c <= 3711;
    }

    public static boolean isKhmer(int c) {
        if (c >= 6016 && c <= 6143) {
            return true;
        }
        return c >= 6624 && c <= 6655;
    }

    public static boolean isLao(int c) {
        return c >= 3712 && c <= 3839;
    }

    public static boolean isEthiopic(int c) {
        if (c >= 4608 && c <= 4991) {
            return true;
        }
        if (c >= 4992 && c <= 5023) {
            return true;
        }
        if (c >= 11648 && c <= 11743) {
            return true;
        }
        return c >= 43776 && c <= 43823;
    }

    public static boolean isHan(int c) {
        if (c >= 13312 && c <= 19903) {
            return true;
        }
        if (c >= 19968 && c <= 40959) {
            return true;
        }
        if (c >= 63744 && c <= 64255) {
            return true;
        }
        if (c >= 131072 && c <= 173791) {
            return true;
        }
        if (c >= 173824 && c <= 177983) {
            return true;
        }
        return c >= 194560 && c <= 195103;
    }

    public static boolean isBopomofo(int c) {
        return c >= 12544 && c <= 12591;
    }

    public static boolean isHiragana(int c) {
        return c >= 12352 && c <= 12447;
    }

    public static boolean isKatakana(int c) {
        if (c >= 12448 && c <= 12543) {
            return true;
        }
        return c >= 12784 && c <= 12799;
    }

    public static int scriptOf(int c) {
        if (CharUtilities.isAnySpace(c)) {
            return 998;
        }
        if (CharScript.isPunctuation(c)) {
            return 998;
        }
        if (CharScript.isDigit(c)) {
            return 998;
        }
        if (CharScript.isLatin(c)) {
            return 215;
        }
        if (CharScript.isCyrillic(c)) {
            return 220;
        }
        if (CharScript.isGreek(c)) {
            return 200;
        }
        if (CharScript.isHan(c)) {
            return 500;
        }
        if (CharScript.isBopomofo(c)) {
            return 285;
        }
        if (CharScript.isKatakana(c)) {
            return 410;
        }
        if (CharScript.isHiragana(c)) {
            return 410;
        }
        if (CharScript.isHangul(c)) {
            return 286;
        }
        if (CharScript.isArabic(c)) {
            return 160;
        }
        if (CharScript.isHebrew(c)) {
            return 125;
        }
        if (CharScript.isMongolian(c)) {
            return 145;
        }
        if (CharScript.isGeorgian(c)) {
            return 240;
        }
        if (CharScript.isGurmukhi(c)) {
            return CharScript.useV2IndicRules(310);
        }
        if (CharScript.isDevanagari(c)) {
            return CharScript.useV2IndicRules(315);
        }
        if (CharScript.isGujarati(c)) {
            return CharScript.useV2IndicRules(320);
        }
        if (CharScript.isBengali(c)) {
            return CharScript.useV2IndicRules(326);
        }
        if (CharScript.isOriya(c)) {
            return CharScript.useV2IndicRules(327);
        }
        if (CharScript.isTibetan(c)) {
            return 330;
        }
        if (CharScript.isTelugu(c)) {
            return CharScript.useV2IndicRules(340);
        }
        if (CharScript.isKannada(c)) {
            return CharScript.useV2IndicRules(345);
        }
        if (CharScript.isTamil(c)) {
            return CharScript.useV2IndicRules(346);
        }
        if (CharScript.isMalayalam(c)) {
            return CharScript.useV2IndicRules(347);
        }
        if (CharScript.isSinhalese(c)) {
            return 348;
        }
        if (CharScript.isBurmese(c)) {
            return 350;
        }
        if (CharScript.isThai(c)) {
            return 352;
        }
        if (CharScript.isKhmer(c)) {
            return 355;
        }
        if (CharScript.isLao(c)) {
            return 356;
        }
        if (CharScript.isEthiopic(c)) {
            return 430;
        }
        return 998;
    }

    public static int useV2IndicRules(int sc) {
        return sc < 1000 ? sc + 1000 : sc;
    }

    public static int[] scriptsOf(CharSequence cs) {
        HashSet<Integer> s = new HashSet<Integer>();
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            s.add(CharScript.scriptOf(cs.charAt(i)));
        }
        int[] sa = new int[s.size()];
        int ns = 0;
        for (Object e : s) {
            sa[ns++] = (Integer)e;
        }
        Arrays.sort(sa);
        return sa;
    }

    public static int dominantScript(CharSequence cs) {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            char c = cs.charAt(i);
            int s = CharScript.scriptOf(c);
            Integer k = s;
            Integer v = (Integer)m.get(k);
            if (v != null) {
                m.put(k, v + 1);
                continue;
            }
            m.put(k, 0);
        }
        int sMax = -1;
        int cMax = -1;
        Iterator i$ = m.entrySet().iterator();
        block4: while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = i$.next();
            Integer k = (Integer)e.getKey();
            int s = k;
            switch (s) {
                case 998: 
                case 999: {
                    continue block4;
                }
            }
            Integer v = (Integer)e.getValue();
            assert (v != null);
            int c = v;
            if (c <= cMax) continue;
            cMax = c;
            sMax = s;
        }
        if (sMax < 0) {
            sMax = 998;
        }
        return sMax;
    }

    public static boolean isIndicScript(String script) {
        return CharScript.isIndicScript(CharScript.scriptCodeFromTag(script));
    }

    public static boolean isIndicScript(int script) {
        switch (script) {
            case 310: 
            case 315: 
            case 320: 
            case 326: 
            case 327: 
            case 340: 
            case 345: 
            case 346: 
            case 347: 
            case 350: 
            case 1310: 
            case 1315: 
            case 1320: 
            case 1326: 
            case 1327: 
            case 1340: 
            case 1345: 
            case 1346: 
            case 1347: {
                return true;
            }
        }
        return false;
    }

    public static String scriptTagFromCode(int code) {
        Map<Integer, String> m = CharScript.getScriptTagsMap();
        if (m != null) {
            String tag = m.get(code);
            if (tag != null) {
                return tag;
            }
            return "";
        }
        return "";
    }

    public static int scriptCodeFromTag(String tag) {
        Map<String, Integer> m = CharScript.getScriptCodeMap();
        if (m != null) {
            Integer c = m.get(tag);
            if (c != null) {
                return c;
            }
            return 998;
        }
        return 998;
    }

    private static void putScriptTag(Map tm, Map cm, int code, String tag) {
        assert (tag != null);
        assert (tag.length() != 0);
        assert (code >= 0);
        assert (code < 2000);
        tm.put(code, tag);
        cm.put(tag, code);
    }

    private static void makeScriptMaps() {
        HashMap<Integer, String> tm = new HashMap<Integer, String>();
        HashMap<String, Integer> cm = new HashMap<String, Integer>();
        CharScript.putScriptTag(tm, cm, 125, "hebr");
        CharScript.putScriptTag(tm, cm, 145, "mong");
        CharScript.putScriptTag(tm, cm, 160, "arab");
        CharScript.putScriptTag(tm, cm, 200, "grek");
        CharScript.putScriptTag(tm, cm, 215, "latn");
        CharScript.putScriptTag(tm, cm, 220, "cyrl");
        CharScript.putScriptTag(tm, cm, 240, "geor");
        CharScript.putScriptTag(tm, cm, 285, "bopo");
        CharScript.putScriptTag(tm, cm, 286, "hang");
        CharScript.putScriptTag(tm, cm, 310, "guru");
        CharScript.putScriptTag(tm, cm, 1310, "gur2");
        CharScript.putScriptTag(tm, cm, 315, "deva");
        CharScript.putScriptTag(tm, cm, 1315, "dev2");
        CharScript.putScriptTag(tm, cm, 320, "gujr");
        CharScript.putScriptTag(tm, cm, 1320, "gjr2");
        CharScript.putScriptTag(tm, cm, 326, "beng");
        CharScript.putScriptTag(tm, cm, 1326, "bng2");
        CharScript.putScriptTag(tm, cm, 327, "orya");
        CharScript.putScriptTag(tm, cm, 1327, "ory2");
        CharScript.putScriptTag(tm, cm, 330, "tibt");
        CharScript.putScriptTag(tm, cm, 340, "telu");
        CharScript.putScriptTag(tm, cm, 1340, "tel2");
        CharScript.putScriptTag(tm, cm, 345, "knda");
        CharScript.putScriptTag(tm, cm, 1345, "knd2");
        CharScript.putScriptTag(tm, cm, 346, "taml");
        CharScript.putScriptTag(tm, cm, 1346, "tml2");
        CharScript.putScriptTag(tm, cm, 347, "mlym");
        CharScript.putScriptTag(tm, cm, 1347, "mlm2");
        CharScript.putScriptTag(tm, cm, 348, "sinh");
        CharScript.putScriptTag(tm, cm, 350, "mymr");
        CharScript.putScriptTag(tm, cm, 352, "thai");
        CharScript.putScriptTag(tm, cm, 355, "khmr");
        CharScript.putScriptTag(tm, cm, 356, "laoo");
        CharScript.putScriptTag(tm, cm, 410, "hira");
        CharScript.putScriptTag(tm, cm, 430, "ethi");
        CharScript.putScriptTag(tm, cm, 500, "hani");
        CharScript.putScriptTag(tm, cm, 410, "kana");
        CharScript.putScriptTag(tm, cm, 995, "zmth");
        CharScript.putScriptTag(tm, cm, 996, "zsym");
        CharScript.putScriptTag(tm, cm, 998, "zyyy");
        CharScript.putScriptTag(tm, cm, 999, "zzzz");
        scriptTagsMap = tm;
        scriptCodeMap = cm;
    }

    private static Map<Integer, String> getScriptTagsMap() {
        if (scriptTagsMap == null) {
            CharScript.makeScriptMaps();
        }
        return scriptTagsMap;
    }

    private static Map<String, Integer> getScriptCodeMap() {
        if (scriptCodeMap == null) {
            CharScript.makeScriptMaps();
        }
        return scriptCodeMap;
    }
}

