/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public class BitUtil {
    public static boolean isSet(byte value, byte mask) {
        BitUtil.assertOneBitMask(mask);
        return (value & mask) == mask;
    }

    public static boolean isSet(int value, int mask) {
        BitUtil.assertOneBitMask(mask);
        return (value & mask) == mask;
    }

    public static byte set(byte value, byte mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return (byte)(setBit ? value | mask : value & ~mask);
    }

    public static int set(int value, int mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return setBit ? value | mask : value & ~mask;
    }

    public static int clear(int value, int mask) {
        return BitUtil.set(value, mask, false);
    }

    private static void assertOneBitMask(byte mask) {
        BitUtil.assertOneBitMask((long)mask & 0xFFL);
    }

    public static void assertOneBitMask(int mask) {
        BitUtil.assertOneBitMask((long)mask & 0xFFFFFFFFL);
    }

    private static void assertOneBitMask(long mask) {
        assert ((mask & mask - 1L) == 0L) : "Mask must have only one bit set, but got: " + Long.toBinaryString(mask);
    }
}

