/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GrayFilter;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.java2d.SunGraphicsEnvironment;

public class UIUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    private static final StyleSheet DEFAULT_HTML_KIT_CSS;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    private static final GrayFilter DEFAULT_GRAY_FILTER;
    private static final GrayFilter DARCULA_GRAY_FILTER;
    private static final Pattern CLOSE_TAG_PATTERN;
    public static final Key<Integer> KEEP_BORDER_SIDES;
    private static final Key<UndoManager> UNDO_MANAGER;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Color UNFOCUSED_SELECTION_COLOR;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    private static final Color BORDER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    public static final Border DEBUG_MARKER_BORDER;
    private static volatile Pair<String, Integer> ourSystemFontData;
    public static float DEF_SYSTEM_FONT_SIZE;
    private static final Ref<Boolean> ourRetina;
    private static final AtomicReference<Boolean> jreHiDPI;
    private static volatile boolean jreHiDPI_earlierVersion;
    private static final Map<Class, Ref<Method>> ourDefaultIconMethodsCache;
    public static final Color GTK_AMBIANCE_TEXT_COLOR;
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final JBTreeTraverser<Component> UI_TRAVERSER;
    private static final Function.Mono<Component> COMPONENT_PARENT;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentAdapter SET_TEXT_CHECKER;

    private static void blockATKWrapper() {
        if (!SystemInfo.isLinux || !Registry.is("linux.jdk.accessibility.atkwrapper.block")) {
            return;
        }
        if (ScreenReader.isEnabled("org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            LOG.info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
    }

    private UIUtil() {
    }

    public static boolean isJreHiDPI() {
        return UIUtil.isJreHiDPI((GraphicsConfiguration)null);
    }

    public static boolean isJreHiDPI(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(gc));
    }

    public static boolean isJreHiDPI(@Nullable JBUI.ScaleContext ctx) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJreHiDPIEnabled() {
        if (jreHiDPI.get() != null) {
            return jreHiDPI.get();
        }
        AtomicReference<Boolean> atomicReference = jreHiDPI;
        synchronized (atomicReference) {
            if (jreHiDPI.get() != null) {
                return jreHiDPI.get();
            }
            jreHiDPI.set(false);
            if (!SystemProperties.getBooleanProperty("hidpi", true)) {
                return false;
            }
            jreHiDPI_earlierVersion = true;
            if (SystemInfo.isLinux) {
                return false;
            }
            if (SystemInfo.isJetBrainsJvm) {
                try {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    if (ge instanceof SunGraphicsEnvironment) {
                        Method m = ReflectionUtil.getDeclaredMethod(SunGraphicsEnvironment.class, "isUIScaleOn", new Class[0]);
                        jreHiDPI.set(m != null && (Boolean)m.invoke((Object)ge, new Object[0]) != false);
                        jreHiDPI_earlierVersion = false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (SystemInfo.isMac) {
                jreHiDPI.set(true);
            }
            return jreHiDPI.get();
        }
    }

    static boolean isJreHiDPI_earlierVersion() {
        UIUtil.isJreHiDPIEnabled();
        return jreHiDPI_earlierVersion;
    }

    public static Object getClientProperty(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        return component instanceof JComponent ? ((JComponent)component).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(9);
        }
        return (T)UIUtil.getClientProperty(component, key);
    }

    @Deprecated
    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        LinePainter2D.paint((Graphics2D)g, x1, y1, x2, y2);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListBackground() {
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("List.background");
    }

    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            UIUtil.drawLine(g, x, i1, x, i1);
        }
    }

    @NotNull
    public static BufferedImage createImage(int width, int height, int type2) {
        if (UIUtil.isJreHiDPI()) {
            BufferedImage bufferedImage = RetinaImage.create(width, height, type2);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(41);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type2);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(42);
        }
        return bufferedImage;
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(52);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(53);
        }
        UIUtil.drawImage(g, image, new Rectangle(x, y, -1, -1), null, null, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable BufferedImageOp op, @Nullable ImageObserver observer) {
        boolean hasDstSize;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(60);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(61);
        }
        Graphics invG = null;
        double scale = 1.0;
        int userWidth = ImageUtil.getUserWidth(image);
        int userHeight = ImageUtil.getUserHeight(image);
        int dx = 0;
        int dy = 0;
        int dw = -1;
        int dh = -1;
        if (dstBounds != null) {
            dx = dstBounds.x;
            dy = dstBounds.y;
            dw = dstBounds.width;
            dh = dstBounds.height;
        }
        boolean bl = hasDstSize = dw >= 0 && dh >= 0;
        if (image instanceof JBHiDPIScaledImage) {
            AffineTransform tx;
            JBHiDPIScaledImage hidpiImage = (JBHiDPIScaledImage)image;
            Image delegate = hidpiImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            if ((scale = hidpiImage.getScale()) == (tx = ((Graphics2D)g).getTransform()).getScaleX()) {
                double gScaleX = tx.getScaleX();
                double gScaleY = tx.getScaleY();
                tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
                tx.translate((double)dx * gScaleX, (double)dy * gScaleY);
                dy = 0;
                dx = 0;
                g = invG = (Graphics2D)g.create();
                ((Graphics2D)invG).setTransform(tx);
            }
        }
        final double _scale = scale;
        Function<Integer, Integer> size = new Function<Integer, Integer>(){

            @Override
            public Integer fun(Integer size) {
                return (int)Math.round((double)size.intValue() * _scale);
            }
        };
        try {
            if (op != null && image instanceof BufferedImage) {
                image = op.filter((BufferedImage)image, null);
            }
            if (invG != null && hasDstSize) {
                dw = (Integer)size.fun(dw);
                dh = (Integer)size.fun(dh);
            }
            if (srcBounds != null) {
                int sh;
                int sx = (Integer)size.fun(srcBounds.x);
                int sy = (Integer)size.fun(srcBounds.y);
                int sw = srcBounds.width >= 0 ? (Integer)size.fun(srcBounds.width) : (Integer)size.fun(userWidth) - sx;
                int n = sh = srcBounds.height >= 0 ? (Integer)size.fun(srcBounds.height) : (Integer)size.fun(userHeight) - sy;
                if (!hasDstSize) {
                    dw = (Integer)size.fun(userWidth);
                    dh = (Integer)size.fun(userHeight);
                }
                g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, observer);
            } else if (hasDstSize) {
                g.drawImage(image, dx, dy, dw, dh, observer);
            } else if (invG == null) {
                g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            } else {
                g.drawImage(image, dx, dy, observer);
            }
        }
        finally {
            if (invG != null) {
                invG.dispose();
            }
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(85);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    public static void initSystemFontData() {
        Font winFont;
        if (ourSystemFontData != null) {
            return;
        }
        Font font = UIUtil.getLabelFont();
        UIUtil.verbose("Label font: %s, %d", font.getFontName(), font.getSize());
        if (SystemInfo.isLinux) {
            Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
            UIUtil.verbose("gnome.Xft/DPI: %s", value);
            if (value instanceof Integer) {
                int dpi = (Integer)value / 1024;
                if (dpi < 50) {
                    dpi = 50;
                }
                float scale = JBUI.discreteScale((float)dpi / 96.0f);
                DEF_SYSTEM_FONT_SIZE = (float)font.getSize() / scale;
                UIUtil.verbose("DEF_SYSTEM_FONT_SIZE: %.2f, %d", Float.valueOf(DEF_SYSTEM_FONT_SIZE), dpi);
            } else if (!SystemInfo.isJetBrainsJvm) {
                float size = DEF_SYSTEM_FONT_SIZE * UIUtil.getScreenScale();
                font = font.deriveFont(size);
                UIUtil.verbose("(Not-JB JRE) reset font size: %.2f", Float.valueOf(size));
            }
        } else if (SystemInfo.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
            UIUtil.verbose("Windows sys font: %s, %d", winFont.getFontName(), winFont.getSize());
        }
        ourSystemFontData = Pair.create(font.getName(), font.getSize());
        UIUtil.verbose("ourSystemFontData: %s, %d", UIUtil.ourSystemFontData.first, UIUtil.ourSystemFontData.second);
    }

    private static void verbose(String msg, Object ... args) {
        if (JBUI.SCALE_VERBOSE) {
            LOG.info(String.format(msg, args));
        }
    }

    @Nullable
    public static Pair<String, Integer> getSystemFontData() {
        return ourSystemFontData;
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return JBUI.discreteScale((float)dpi / 96.0f);
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(95);
            }
            return jBIterable;
        }
        Container container2 = (Container)component;
        JBIterable<Component> jBIterable = JBIterable.of(container2.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(96);
        }
        return jBIterable;
    }

    static {
        UIUtil.blockATKWrapper();
        HTMLEditorKit kit = new HTMLEditorKit();
        DEFAULT_HTML_KIT_CSS = kit.getStyleSheet();
        kit.setStyleSheet(null);
        UIManager.getDefaults().put("javax.swing.JLabel.userStyleSheet", JBHtmlEditorKit.createStyleSheet());
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @Override
            @NotNull
            protected Boolean compute() {
                Boolean bl;
                if (!SystemInfo.isXWindow) {
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return bl2;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    bl = (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Boolean bl3 = false;
                    if (bl3 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return bl3;
                }
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        DEFAULT_GRAY_FILTER = new GrayFilter(true, 70);
        DARCULA_GRAY_FILTER = new GrayFilter(true, 20);
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canRedo()) {
                    manager.redo();
                }
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canUndo()) {
                    manager.undo();
                }
            }
        };
        UNFOCUSED_SELECTION_COLOR = Gray._212;
        ACTIVE_HEADER_COLOR = new Color(160, 186, 213);
        INACTIVE_HEADER_COLOR = Gray._128;
        BORDER_COLOR = Color.LIGHT_GRAY;
        CONTRAST_BORDER_COLOR = new JBColor(new NotNullProducer<Color>(){
            final Color color = new JBColor(0x9B9B9B, 0x4B4B4B);

            @Override
            @NotNull
            public Color produce() {
                if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
                    Gray gray = Gray.xC9;
                    if (gray == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return gray;
                }
                Color color = this.color;
                if (color == null) {
                    4.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$4", "produce"));
            }
        });
        SIDE_PANEL_BACKGROUND = new JBColor(new NotNullProducer<Color>(){
            final JBColor myDefaultValue = new JBColor(new Color(15133680), new Color(4080460));

            @Override
            @NotNull
            public Color produce() {
                Color color = UIManager.getColor("SidePanel.background");
                Color color2 = color == null ? this.myDefaultValue : color;
                if (color2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return color2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$5", "produce"));
            }
        });
        AQUA_SEPARATOR_FOREGROUND_COLOR = new JBColor(Gray._223, Gray.x51);
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
        PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
        PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
        DEBUG_MARKER_BORDER = new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics g2 = g.create();
                try {
                    g2.setColor(JBColor.RED);
                    UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        };
        DEF_SYSTEM_FONT_SIZE = 12.0f;
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        jreHiDPI = new AtomicReference();
        ourDefaultIconMethodsCache = new ConcurrentHashMap<Class, Ref<Method>>();
        GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
        GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
        NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
        UI_TRAVERSER = JBTreeTraverser.from(new Function<Component, JBIterable<Component>>(){

            @Override
            public JBIterable<Component> fun(@NotNull Component c) {
                if (c == null) {
                    18.$$$reportNull$$$0(0);
                }
                JBIterable<Object> result2 = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : (c instanceof JComboBox && UIUtil.isUnderAquaLookAndFeel() ? JBIterable.empty() : UIUtil.uiChildren(c));
                if (c instanceof JComponent) {
                    JPopupMenu jpm;
                    JComponent jc = (JComponent)c;
                    Iterable<? extends Component> orphans = UIUtil.getClientProperty((Object)jc, NOT_IN_HIERARCHY_COMPONENTS);
                    if (orphans != null) {
                        result2 = result2.append(orphans);
                    }
                    if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                        result2 = result2.append(Collections.singletonList(jpm));
                    }
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/ui/UIUtil$18", "fun"));
            }
        });
        COMPONENT_PARENT = new Function.Mono<Component>(){

            @Override
            public Component fun(Component c) {
                return c.getParent();
            }
        };
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(DocumentEvent e) {
                Document document = e.getDocument();
                if (document instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                        for (final UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener instanceof UndoManager)) continue;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    ((UndoManager)listener).discardAllEdits();
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 75: 
            case 84: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 101: 
            case 103: 
            case 112: 
            case 114: 
            case 115: 
            case 119: 
            case 121: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 75: 
            case 84: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 101: 
            case 103: 
            case 112: 
            case 114: 
            case 115: 
            case 119: 
            case 121: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 19: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 65: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 69: 
            case 71: 
            case 73: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 113: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 22: 
            case 40: 
            case 79: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 75: 
            case 84: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 101: 
            case 103: 
            case 112: 
            case 114: 
            case 115: 
            case 119: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 29: 
            case 30: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 70: 
            case 72: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 74: 
            case 77: 
            case 81: 
            case 130: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 78: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 85: 
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 99: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 117: 
            case 118: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignSource";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStrokes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageForGraphics";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 101: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedTimer";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientPaint";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decorateFrame";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawFramingLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "drawLabelDottedRectangle";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLabelTextBounds";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 75: 
            case 84: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 101: 
            case 103: 
            case 112: 
            case 114: 
            case 115: 
            case 119: 
            case 121: {
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isValidFont";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "drawImage";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "paintWithXorOnRetina";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findParentByClass";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 99: 
            case 100: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "createNamedTimer";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "resetUndoRedoActions";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getTextAlignBorder";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "redirectKeystrokes";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "findWindowAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 75: 
            case 84: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 101: 
            case 103: 
            case 112: 
            case 114: 
            case 115: 
            case 119: 
            case 121: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JBHtmlEditorKit
    extends HTMLEditorKit {
        private static final Method MODEL_CHANGED = ReflectionUtil.getDeclaredMethod(BasicTextUI.class, "modelChanged", new Class[0]);
        private final StyleSheet style;
        private final HyperlinkListener myHyperlinkListener;

        @Override
        public StyleSheet getStyleSheet() {
            return this.style;
        }

        public static StyleSheet createStyleSheet() {
            StyleSheet style = new StyleSheet();
            style.addStyleSheet(UIUtil.isUnderDarcula() ? (StyleSheet)UIManager.getDefaults().get("StyledEditorKit.JBDefaultStyle") : DEFAULT_HTML_KIT_CSS);
            style.addRule("code { font-size: 100%; }");
            style.addRule("small { font-size: small; }");
            style.addRule("a { text-decoration: none;}");
            return style;
        }

        @Override
        public void install(final JEditorPane pane) {
            super.install(pane);
            if (pane != null) {
                pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        Font font = UIUtil.getLabelFont();
                        pane.setFont(font);
                        pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                        pane.removePropertyChangeListener(this);
                    }
                });
                pane.addHyperlinkListener(this.myHyperlinkListener);
            }
        }

        @Override
        public void deinstall(JEditorPane c) {
            c.removeHyperlinkListener(this.myHyperlinkListener);
            super.deinstall(c);
        }
    }

    static final class DetectRetinaKit {
        private static final Map<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = ContainerUtil.createWeakMap();

        static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
            Boolean isRetina = devicesToRetinaSupportCacheMap.get(device);
            if (isRetina != null) {
                return isRetina;
            }
            Method getScaleFactorMethod = null;
            try {
                getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (NoSuchMethodException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (Exception e) {
                LOG.debug(e);
                LOG.debug("CGraphicsDevice.getScaleFactor(): probably it is Java 9");
            }
            try {
                isRetina = getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
            }
            catch (IllegalAccessException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Access issue");
                isRetina = false;
            }
            catch (InvocationTargetException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Invocation issue");
                isRetina = false;
            }
            catch (IllegalArgumentException e) {
                LOG.debug("object is not an instance of declaring class: " + device.getClass().getName());
                isRetina = false;
            }
            devicesToRetinaSupportCacheMap.put(device, isRetina);
            return isRetina;
        }
    }
}

