/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import javaslang.collection.AbstractIterator;
import javaslang.collection.Queue;
import javaslang.collection.Stream;

interface StreamModule {

    public static final class StreamIterator<T>
    extends AbstractIterator<T> {
        private Supplier<Stream<T>> current = () -> stream2;

        StreamIterator(Stream.Cons<T> stream2) {
        }

        @Override
        public boolean hasNext() {
            return !this.current.get().isEmpty();
        }

        @Override
        public T getNext() {
            Stream<T> stream2 = this.current.get();
            this.current = stream2::tail;
            return stream2.head();
        }
    }

    public static interface StreamFactory {
        public static <T> Stream<T> create(Iterator<? extends T> iterator2) {
            return iterator2.hasNext() ? Stream.cons(iterator2.next(), () -> StreamFactory.create(iterator2)) : Stream.Empty.instance();
        }
    }

    public static final class AppendElements<T>
    extends Stream.Cons<T>
    implements Serializable {
        private final Queue<T> queue;

        AppendElements(T head, Queue<T> queue, Supplier<Stream<T>> tail) {
            super(head, tail);
            this.queue = queue;
        }

        @Override
        public Stream<T> append(T element) {
            return new AppendElements<Object>(this.head, this.queue.append(element), this.tail);
        }

        @Override
        public Stream<T> appendAll(Iterable<? extends T> elements) {
            Objects.requireNonNull(this.queue, "elements is null");
            return this.isEmpty() ? Stream.ofAll(this.queue) : new AppendElements<T>(this.head, this.queue.appendAll(elements), this.tail);
        }

        @Override
        public Stream<T> tail() {
            Stream t = (Stream)this.tail.get();
            if (t.isEmpty()) {
                return Stream.ofAll(this.queue);
            }
            if (t instanceof ConsImpl) {
                ConsImpl c = (ConsImpl)t;
                return new AppendElements(c.head(), this.queue, c.tail);
            }
            AppendElements a = (AppendElements)t;
            return new AppendElements(a.head(), a.queue.appendAll(this.queue), a.tail);
        }
    }

    public static final class ConsImpl<T>
    extends Stream.Cons<T>
    implements Serializable {
        ConsImpl(T head, Supplier<Stream<T>> tail) {
            super(head, tail);
        }

        @Override
        public Stream<T> tail() {
            return (Stream)this.tail.get();
        }
    }
}

