/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\u001d\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\u00020\u000b*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0016\u0010\u000f\u001a\u00020\u0002*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0001\u00a8\u0006\u0010"}, d2={"getUnsignedByte", "", "Lkotlinx/io/ByteBuffer;", "getUnsignedInt", "", "getUnsignedShort", "onlySingleOrNull", "T", "", "(Ljava/util/List;)Ljava/lang/Object;", "readExactNBytes", "", "Ljava/io/InputStream;", "Lkotlinx/io/InputStream;", "bytes", "readToByteBuffer", "kotlinx-serialization-runtime"})
public final class UtilKt {
    @Nullable
    public static final <T> T onlySingleOrNull(@NotNull List<? extends T> $receiver) {
        T t;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        switch ($receiver.size()) {
            case 0: {
                t = null;
                break;
            }
            case 1: {
                t = $receiver.get(0);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Too much arguments in list");
            }
        }
        return t;
    }

    @NotNull
    public static final byte[] readExactNBytes(@NotNull InputStream $receiver, int bytes) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] array = new byte[bytes];
        for (int read = 0; read < bytes; read += i) {
            i = $receiver.read(array, read, bytes - read);
            if (i != -1) continue;
            throw (Throwable)new IOException("Unexpected EOF");
        }
        return array;
    }

    @NotNull
    public static final ByteBuffer readToByteBuffer(@NotNull InputStream $receiver, int bytes) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] arr = UtilKt.readExactNBytes($receiver, bytes);
        ByteBuffer buf = ByteBuffer.Companion.allocate(bytes);
        buf.put(arr).flip();
        return buf;
    }

    public static final int getUnsignedByte(@NotNull ByteBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.get() & 0xFF;
    }

    public static final int getUnsignedShort(@NotNull ByteBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getShort() & 0xFFFF;
    }

    public static final long getUnsignedInt(@NotNull ByteBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (long)$receiver.getInt() & 0xFFFFFFFFL;
    }
}

