/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class Bib2GlsDualIndexAbbrev
extends Bib2GlsDualEntry {
    public Bib2GlsDualIndexAbbrev(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualindexabbreviation");
    }

    public Bib2GlsDualIndexAbbrev(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualIndexAbbrevMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualIndexAbbrevMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualIndexAbbrevMap();
    }

    @Override
    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualIndexAbbrev(this.bib2gls, this.getEntryType() + "secondary");
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("short") == null) {
            this.missingFieldWarning("short");
        }
        if (this.getField("long") == null) {
            this.missingFieldWarning("long");
        }
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            String string2;
            String string3 = string2 = this.isPrimary() ? "name" : this.resource.getAbbrevDefaultSortField();
            if (string2.equals("id")) {
                return this.getOriginalId();
            }
            String string4 = this.getFieldValue(string2);
            return string4 == null ? this.getFallbackValue(string2) : string4;
        }
        if (string.equals("name")) {
            String string5 = this.resource.getAbbrevDefaultNameField();
            String string6 = this.getFieldValue(string5);
            return string6 == null ? this.getFallbackValue(string5) : string6;
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            String string2;
            String string3 = string2 = this.isPrimary() ? "name" : this.resource.getAbbrevDefaultSortField();
            if (string2.equals("id")) {
                return this.getIdField();
            }
            BibValueList bibValueList = this.getField(string2);
            return bibValueList == null ? this.getFallbackContents(string2) : bibValueList;
        }
        if (string.equals("name")) {
            String string4 = this.resource.getAbbrevDefaultNameField();
            BibValueList bibValueList = this.getField(string4);
            return bibValueList == null ? this.getFallbackContents(string4) : bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s", this.getCsName());
        printWriter.format("{%s}", this.getId());
        if (this.isPrimary()) {
            printWriter.format("{%s}", this.getDual().getId());
        }
        printWriter.format("%%%n{", new Object[0]);
        String string = "";
        String string2 = "";
        String string3 = null;
        String string4 = "";
        String string5 = "";
        Set<String> set = this.getFieldSet();
        for (String string6 : set) {
            if (string6.equals("description")) {
                string2 = this.getFieldValue(string6);
                continue;
            }
            if (string6.equals("name")) {
                string3 = this.getFieldValue(string6);
                continue;
            }
            if (string6.equals("short")) {
                string4 = this.getFieldValue(string6);
                continue;
            }
            if (string6.equals("long")) {
                string5 = this.getFieldValue(string6);
                continue;
            }
            if (this.bib2gls.isKnownField(string6)) {
                printWriter.format("%s", string);
                string = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string6, this.getFieldValue(string6));
                continue;
            }
            if (this.bib2gls.getDebugLevel() <= 0 || this.bib2gls.isInternalField(string6)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", string6);
        }
        if (string3 == null) {
            string3 = this.getFallbackValue("name");
        }
        printWriter.println(String.format("}%%%n{%s}{%s}{%s}%n{%s}", string3, string4, string5, string2));
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        if (this.isPrimary()) {
            printWriter.println("\\ifdef\\glsuseabbrvfont");
            printWriter.println("{%");
            printWriter.println("  \\providecommand*{\\bibglsuseabbrvfont}{\\glsuseabbrvfont}");
            printWriter.println("}%");
            printWriter.println("{%");
            printWriter.println("  \\providecommand*{\\bibglsuseabbrvfont}[2]{{\\glssetabbrvfmt{#2}\\glsabbrvfont{#1}}}");
            printWriter.println("}%");
            printWriter.println("\\ifdef\\glsuselongfont");
            printWriter.println("{%");
            printWriter.println("  \\providecommand*{\\bibglsuselongfont}{\\glsuselongfont}");
            printWriter.println("}%");
            printWriter.println("{%");
            printWriter.println("  \\providecommand*{\\bibglsuselongfont}[2]{{\\glssetabbrvfmt{#2}\\glslongfont{#1}}}");
            printWriter.println("}%");
            printWriter.format("\\providecommand{\\%s}[7]{%%%n", this.getCsName());
            printWriter.println("  \\longnewglossaryentry*{#1}{%");
            printWriter.print("      name={\\protect");
            if (this.resource.getAbbrevDefaultNameField().equals("short")) {
                printWriter.print("\\bibglsuseabbrvfont");
            } else {
                printWriter.print("\\bibglsuselongfont");
            }
            printWriter.println("{#4}{\\glscategory{#2}}},%");
            printWriter.println("      category={index},#3}{}%");
        } else {
            printWriter.format("\\providecommand{\\%s}[6]{%%%n", this.getCsName());
            printWriter.println("  \\ifstrempty{#6}%");
            printWriter.println("  {\\newabbreviation[#2]{#1}{#4}{#5}}%");
            printWriter.println("  {\\newabbreviation[#2,description={#6}]{#1}{#4}{#5}}%");
        }
        printWriter.println("}");
    }
}

