/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.crypto;

import java.util.ArrayList;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionResult;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Component(role=SettingsDecrypter.class)
public class DefaultSettingsDecrypter
implements SettingsDecrypter {
    @Requirement(hint="maven")
    private SecDispatcher securityDispatcher;

    @Override
    public SettingsDecryptionResult decrypt(SettingsDecryptionRequest request) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server2 : request.getServers()) {
            server2 = server2.clone();
            servers.add(server2);
            try {
                server2.setPassword(this.decrypt(server2.getPassword()));
            }
            catch (SecDispatcherException e2) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt password for server " + server2.getId() + ": " + e2.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server2.getId(), -1, -1, e2));
            }
            try {
                server2.setPassphrase(this.decrypt(server2.getPassphrase()));
            }
            catch (SecDispatcherException e3) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt passphrase for server " + server2.getId() + ": " + e3.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server2.getId(), -1, -1, e3));
            }
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (Proxy proxy2 : request.getProxies()) {
            proxy2 = proxy2.clone();
            proxies.add(proxy2);
            try {
                proxy2.setPassword(this.decrypt(proxy2.getPassword()));
            }
            catch (SecDispatcherException e4) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt password for proxy " + proxy2.getId() + ": " + e4.getMessage(), SettingsProblem.Severity.ERROR, "proxy: " + proxy2.getId(), -1, -1, e4));
            }
        }
        return new DefaultSettingsDecryptionResult(servers, proxies, problems);
    }

    private String decrypt(String str2) throws SecDispatcherException {
        return str2 == null ? null : this.securityDispatcher.decrypt(str2);
    }
}

