/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.opengl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.lib.gleem.linalg.Vecf;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.selection.SelectionArea;
import org.gephi.visualization.apiimpl.Engine;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.apiimpl.GraphIO;
import org.gephi.visualization.apiimpl.Scheduler;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.apiimpl.VizEventManager;
import org.gephi.visualization.bridge.DataBridge;
import org.gephi.visualization.model.Model;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.edge.EdgeModeler;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.model.node.NodeModeler;
import org.gephi.visualization.octree.Octree;
import org.gephi.visualization.text.TextManager;

public abstract class AbstractEngine
implements Engine,
VizArchitecture {
    protected GraphDrawable graphDrawable;
    protected GraphIO graphIO;
    protected VizEventManager vizEventManager;
    protected SelectionArea currentSelectionArea;
    protected DataBridge dataBridge;
    protected VizController vizController;
    protected VizConfig vizConfig;
    protected TextManager textManager;
    protected boolean rectangleSelection;
    protected boolean customSelection;
    protected EngineLifeCycle lifeCycle = new EngineLifeCycle();
    protected boolean configChanged = false;
    protected boolean backgroundChanged = false;
    protected boolean reinit = false;
    protected float lightenAnimationDelta = 0.0f;
    protected Octree octree;
    protected NodeModeler nodeModeler;
    protected EdgeModeler edgeModeler;

    @Override
    public void initArchitecture() {
        this.graphDrawable = VizController.getInstance().getDrawable();
        this.graphIO = VizController.getInstance().getGraphIO();
        this.dataBridge = VizController.getInstance().getDataBridge();
        this.vizController = VizController.getInstance();
        this.vizConfig = VizController.getInstance().getVizConfig();
        this.textManager = VizController.getInstance().getTextManager();
        this.initObject3dClass();
        this.initSelection();
        this.vizController.getVizModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractEngine.this.configChanged = true;
                if (evt.getPropertyName().equals("backgroundColor")) {
                    AbstractEngine.this.backgroundChanged = true;
                }
                AbstractEngine.this.edgeModeler.setEnabled(AbstractEngine.this.vizController.getVizModel().isShowEdges());
            }
        });
    }

    public abstract void beforeDisplay(GL2 var1, GLU var2);

    public abstract void display(GL2 var1, GLU var2);

    public abstract void afterDisplay(GL2 var1, GLU var2);

    public abstract void initEngine(GL2 var1, GLU var2);

    public abstract void cameraHasBeenMoved(GL2 var1, GLU var2);

    public abstract void mouseMove();

    public abstract void mouseDrag();

    public abstract void startDrag();

    public abstract void stopDrag();

    public abstract void mouseClick();

    public abstract Scheduler getScheduler();

    public abstract void initDisplayLists(GL2 var1, GLU var2);

    public abstract void updateLOD();

    public abstract boolean updateWorld();

    public abstract void refreshGraphLimits();

    public abstract void initObject3dClass();

    public abstract void initSelection();

    protected abstract void startAnimating();

    protected abstract void stopAnimating();

    public abstract List<NodeModel> getSelectedNodes();

    public abstract List<Node> getSelectedUnderlyingNodes();

    public abstract List<EdgeModel> getSelectedEdges();

    public abstract List<Edge> getSelectedUnderlyingEdges();

    public abstract void selectObject(Model var1);

    public abstract void selectObject(Model[] var1);

    public abstract void resetSelection();

    public void reinit() {
        this.reinit = true;
    }

    protected boolean isUnderMouse(NodeModel obj) {
        if (!this.currentSelectionArea.isEnabled()) {
            return false;
        }
        float[] mousePosition = this.graphIO.getMousePosition3d();
        float xDist = Math.abs(obj.getX() - mousePosition[0]);
        float yDist = Math.abs(obj.getY() - mousePosition[1]);
        float distance = (float)Math.sqrt(xDist * xDist + yDist * yDist);
        Vecf d = new Vecf(3);
        d.set(0, xDist);
        d.set(1, yDist);
        d.set(2, distance);
        return this.currentSelectionArea.mouseTest(d, obj);
    }

    public SelectionArea getCurrentSelectionArea() {
        return this.currentSelectionArea;
    }

    public boolean isRectangleSelection() {
        return this.rectangleSelection;
    }

    public void setRectangleSelection(boolean rectangleSelection) {
        this.vizConfig.setRectangleSelection(rectangleSelection);
        this.initSelection();
        this.configChanged = true;
        this.lightenAnimationDelta = 0.0f;
        this.vizConfig.setLightenNonSelected(false);
    }

    public void setConfigChanged(boolean configChanged) {
        this.configChanged = configChanged;
    }

    public void startDisplay() {
        this.lifeCycle.requestStartAnimating();
    }

    public void stopDisplay() {
        this.lifeCycle.requestStopAnimating();
    }

    public void pauseDisplay() {
        this.lifeCycle.requestPauseAnimating();
    }

    public void resumeDisplay() {
        this.lifeCycle.requestResumeAnimating();
    }

    public Octree getOctree() {
        return this.octree;
    }

    public NodeModeler getNodeModeler() {
        return this.nodeModeler;
    }

    public EdgeModeler getEdgeModeler() {
        return this.edgeModeler;
    }

    public NodeModel[] getNodeModelsForNodes(Node[] nodes) {
        return this.dataBridge.getNodeModelsForNodes(nodes);
    }

    public EdgeModel[] getEdgeModelsForEdges(Edge[] edges) {
        return this.dataBridge.getEdgeModelsForEdges(edges);
    }

    protected class EngineLifeCycle {
        private boolean started;
        private boolean inited;
        private boolean requestAnimation;

        protected EngineLifeCycle() {
        }

        public void requestPauseAnimating() {
            if (this.inited) {
                AbstractEngine.this.stopAnimating();
            }
        }

        public void requestResumeAnimating() {
            if (!this.started) {
                return;
            }
            if (this.inited) {
                AbstractEngine.this.startAnimating();
            } else {
                this.requestAnimation = true;
            }
        }

        public void requestStartAnimating() {
            this.started = true;
            this.requestResumeAnimating();
        }

        public void requestStopAnimating() {
            this.requestPauseAnimating();
            this.started = false;
        }

        public void initEngine() {
        }

        public boolean isInited() {
            return this.inited;
        }

        public void setInited() {
            if (!this.inited) {
                this.inited = true;
                if (this.requestAnimation) {
                    AbstractEngine.this.startAnimating();
                    this.requestAnimation = false;
                }
            } else {
                AbstractEngine.this.dataBridge.reset();
                AbstractEngine.this.textManager.initArchitecture();
            }
        }
    }

    public static enum Limits {
        MIN_X,
        MAX_X,
        MIN_Y,
        MAX_Y,
        MIN_Z,
        MAX_Z;

    }
}

