/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf.url;

import com.mysql.cj.core.Messages;
import com.mysql.cj.core.conf.url.ConnectionUrl;
import com.mysql.cj.core.conf.url.ConnectionUrlParser;
import com.mysql.cj.core.conf.url.HostInfo;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.util.StringUtils;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;

public class XDevAPIConnectionUrl
extends ConnectionUrl {
    private static final int DEFAULT_PORT = 33060;

    protected XDevAPIConnectionUrl(ConnectionUrlParser connStrParser, Properties info) {
        super(connStrParser, info);
        this.type = ConnectionUrl.Type.XDEVAPI_SESSION;
        boolean first = true;
        String user = null;
        String password = null;
        boolean hasPriority = false;
        for (HostInfo hi2 : this.hosts) {
            if (first) {
                first = false;
                user = hi2.getUser();
                password = hi2.getPassword();
                hasPriority = hi2.getHostProperties().containsKey("PRIORITY");
            } else {
                if (!user.equals(hi2.getUser()) || !password.equals(hi2.getPassword())) {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.14", new Object[]{ConnectionUrl.Type.XDEVAPI_SESSION.getProtocol()}));
                }
                if (hasPriority ^ hi2.getHostProperties().containsKey("PRIORITY")) {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.15", new Object[]{ConnectionUrl.Type.XDEVAPI_SESSION.getProtocol()}));
                }
            }
            if (!hasPriority) continue;
            try {
                int priority = Integer.parseInt(hi2.getProperty("PRIORITY"));
                if (priority >= 0 && priority <= 100) continue;
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.16", new Object[]{ConnectionUrl.Type.XDEVAPI_SESSION.getProtocol()}));
            }
            catch (NumberFormatException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.16", new Object[]{ConnectionUrl.Type.XDEVAPI_SESSION.getProtocol()}));
            }
        }
        if (hasPriority) {
            this.hosts.sort(Comparator.comparing(hi -> Integer.parseInt(hi.getHostProperties().get("PRIORITY"))).reversed());
        }
    }

    @Override
    protected void processColdFusionAutoConfiguration() {
    }

    @Override
    protected Map<String, String> preprocessPerTypeHostProperties(Map<String, String> hostProps) {
        if (hostProps.containsKey("ADDRESS")) {
            String address = hostProps.get("ADDRESS");
            ConnectionUrlParser.Pair<String, Integer> hostPortPair = ConnectionUrlParser.parseHostPortPair(address);
            String host = StringUtils.safeTrim((String)hostPortPair.left);
            Integer port = (Integer)hostPortPair.right;
            if (!StringUtils.isNullOrEmpty(host) && !hostProps.containsKey("HOST")) {
                hostProps.put("HOST", host);
            }
            if (port != -1 && !hostProps.containsKey("PORT")) {
                hostProps.put("PORT", port.toString());
            }
        }
        return hostProps;
    }

    @Override
    public int getDefaultPort() {
        return 33060;
    }

    @Override
    protected void fixProtocolDependencies(Map<String, String> hostProps) {
    }
}

