/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.webpane.platform.graphics.WCGraphicsManager;
import com.sun.webpane.platform.graphics.WCImage;
import com.sun.webpane.platform.graphics.WCImageFrame;
import com.sun.webpane.platform.graphics.WCImgDecoder;
import com.sun.webpane.sg.prism.PrismImage;
import com.sun.webpane.sg.prism.WCImageImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;

public class WCImgDecoderImpl
extends WCImgDecoder {
    private static final Logger log = Logger.getLogger(WCImgDecoderImpl.class.getName());
    private Service<ImageFrame[]> loader;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private ImageFrame[] frames;
    private PrismImage[] images;
    private volatile byte[] data;
    private volatile int dataSize;
    ImageLoadListener readerListener = new ImageLoadListener(){

        @Override
        public void imageLoadProgress(ImageLoader imageLoader, float f) {
        }

        @Override
        public void imageLoadWarning(ImageLoader imageLoader, String string) {
        }

        @Override
        public void imageLoadMetaData(ImageLoader imageLoader, ImageMetadata imageMetadata) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%s Image size %dx%d", this, imageMetadata.imageWidth, imageMetadata.imageHeight));
            }
            if (WCImgDecoderImpl.this.imageWidth < imageMetadata.imageWidth) {
                WCImgDecoderImpl.this.imageWidth = imageMetadata.imageWidth;
            }
            if (WCImgDecoderImpl.this.imageHeight < imageMetadata.imageHeight) {
                WCImgDecoderImpl.this.imageHeight = imageMetadata.imageHeight;
            }
        }
    };

    @Override
    public void destroy() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%s Destroy image decoder", this));
        }
        super.destroy();
        if (this.loader != null) {
            this.loader.cancel();
            this.loader = null;
        }
    }

    @Override
    public String getFilenameExtension() {
        return ".img";
    }

    @Override
    public void addImageData(byte[] byArray) {
        if (byArray != null) {
            if (this.data == null) {
                this.data = byArray;
                this.dataSize = byArray.length;
            } else {
                int n = this.dataSize + byArray.length;
                if (n > this.data.length) {
                    byte[] byArray2 = new byte[Math.max(n, this.data.length * 2)];
                    System.arraycopy(this.data, 0, byArray2, 0, this.dataSize);
                    this.data = byArray2;
                }
                System.arraycopy(byArray, 0, this.data, this.dataSize, byArray.length);
                this.dataSize = n;
            }
        }
        if (this.loader == null) {
            this.loader = new Service<ImageFrame[]>(){

                @Override
                protected Task<ImageFrame[]> createTask() {
                    return new Task<ImageFrame[]>(){

                        @Override
                        protected ImageFrame[] call() throws Exception {
                            return WCImgDecoderImpl.this.loadFrames();
                        }
                    };
                }
            };
            this.loader.valueProperty().addListener(new ChangeListener<ImageFrame[]>(){

                @Override
                public void changed(ObservableValue<? extends ImageFrame[]> observableValue, ImageFrame[] imageFrameArray, ImageFrame[] imageFrameArray2) {
                    if (imageFrameArray2 != null && WCImgDecoderImpl.this.loader != null) {
                        WCImgDecoderImpl.this.setFrames(imageFrameArray2);
                    }
                }
            });
        }
        if (byArray == null) {
            this.loader.cancel();
            this.loader = null;
            this.setFrames(this.loadFrames());
        } else if (!this.loader.isRunning()) {
            this.loader.restart();
        }
    }

    @Override
    public void loadFromResource(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%s Load image from resource '%s'", this, string));
        }
        String string2 = WCGraphicsManager.getResourceName(string);
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%s Unable to open resource '%s'", this, string2));
            }
            return;
        }
        this.setFrames(this.loadFrames(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageFrame[] loadFrames(InputStream inputStream) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%s Decoding frames", this));
        }
        try {
            ImageFrame[] imageFrameArray = ImageStorage.loadAll(inputStream, this.readerListener, 0, 0, true, 1.0f, false);
            return imageFrameArray;
        }
        catch (ImageStorageException imageStorageException) {
            ImageFrame[] imageFrameArray = null;
            return imageFrameArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ImageFrame[] loadFrames() {
        return this.loadFrames(new ByteArrayInputStream(this.data, 0, this.dataSize));
    }

    @Override
    public void getImageSize(int[] nArray) {
        nArray[0] = this.imageWidth;
        nArray[1] = this.imageHeight;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%s image size = %dx%d", this, nArray[0], nArray[1]));
        }
    }

    private void setFrames(ImageFrame[] imageFrameArray) {
        this.frames = imageFrameArray;
        this.images = null;
        if (imageFrameArray != null) {
            this.notifyObserver();
        }
    }

    @Override
    public int getFrameCount() {
        return this.frames != null ? this.frames.length : 0;
    }

    @Override
    public WCImageFrame getFrame(int n, int[] nArray) {
        ImageFrame imageFrame = this.getImageFrame(n);
        if (imageFrame != null) {
            Object object;
            if (log.isLoggable(Level.FINE)) {
                object = imageFrame.getImageType();
                log.fine(String.format("%s getFrame(%d): image type = %s", this, n, object));
            }
            object = this.getPrismImage(n, imageFrame);
            if (nArray != null) {
                int n2;
                ImageMetadata imageMetadata = imageFrame.getMetadata();
                int n3 = n2 = imageMetadata == null || imageMetadata.delayTime == null ? 0 : imageMetadata.delayTime;
                if (n2 < 11) {
                    n2 = 100;
                }
                nArray[0] = n < this.frames.length - 1 ? 1 : 0;
                nArray[1] = ((WCImage)object).getWidth();
                nArray[2] = ((WCImage)object).getHeight();
                nArray[3] = n2;
                nArray[4] = 1;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.format("%s getFrame(%d): complete=%d, size=%dx%d, duration=%d, hasAlpha=%d", this, n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]));
                }
            }
            return new Frame((WCImage)object);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%s FAILED getFrame(%d)", this, n));
        }
        return null;
    }

    private ImageFrame getImageFrame(int n) {
        return n >= 0 && this.frames != null && this.frames.length > n ? this.frames[n] : null;
    }

    private PrismImage getPrismImage(int n, ImageFrame imageFrame) {
        if (this.images == null) {
            this.images = new PrismImage[this.frames.length];
        }
        if (this.images[n] == null) {
            this.images[n] = new WCImageImpl(imageFrame);
        }
        return this.images[n];
    }

    static class Frame
    extends WCImageFrame {
        WCImage image;

        public Frame(WCImage wCImage) {
            this.image = wCImage;
        }

        @Override
        public WCImage getFrame() {
            return this.image;
        }

        @Override
        public void destroyDecodedData() {
            this.image = null;
        }
    }
}

