/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesUrlBoundsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesUrlIdTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeCompressedTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmCompressedTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmIdTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmUrlTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.DownloadSessionTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class OpenLocationAction
extends JosmAction {
    private static final BooleanProperty USE_NEW_LAYER = new BooleanProperty("download.location.newlayer", false);
    private static final BooleanProperty DOWNLOAD_ZOOMTODATA = new BooleanProperty("download.location.zoomtodata", true);
    protected final transient List<Class<? extends DownloadTask>> downloadTasks;

    public OpenLocationAction() {
        super(I18n.tr("Open Location...", new Object[0]), "openlocation", I18n.tr("Open an URL.", new Object[0]), Shortcut.registerShortcut("system:open_location", I18n.tr("File: {0}", I18n.tr("Open Location...", new Object[0])), 76, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/OpenLocation"));
        this.downloadTasks = new ArrayList<Class<? extends DownloadTask>>();
        this.addDownloadTaskClass(DownloadOsmTask.class);
        this.addDownloadTaskClass(DownloadGpsTask.class);
        this.addDownloadTaskClass(DownloadNotesTask.class);
        this.addDownloadTaskClass(DownloadOsmChangeTask.class);
        this.addDownloadTaskClass(DownloadOsmUrlTask.class);
        this.addDownloadTaskClass(DownloadOsmIdTask.class);
        this.addDownloadTaskClass(DownloadOsmCompressedTask.class);
        this.addDownloadTaskClass(DownloadOsmChangeCompressedTask.class);
        this.addDownloadTaskClass(DownloadSessionTask.class);
        this.addDownloadTaskClass(DownloadNotesUrlBoundsTask.class);
        this.addDownloadTaskClass(DownloadNotesUrlIdTask.class);
    }

    protected void restoreUploadAddressHistory(HistoryComboBox cbHistory) {
        LinkedList<String> cmtHistory = new LinkedList<String>(Config.getPref().getList(this.getClass().getName() + ".uploadAddressHistory", new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        cbHistory.setPossibleItems(cmtHistory);
    }

    protected void remindUploadAddressHistory(HistoryComboBox cbHistory) {
        cbHistory.addCurrentItemToHistory();
        Config.getPref().putList(this.getClass().getName() + ".uploadAddressHistory", cbHistory.getHistory());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel all = new JPanel(new GridBagLayout());
        all.add((Component)new JLabel(I18n.tr("Enter URL to download:", new Object[0])), GBC.eol());
        HistoryComboBox uploadAddresses = new HistoryComboBox();
        uploadAddresses.setToolTipText(I18n.tr("Enter an URL from where data should be downloaded", new Object[0]));
        this.restoreUploadAddressHistory(uploadAddresses);
        all.add((Component)uploadAddresses, GBC.eop().fill(1));
        JCheckBox layer = new JCheckBox(I18n.tr("Download as new layer", new Object[0]));
        layer.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer", new Object[0]));
        layer.setSelected(USE_NEW_LAYER.get());
        all.add((Component)layer, GBC.eop().fill(1));
        JCheckBox zoom = new JCheckBox(I18n.tr("Zoom to downloaded data", new Object[0]));
        zoom.setToolTipText(I18n.tr("Select to zoom to entire newly downloaded data.", new Object[0]));
        zoom.setSelected(DOWNLOAD_ZOOMTODATA.get());
        all.add((Component)zoom, GBC.eop().fill(1));
        ExpertToggleAction.addVisibilitySwitcher(zoom);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Download Location", new Object[0]), I18n.tr("Download URL", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(all, false).setButtonIcons("download", "cancel").setToolTipTexts(I18n.tr("Start downloading data", new Object[0]), I18n.tr("Close dialog and cancel downloading", new Object[0])).configureContextsensitiveHelp("/Action/OpenLocation", true);
        dialog.setupDialog();
        dialog.pack();
        dialog.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, dialog.getPreferredSize()));
        if (dialog.showDialog().getValue() == 1) {
            USE_NEW_LAYER.put(layer.isSelected());
            DOWNLOAD_ZOOMTODATA.put(zoom.isSelected());
            this.remindUploadAddressHistory(uploadAddresses);
            this.openUrl(Utils.strip(uploadAddresses.getText()));
        }
    }

    public Collection<DownloadTask> findDownloadTasks(String url, boolean isRemotecontrol) {
        return this.downloadTasks.stream().filter(Objects::nonNull).map(taskClass -> {
            try {
                return (DownloadTask)taskClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                Logging.error(e);
                return null;
            }
        }).filter(Objects::nonNull).filter(task -> task.acceptsUrl(url, isRemotecontrol)).collect(Collectors.toList());
    }

    public String findSummaryDocumentation() {
        StringBuilder result = new StringBuilder("<table>");
        for (Class<? extends DownloadTask> taskClass : this.downloadTasks) {
            if (taskClass == null) continue;
            try {
                DownloadTask task = taskClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                result.append(task.acceptsDocumentationSummary());
            }
            catch (ReflectiveOperationException e) {
                Logging.error(e);
            }
        }
        result.append("</table>");
        return result.toString();
    }

    public List<Future<?>> openUrl(boolean newLayer, String url) {
        return this.openUrl(new DownloadParams().withNewLayer(newLayer), url);
    }

    public List<Future<?>> openUrl(DownloadParams settings, String url) {
        return this.openUrl(settings, (boolean)DOWNLOAD_ZOOMTODATA.get(), url);
    }

    public List<Future<?>> openUrl(String url) {
        return this.openUrl(USE_NEW_LAYER.get(), (boolean)DOWNLOAD_ZOOMTODATA.get(), url);
    }

    public List<Future<?>> openUrl(boolean newLayer, boolean zoomToData, String url) {
        return this.openUrl(new DownloadParams().withNewLayer(newLayer), zoomToData, url);
    }

    public List<Future<?>> openUrl(DownloadParams settings, boolean zoomToData, String url) {
        Collection<DownloadTask> tasks = this.findDownloadTasks(url, false);
        if (tasks.size() > 1) {
            tasks = this.askWhichTasksToLoad(tasks);
        } else if (tasks.isEmpty()) {
            this.warnNoSuitableTasks(url);
            return Collections.emptyList();
        }
        PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr("Download data", new Object[0]));
        ArrayList result = new ArrayList();
        for (DownloadTask task : tasks) {
            try {
                task.setZoomAfterDownload(zoomToData);
                result.add(MainApplication.worker.submit(new PostDownloadHandler(task, task.loadUrl(settings, url, monitor))));
            }
            catch (IllegalArgumentException e) {
                Logging.error(e);
            }
        }
        return result;
    }

    Collection<DownloadTask> askWhichTasksToLoad(Collection<DownloadTask> tasks) {
        JList<DownloadTask> list = new JList<DownloadTask>(tasks.toArray(new DownloadTask[0]));
        list.addSelectionInterval(0, tasks.size() - 1);
        WhichTasksToPerformDialog dialog = new WhichTasksToPerformDialog(list);
        dialog.showDialog();
        return dialog.getValue() == 1 ? list.getSelectedValuesList() : Collections.emptyList();
    }

    protected void warnNoSuitableTasks(String url) {
        String details = this.findSummaryDocumentation();
        HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, "<html><p>" + I18n.tr("Cannot open URL ''{0}''<br>The following download tasks accept the URL patterns shown:<br>{1}", url, details) + "</p></html>", I18n.tr("Download Location", new Object[0]), 0, HelpUtil.ht("/Action/OpenLocation"));
    }

    public final boolean addDownloadTaskClass(Class<? extends DownloadTask> taskClass) {
        return this.downloadTasks.add(taskClass);
    }

    static class WhichTasksToPerformDialog
    extends ExtendedDialog {
        WhichTasksToPerformDialog(JList<DownloadTask> list) {
            super(Main.parent, I18n.tr("Which tasks to perform?", new Object[0]), new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])}, true);
            this.setButtonIcons("ok", "cancel");
            JPanel pane = new JPanel(new GridLayout(2, 1));
            pane.add(new JLabel(I18n.tr("Which tasks to perform?", new Object[0])));
            pane.add(list);
            this.setContent(pane);
        }
    }
}

