/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public final class MultipolygonCache
implements DataSetListener,
LayerManager.LayerChangeListener,
ProjectionChangeListener,
DataSelectionListener {
    private static final MultipolygonCache INSTANCE = new MultipolygonCache();
    private final Map<DataSet, Map<Relation, Multipolygon>> cache = new ConcurrentHashMap<DataSet, Map<Relation, Multipolygon>>();
    private final Collection<Multipolygon.PolyData> selectedPolyData = new ArrayList<Multipolygon.PolyData>();

    private MultipolygonCache() {
        Main.addProjectionChangeListener(this);
        SelectionEventManager.getInstance().addSelectionListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
    }

    public static MultipolygonCache getInstance() {
        return INSTANCE;
    }

    public Multipolygon get(Relation r) {
        return this.get(r, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multipolygon get(Relation r, boolean forceRefresh) {
        Multipolygon multipolygon = null;
        if (r != null && r.getDataSet() != null) {
            Map<Relation, Multipolygon> map2 = this.cache.get(r.getDataSet());
            if (map2 == null) {
                map2 = new ConcurrentHashMap<Relation, Multipolygon>();
                this.cache.put(r.getDataSet(), map2);
            }
            if ((multipolygon = map2.get(r)) == null || forceRefresh) {
                multipolygon = new Multipolygon(r);
                map2.put(r, multipolygon);
                MultipolygonCache multipolygonCache = this;
                synchronized (multipolygonCache) {
                    for (Multipolygon.PolyData pd : multipolygon.getCombinedPolygons()) {
                        if (!pd.isSelected()) continue;
                        this.selectedPolyData.add(pd);
                    }
                }
            }
        }
        return multipolygon;
    }

    public void clear(DataSet ds) {
        Map<Relation, Multipolygon> map2 = this.cache.remove(ds);
        if (map2 != null) {
            map2.clear();
        }
    }

    public void clear() {
        this.cache.clear();
    }

    private Collection<Map<Relation, Multipolygon>> getMapsFor(DataSet ds) {
        ArrayList<Map<Relation, Multipolygon>> result = new ArrayList<Map<Relation, Multipolygon>>();
        Map<Relation, Multipolygon> map2 = this.cache.get(ds);
        if (map2 != null) {
            result.add(map2);
        }
        return result;
    }

    private static boolean isMultipolygon(OsmPrimitive p) {
        return p instanceof Relation && ((Relation)p).isMultipolygon();
    }

    private void updateMultipolygonsReferringTo(AbstractDatasetChangedEvent event) {
        this.updateMultipolygonsReferringTo(event, event.getPrimitives(), event.getDataset());
    }

    private void updateMultipolygonsReferringTo(AbstractDatasetChangedEvent event, Collection<? extends OsmPrimitive> primitives, DataSet ds) {
        this.updateMultipolygonsReferringTo(event, primitives, ds, null);
    }

    private Collection<Map<Relation, Multipolygon>> updateMultipolygonsReferringTo(AbstractDatasetChangedEvent event, Collection<? extends OsmPrimitive> primitives, DataSet ds, Collection<Map<Relation, Multipolygon>> initialMaps) {
        Collection<Map<Relation, Multipolygon>> maps = initialMaps;
        if (primitives != null) {
            for (OsmPrimitive osmPrimitive : primitives) {
                if (MultipolygonCache.isMultipolygon(osmPrimitive)) {
                    if (maps == null) {
                        maps = this.getMapsFor(ds);
                    }
                    MultipolygonCache.processEvent(event, (Relation)osmPrimitive, maps);
                    continue;
                }
                if (osmPrimitive instanceof Way && osmPrimitive.getDataSet() != null) {
                    for (OsmPrimitive ref : osmPrimitive.getReferrers()) {
                        if (!MultipolygonCache.isMultipolygon(ref)) continue;
                        if (maps == null) {
                            maps = this.getMapsFor(ds);
                        }
                        MultipolygonCache.processEvent(event, (Relation)ref, maps);
                    }
                    continue;
                }
                if (!(osmPrimitive instanceof Node) || osmPrimitive.getDataSet() == null) continue;
                maps = this.updateMultipolygonsReferringTo(event, osmPrimitive.getReferrers(), ds, maps);
            }
        }
        return maps;
    }

    private static void processEvent(AbstractDatasetChangedEvent event, Relation r, Collection<Map<Relation, Multipolygon>> maps) {
        if (event instanceof NodeMovedEvent || event instanceof WayNodesChangedEvent) {
            MultipolygonCache.dispatchEvent(event, r, maps);
        } else if (event instanceof PrimitivesRemovedEvent) {
            if (event.getPrimitives().contains(r)) {
                MultipolygonCache.removeMultipolygonFrom(r, maps);
            }
        } else {
            MultipolygonCache.removeMultipolygonFrom(r, maps);
        }
    }

    private static void dispatchEvent(AbstractDatasetChangedEvent event, Relation r, Collection<Map<Relation, Multipolygon>> maps) {
        for (Map<Relation, Multipolygon> map : maps) {
            Multipolygon m = map.get(r);
            if (m == null) continue;
            for (Multipolygon.PolyData pd : m.getCombinedPolygons()) {
                if (event instanceof NodeMovedEvent) {
                    pd.nodeMoved((NodeMovedEvent)event);
                    continue;
                }
                if (!(event instanceof WayNodesChangedEvent)) continue;
                boolean oldClosedStatus = pd.isClosed();
                pd.wayNodesChanged((WayNodesChangedEvent)event);
                if (pd.isClosed() == oldClosedStatus) continue;
                MultipolygonCache.removeMultipolygonFrom(r, maps);
                return;
            }
        }
    }

    private static void removeMultipolygonFrom(Relation r, Collection<Map<Relation, Multipolygon>> maps) {
        for (Map<Relation, Multipolygon> map : maps) {
            map.remove(r);
        }
        for (OsmPrimitive member : r.getMemberPrimitivesList()) {
            member.clearCachedStyle();
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        Collection<Map<Relation, Multipolygon>> maps = null;
        for (OsmPrimitive p : event.getPrimitives()) {
            if (!MultipolygonCache.isMultipolygon(p)) continue;
            if (maps == null) {
                maps = this.getMapsFor(event.getDataset());
            }
            for (Map map : maps) {
                map.remove(p);
            }
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof OsmDataLayer) {
            this.clear(((OsmDataLayer)e.getRemovedLayer()).data);
        }
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        this.clear();
    }

    @Override
    public synchronized void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        Iterator<Multipolygon.PolyData> it = this.selectedPolyData.iterator();
        while (it.hasNext()) {
            it.next().setSelected(false);
            it.remove();
        }
        DataSet ds = null;
        Collection<Map<Relation, Multipolygon>> maps = null;
        for (OsmPrimitive p : event.getSelection()) {
            if (!(p instanceof Way) || p.getDataSet() == null) continue;
            if (ds == null) {
                ds = p.getDataSet();
            }
            for (OsmPrimitive ref : p.getReferrers()) {
                if (!MultipolygonCache.isMultipolygon(ref)) continue;
                if (maps == null) {
                    maps = this.getMapsFor(ds);
                }
                for (Map map : maps) {
                    Multipolygon multipolygon = (Multipolygon)map.get(ref);
                    if (multipolygon == null) continue;
                    for (Multipolygon.PolyData pd : multipolygon.getCombinedPolygons()) {
                        if (!pd.getWayIds().contains(p.getUniqueId())) continue;
                        pd.setSelected(true);
                        this.selectedPolyData.add(pd);
                    }
                }
            }
        }
    }
}

