/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.nmea.NmeaReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class NMEAImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("nmea,nme,nma,log,txt", "nmea", I18n.tr("NMEA-0183 Files", new Object[0]), false);

    public NMEAImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String fn = file.getName();
        try (InputStream fis = Compression.getUncompressedFileInputStream(file);){
            NmeaReader r = NMEAImporter.buildAndParse(fis);
            if (r.getNumberOfCoordinates() > 0) {
                r.getGpxData().storageFile = file;
                GpxLayer gpxLayer = new GpxLayer(r.getGpxData(), fn, true);
                File fileFinal = file;
                GuiHelper.runInEDT(() -> {
                    MainApplication.getLayerManager().addLayer(gpxLayer);
                    if (Config.getPref().getBoolean("marker.makeautomarkers", true)) {
                        MarkerLayer ml = new MarkerLayer(r.getGpxData(), I18n.tr("Markers from {0}", fn), fileFinal, gpxLayer);
                        if (!ml.data.isEmpty()) {
                            MainApplication.getLayerManager().addLayer(ml);
                        }
                    }
                });
            }
            NMEAImporter.showNmeaInfobox(r.getNumberOfCoordinates() > 0, r);
        }
    }

    private static void showNmeaInfobox(boolean success, NmeaReader r) {
        StringBuilder msg = new StringBuilder(160).append("<html>").append(I18n.tr("Coordinates imported: {0}", r.getNumberOfCoordinates())).append("<br>").append(I18n.tr("Malformed sentences: {0}", r.getParserMalformed())).append("<br>").append(I18n.tr("Checksum errors: {0}", r.getParserChecksumErrors())).append("<br>");
        if (!success) {
            msg.append(I18n.tr("Unknown sentences: {0}", r.getParserUnknown())).append("<br>");
        }
        msg.append(I18n.tr("Zero coordinates: {0}", r.getParserZeroCoordinates())).append("</html>");
        if (success) {
            SwingUtilities.invokeLater(() -> new Notification("<h3>" + I18n.tr("NMEA import success:", new Object[0]) + "</h3>" + msg.toString()).setIcon(1).show());
        } else {
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, msg.toString(), I18n.tr("NMEA import failure!", new Object[0]), 0, null);
        }
    }

    public static GpxImporter.GpxImporterData loadLayers(InputStream is, File associatedFile, String gpxLayerName, String markerLayerName) throws IOException {
        NmeaReader r = NMEAImporter.buildAndParse(is);
        boolean parsedProperly = r.getNumberOfCoordinates() > 0;
        r.getGpxData().storageFile = associatedFile;
        return GpxImporter.loadLayers(r.getGpxData(), parsedProperly, gpxLayerName, markerLayerName);
    }

    static NmeaReader buildAndParse(InputStream fis) throws IOException {
        NmeaReader r = new NmeaReader(fis);
        try {
            r.parse(true);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return r;
    }
}

