/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.util.containers.IntStack;
import java.util.ArrayList;

final class MarkerPool
extends ArrayList<PsiBuilderImpl.ProductionMarker> {
    private final PsiBuilderImpl myBuilder;
    private final IntStack myFreeStartMarkers = new IntStack();
    private final IntStack myFreeErrorItems = new IntStack();

    MarkerPool(PsiBuilderImpl builder) {
        this.myBuilder = builder;
        this.add(null);
    }

    PsiBuilderImpl.StartMarker allocateStartMarker() {
        if (this.myFreeStartMarkers.size() > 0) {
            return (PsiBuilderImpl.StartMarker)this.get(this.myFreeStartMarkers.pop());
        }
        PsiBuilderImpl.StartMarker marker = new PsiBuilderImpl.StartMarker(this.size(), this.myBuilder);
        this.add(marker);
        return marker;
    }

    PsiBuilderImpl.ErrorItem allocateErrorItem() {
        if (this.myFreeErrorItems.size() > 0) {
            return (PsiBuilderImpl.ErrorItem)this.get(this.myFreeErrorItems.pop());
        }
        PsiBuilderImpl.ErrorItem item = new PsiBuilderImpl.ErrorItem(this.size(), this.myBuilder);
        this.add(item);
        return item;
    }

    void freeMarker(PsiBuilderImpl.ProductionMarker marker) {
        marker.clean();
        (marker instanceof PsiBuilderImpl.StartMarker ? this.myFreeStartMarkers : this.myFreeErrorItems).push(marker.markerId);
    }
}

