/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.Extension;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.PKIXRevocationChecker;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;
import sun.security.x509.X509CertImpl;

class RevocationChecker
extends PKIXRevocationChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private TrustAnchor anchor;
    private PKIX.ValidatorParams params;
    private boolean onlyEE;
    private boolean softFail;
    private boolean crlDP;
    private URI responderURI;
    private X509Certificate responderCert;
    private List<CertStore> certStores;
    private Map<X509Certificate, byte[]> ocspStapled;
    private List<Extension> ocspExtensions;
    private final boolean legacy;
    private OCSPResponse.IssuerInfo issuerInfo;
    private PublicKey prevPubKey;
    private boolean crlSignFlag;
    private Mode mode = Mode.PREFER_OCSP;
    private static final long MAX_CLOCK_SKEW = 900000L;
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final boolean[] CRL_SIGN_USAGE = new boolean[]{false, false, false, false, false, false, true};

    RevocationChecker() {
        this.legacy = false;
    }

    RevocationChecker(TrustAnchor anchor, PKIX.ValidatorParams params) throws CertPathValidatorException {
        this.legacy = true;
        this.init(anchor, params);
    }

    void init(TrustAnchor anchor, PKIX.ValidatorParams params) throws CertPathValidatorException {
        block9: {
            RevocationProperties rp = RevocationChecker.getRevocationProperties();
            URI uri = this.getOCSPResponder();
            this.responderURI = uri == null ? RevocationChecker.toURI(rp.ocspUrl) : uri;
            X509Certificate cert = this.getOCSPResponderCert();
            this.responderCert = cert == null ? RevocationChecker.getResponderCert(rp, params.trustAnchors(), params.certStores()) : cert;
            Set<PKIXRevocationChecker.Option> options = this.getOptions();
            block5: for (PKIXRevocationChecker.Option option : options) {
                switch (option) {
                    case ONLY_END_ENTITY: 
                    case PREFER_CRLS: 
                    case SOFT_FAIL: {
                        continue block5;
                    }
                }
                throw new CertPathValidatorException("Unrecognized revocation parameter option: " + (Object)((Object)option));
            }
            if (this.legacy) {
                this.mode = rp.ocspEnabled ? Mode.PREFER_OCSP : Mode.ONLY_CRLS;
                this.onlyEE = rp.onlyEE;
            } else {
                if (options.contains((Object)PKIXRevocationChecker.Option.PREFER_CRLS)) {
                    this.mode = Mode.PREFER_CRLS;
                }
                this.onlyEE = options.contains((Object)PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            this.softFail = options.contains((Object)PKIXRevocationChecker.Option.SOFT_FAIL);
            this.crlDP = this.legacy ? rp.crlDPEnabled : true;
            this.ocspStapled = this.getOCSPStapledResponses();
            this.ocspExtensions = this.getOCSPExtensions();
            this.anchor = anchor;
            this.params = params;
            this.certStores = new ArrayList<CertStore>(params.certStores());
            try {
                this.certStores.add(CertStore.getInstance("Collection", new CollectionCertStoreParameters(params.certificates())));
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                if (debug == null) break block9;
                debug.println("RevocationChecker: error creating Collection CertStore: " + e);
            }
        }
    }

    private static URI toURI(String uriString) throws CertPathValidatorException {
        try {
            if (uriString != null) {
                return new URI(uriString);
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new CertPathValidatorException("cannot parse ocsp.responderURL property", e);
        }
    }

    private static RevocationProperties getRevocationProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<RevocationProperties>(){

            @Override
            public RevocationProperties run() {
                RevocationProperties rp = new RevocationProperties();
                String onlyEE = Security.getProperty("com.sun.security.onlyCheckRevocationOfEECert");
                rp.onlyEE = onlyEE != null && onlyEE.equalsIgnoreCase("true");
                String ocspEnabled = Security.getProperty("ocsp.enable");
                rp.ocspEnabled = ocspEnabled != null && ocspEnabled.equalsIgnoreCase("true");
                rp.ocspUrl = Security.getProperty("ocsp.responderURL");
                rp.ocspSubject = Security.getProperty("ocsp.responderCertSubjectName");
                rp.ocspIssuer = Security.getProperty("ocsp.responderCertIssuerName");
                rp.ocspSerial = Security.getProperty("ocsp.responderCertSerialNumber");
                rp.crlDPEnabled = Boolean.getBoolean("com.sun.security.enableCRLDP");
                return rp;
            }
        });
    }

    private static X509Certificate getResponderCert(RevocationProperties rp, Set<TrustAnchor> anchors, List<CertStore> stores) throws CertPathValidatorException {
        if (rp.ocspSubject != null) {
            return RevocationChecker.getResponderCert(rp.ocspSubject, anchors, stores);
        }
        if (rp.ocspIssuer != null && rp.ocspSerial != null) {
            return RevocationChecker.getResponderCert(rp.ocspIssuer, rp.ocspSerial, anchors, stores);
        }
        if (rp.ocspIssuer != null || rp.ocspSerial != null) {
            throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
        }
        return null;
    }

    private static X509Certificate getResponderCert(String subject, Set<TrustAnchor> anchors, List<CertStore> stores) throws CertPathValidatorException {
        X509CertSelector sel = new X509CertSelector();
        try {
            sel.setSubject(new X500Principal(subject));
        }
        catch (IllegalArgumentException e) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertSubjectName property", e);
        }
        return RevocationChecker.getResponderCert(sel, anchors, stores);
    }

    private static X509Certificate getResponderCert(String issuer, String serial, Set<TrustAnchor> anchors, List<CertStore> stores) throws CertPathValidatorException {
        X509CertSelector sel = new X509CertSelector();
        try {
            sel.setIssuer(new X500Principal(issuer));
        }
        catch (IllegalArgumentException e) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertIssuerName property", e);
        }
        try {
            sel.setSerialNumber(new BigInteger(RevocationChecker.stripOutSeparators(serial), 16));
        }
        catch (NumberFormatException e) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertSerialNumber property", e);
        }
        return RevocationChecker.getResponderCert(sel, anchors, stores);
    }

    private static X509Certificate getResponderCert(X509CertSelector sel, Set<TrustAnchor> anchors, List<CertStore> stores) throws CertPathValidatorException {
        for (TrustAnchor anchor : anchors) {
            X509Certificate cert = anchor.getTrustedCert();
            if (cert == null || !sel.match(cert)) continue;
            return cert;
        }
        for (CertStore store : stores) {
            try {
                Collection<? extends Certificate> certs = store.getCertificates(sel);
                if (certs.isEmpty()) continue;
                return (X509Certificate)certs.iterator().next();
            }
            catch (CertStoreException e) {
                if (debug == null) continue;
                debug.println("CertStore exception:" + e);
            }
        }
        throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        if (this.anchor != null) {
            this.issuerInfo = new OCSPResponse.IssuerInfo(this.anchor);
            this.prevPubKey = this.issuerInfo.getPublicKey();
        }
        this.crlSignFlag = true;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509Certificate xcert = (X509Certificate)cert;
        if (this.onlyEE && xcert.getBasicConstraints() != -1) {
            if (debug != null) {
                debug.println("Skipping revocation check, not end entity cert");
            }
        } else {
            this.check(xcert, unresolvedCritExts, this.prevPubKey, this.crlSignFlag);
        }
        this.updateState(xcert);
    }

    void check(X509Certificate xcert, Collection<String> unresolvedCritExts, PublicKey pubKey, boolean crlSignFlag) throws CertPathValidatorException {
        try {
            switch (this.mode) {
                case PREFER_OCSP: {
                    this.checkOCSP(xcert, unresolvedCritExts);
                    break;
                }
                case PREFER_CRLS: 
                case ONLY_CRLS: {
                    this.checkCRLs(xcert, unresolvedCritExts, null, pubKey, crlSignFlag);
                }
            }
        }
        catch (CertPathValidatorException e) {
            if (e.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                throw e;
            }
            CertPathValidatorException cause = e;
            if (this.softFail && e instanceof OCSP.NetworkFailureException && this.mode == Mode.ONLY_CRLS) {
                return;
            }
            if (this.mode == Mode.ONLY_CRLS) {
                throw e;
            }
            if (debug != null) {
                debug.println("RevocationChecker.check() " + e.getMessage());
                debug.println("RevocationChecker.check() preparing to failover");
            }
            try {
                switch (this.mode) {
                    case PREFER_OCSP: {
                        this.checkCRLs(xcert, unresolvedCritExts, null, pubKey, crlSignFlag);
                        break;
                    }
                    case PREFER_CRLS: {
                        this.checkOCSP(xcert, unresolvedCritExts);
                    }
                }
            }
            catch (CertPathValidatorException x) {
                if (debug != null) {
                    debug.println("RevocationChecker.check() failover failed");
                    debug.println("RevocationChecker.check() " + x.getMessage());
                }
                if (x.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                    throw x;
                }
                if (cause != null) {
                    if (this.softFail && cause instanceof OCSP.NetworkFailureException) {
                        return;
                    }
                    cause.addSuppressed(x);
                    throw cause;
                }
                if (this.softFail && x instanceof OCSP.NetworkFailureException) {
                    return;
                }
                throw x;
            }
        }
    }

    private void updateState(X509Certificate cert) throws CertPathValidatorException {
        this.issuerInfo = new OCSPResponse.IssuerInfo(this.anchor, cert);
        PublicKey pubKey = cert.getPublicKey();
        if (PKIX.isDSAPublicKeyWithoutParams(pubKey)) {
            pubKey = BasicChecker.makeInheritedParamsKey(pubKey, this.prevPubKey);
        }
        this.prevPubKey = pubKey;
        this.crlSignFlag = RevocationChecker.certCanSignCrl(cert);
    }

    private void checkCRLs(X509Certificate cert, Collection<String> unresolvedCritExts, Set<X509Certificate> stackedCerts, PublicKey pubKey, boolean signFlag) throws CertPathValidatorException {
        this.checkCRLs(cert, pubKey, null, signFlag, true, stackedCerts, this.params.trustAnchors());
    }

    static boolean isCausedByNetworkIssue(String type, CertStoreException cse) {
        boolean result;
        Throwable t = cse.getCause();
        switch (type) {
            case "LDAP": {
                if (t != null) {
                    String cn = t.getClass().getName();
                    result = cn.equals("javax.naming.ServiceUnavailableException") || cn.equals("javax.naming.CommunicationException");
                    break;
                }
                result = false;
                break;
            }
            case "SSLServer": {
                result = t != null && t instanceof IOException;
                break;
            }
            case "URI": {
                result = t != null && t instanceof IOException;
                break;
            }
            default: {
                return false;
            }
        }
        return result;
    }

    private void checkCRLs(X509Certificate cert, PublicKey prevKey, X509Certificate prevCert, boolean signFlag, boolean allowSeparateKey, Set<X509Certificate> stackedCerts, Set<TrustAnchor> anchors) throws CertPathValidatorException {
        if (debug != null) {
            debug.println("RevocationChecker.checkCRLs() ---checking revocation status ...");
        }
        if (stackedCerts != null && stackedCerts.contains(cert)) {
            if (debug != null) {
                debug.println("RevocationChecker.checkCRLs() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        HashSet<X509CRL> possibleCRLs = new HashSet<X509CRL>();
        HashSet<X509CRL> approvedCRLs = new HashSet<X509CRL>();
        X509CRLSelector sel = new X509CRLSelector();
        sel.setCertificateChecking(cert);
        CertPathHelper.setDateAndTime(sel, this.params.date(), 900000L);
        OCSP.NetworkFailureException nfe = null;
        for (CertStore store : this.certStores) {
            try {
                for (CRL cRL : store.getCRLs(sel)) {
                    possibleCRLs.add((X509CRL)cRL);
                }
            }
            catch (CertStoreException e) {
                if (debug != null) {
                    debug.println("RevocationChecker.checkCRLs() CertStoreException: " + e.getMessage());
                }
                if (!this.softFail || nfe != null || !RevocationChecker.isCausedByNetworkIssue(store.getType(), e)) continue;
                nfe = new OCSP.NetworkFailureException(e);
            }
        }
        if (debug != null) {
            debug.println("RevocationChecker.checkCRLs() possible crls.size() = " + possibleCRLs.size());
        }
        boolean[] reasonsMask = new boolean[9];
        if (!possibleCRLs.isEmpty()) {
            approvedCRLs.addAll(this.verifyPossibleCRLs(possibleCRLs, cert, prevKey, signFlag, reasonsMask, anchors));
        }
        if (debug != null) {
            debug.println("RevocationChecker.checkCRLs() approved crls.size() = " + approvedCRLs.size());
        }
        if (!approvedCRLs.isEmpty() && Arrays.equals(reasonsMask, ALL_REASONS)) {
            this.checkApprovedCRLs(cert, approvedCRLs);
        } else {
            try {
                if (this.crlDP) {
                    approvedCRLs.addAll(DistributionPointFetcher.getCRLs(sel, signFlag, prevKey, prevCert, this.params.sigProvider(), this.certStores, reasonsMask, anchors, null, this.params.variant()));
                }
            }
            catch (CertStoreException e) {
                PKIX.CertStoreTypeException cste;
                if (this.softFail && e instanceof PKIX.CertStoreTypeException && RevocationChecker.isCausedByNetworkIssue((cste = (PKIX.CertStoreTypeException)e).getType(), e)) {
                    throw new OCSP.NetworkFailureException(e);
                }
                throw new CertPathValidatorException(e);
            }
            if (!approvedCRLs.isEmpty() && Arrays.equals(reasonsMask, ALL_REASONS)) {
                this.checkApprovedCRLs(cert, approvedCRLs);
            } else {
                if (allowSeparateKey) {
                    try {
                        this.verifyWithSeparateSigningKey(cert, prevKey, signFlag, stackedCerts);
                        return;
                    }
                    catch (CertPathValidatorException cpve) {
                        if (nfe != null) {
                            throw nfe;
                        }
                        throw cpve;
                    }
                }
                if (nfe != null) {
                    throw nfe;
                }
                throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
        }
    }

    private void checkApprovedCRLs(X509Certificate cert, Set<X509CRL> approvedCRLs) throws CertPathValidatorException {
        if (debug != null) {
            BigInteger sn = cert.getSerialNumber();
            debug.println("RevocationChecker.checkApprovedCRLs() starting the final sweep...");
            debug.println("RevocationChecker.checkApprovedCRLs() cert SN: " + sn.toString());
        }
        CRLReason reasonCode = CRLReason.UNSPECIFIED;
        X509CRLEntryImpl entry = null;
        for (X509CRL crl : approvedCRLs) {
            Set<String> unresCritExts;
            X509CRLEntry e = crl.getRevokedCertificate(cert);
            if (e == null) continue;
            try {
                entry = X509CRLEntryImpl.toImpl(e);
            }
            catch (CRLException ce) {
                throw new CertPathValidatorException(ce);
            }
            if (debug != null) {
                debug.println("RevocationChecker.checkApprovedCRLs() CRL entry: " + entry.toString());
            }
            if ((unresCritExts = entry.getCriticalExtensionOIDs()) != null && !unresCritExts.isEmpty()) {
                unresCritExts.remove(PKIXExtensions.ReasonCode_Id.toString());
                unresCritExts.remove(PKIXExtensions.CertificateIssuer_Id.toString());
                if (!unresCritExts.isEmpty()) {
                    if (debug != null) {
                        debug.println("Unrecognized critical extension(s) in revoked CRL entry: " + unresCritExts);
                    }
                    throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
                }
            }
            if ((reasonCode = entry.getRevocationReason()) == null) {
                reasonCode = CRLReason.UNSPECIFIED;
            }
            CertificateRevokedException t = new CertificateRevokedException(entry.getRevocationDate(), reasonCode, crl.getIssuerX500Principal(), entry.getExtensions());
            throw new CertPathValidatorException(((Throwable)t).getMessage(), t, null, -1, CertPathValidatorException.BasicReason.REVOKED);
        }
    }

    private void checkOCSP(X509Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509CertImpl currCert = null;
        try {
            currCert = X509CertImpl.toImpl(cert);
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException(ce);
        }
        URI responderURI = this.responderURI != null ? this.responderURI : RevocationChecker.getOCSPServerURI(currCert);
        OCSPResponse response = null;
        CertId certId = null;
        try {
            certId = new CertId(this.issuerInfo.getName(), this.issuerInfo.getPublicKey(), currCert.getSerialNumberObject());
            byte[] responseBytes = this.ocspStapled.get(cert);
            if (responseBytes != null) {
                if (debug != null) {
                    debug.println("Found stapled OCSP response");
                }
                response = new OCSPResponse(responseBytes);
                byte[] nonce = null;
                for (Extension ext : this.ocspExtensions) {
                    if (!ext.getId().equals("1.3.6.1.5.5.7.48.1.2")) continue;
                    nonce = ext.getValue();
                }
                response.verify(Collections.singletonList(certId), this.issuerInfo, this.responderCert, this.params.date(), nonce, this.params.variant());
            } else {
                response = OCSP.check(Collections.singletonList(certId), responderURI, this.issuerInfo, this.responderCert, null, this.ocspExtensions, this.params.variant());
            }
        }
        catch (IOException e) {
            throw new CertPathValidatorException(e);
        }
        OCSPResponse.SingleResponse rs = response.getSingleResponse(certId);
        OCSP.RevocationStatus.CertStatus certStatus = rs.getCertStatus();
        if (certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
            CertificateRevokedException t = new CertificateRevokedException(rs.getRevocationTime(), rs.getRevocationReason(), response.getSignerCertificate().getSubjectX500Principal(), rs.getSingleExtensions());
            throw new CertPathValidatorException(((Throwable)t).getMessage(), t, null, -1, CertPathValidatorException.BasicReason.REVOKED);
        }
        if (certStatus == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
            throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.params.certPath(), -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
    }

    private static String stripOutSeparators(String value) {
        char[] chars = value.toCharArray();
        StringBuilder hexNumber = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (HEX_DIGITS.indexOf(chars[i]) == -1) continue;
            hexNumber.append(chars[i]);
        }
        return hexNumber.toString();
    }

    private static URI getOCSPServerURI(X509CertImpl cert) throws CertPathValidatorException {
        AuthorityInfoAccessExtension aia = cert.getAuthorityInfoAccessExtension();
        if (aia == null) {
            throw new CertPathValidatorException("Must specify the location of an OCSP Responder");
        }
        List<AccessDescription> descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals((Object)AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            URIName uri = (URIName)generalName.getName();
            return uri.getURI();
        }
        throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
    }

    static boolean certCanSignCrl(X509Certificate cert) {
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage != null) {
            return keyUsage[6];
        }
        return false;
    }

    private Collection<X509CRL> verifyPossibleCRLs(Set<X509CRL> crls, X509Certificate cert, PublicKey prevKey, boolean signFlag, boolean[] reasonsMask, Set<TrustAnchor> anchors) throws CertPathValidatorException {
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            if (debug != null) {
                debug.println("RevocationChecker.verifyPossibleCRLs: Checking CRLDPs for " + certImpl.getSubjectX500Principal());
            }
            CRLDistributionPointsExtension ext = certImpl.getCRLDistributionPointsExtension();
            List<DistributionPoint> points = null;
            if (ext == null) {
                X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
                DistributionPoint point = new DistributionPoint(new GeneralNames().add(new GeneralName(certIssuer)), null, null);
                points = Collections.singletonList(point);
            } else {
                points = ext.get("points");
            }
            HashSet<X509CRL> results = new HashSet<X509CRL>();
            for (DistributionPoint point : points) {
                for (X509CRL crl : crls) {
                    if (!DistributionPointFetcher.verifyCRL(certImpl, point, crl, reasonsMask, signFlag, prevKey, null, this.params.sigProvider(), anchors, this.certStores, this.params.date(), this.params.variant())) continue;
                    results.add(crl);
                }
                if (!Arrays.equals(reasonsMask, ALL_REASONS)) continue;
                break;
            }
            return results;
        }
        catch (IOException | CRLException | CertificateException e) {
            if (debug != null) {
                debug.println("Exception while verifying CRL: " + e.getMessage());
                e.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    private void verifyWithSeparateSigningKey(X509Certificate cert, PublicKey prevKey, boolean signFlag, Set<X509Certificate> stackedCerts) throws CertPathValidatorException {
        String msg = "revocation status";
        if (debug != null) {
            debug.println("RevocationChecker.verifyWithSeparateSigningKey() ---checking " + msg + "...");
        }
        if (stackedCerts != null && stackedCerts.contains(cert)) {
            if (debug != null) {
                debug.println("RevocationChecker.verifyWithSeparateSigningKey() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        if (!signFlag) {
            this.buildToNewKey(cert, null, stackedCerts);
        } else {
            this.buildToNewKey(cert, prevKey, stackedCerts);
        }
    }

    private void buildToNewKey(X509Certificate currCert, PublicKey prevKey, Set<X509Certificate> stackedCerts) throws CertPathValidatorException {
        PKIXBuilderParameters builderParams;
        if (debug != null) {
            debug.println("RevocationChecker.buildToNewKey() starting work");
        }
        HashSet<PublicKey> badKeys = new HashSet<PublicKey>();
        if (prevKey != null) {
            badKeys.add(prevKey);
        }
        RejectKeySelector certSel = new RejectKeySelector(badKeys);
        certSel.setSubject(currCert.getIssuerX500Principal());
        certSel.setKeyUsage(CRL_SIGN_USAGE);
        Set<TrustAnchor> newAnchors = this.anchor == null ? this.params.trustAnchors() : Collections.singleton(this.anchor);
        try {
            builderParams = new PKIXBuilderParameters(newAnchors, (CertSelector)certSel);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException(iape);
        }
        builderParams.setInitialPolicies(this.params.initialPolicies());
        builderParams.setCertStores(this.certStores);
        builderParams.setExplicitPolicyRequired(this.params.explicitPolicyRequired());
        builderParams.setPolicyMappingInhibited(this.params.policyMappingInhibited());
        builderParams.setAnyPolicyInhibited(this.params.anyPolicyInhibited());
        builderParams.setDate(this.params.date());
        builderParams.setCertPathCheckers(this.params.getPKIXParameters().getCertPathCheckers());
        builderParams.setSigProvider(this.params.sigProvider());
        builderParams.setRevocationEnabled(false);
        if (Builder.USE_AIA) {
            List<AccessDescription> adList;
            X509CertImpl currCertImpl;
            block29: {
                currCertImpl = null;
                try {
                    currCertImpl = X509CertImpl.toImpl(currCert);
                }
                catch (CertificateException ce) {
                    if (debug == null) break block29;
                    debug.println("RevocationChecker.buildToNewKey: error decoding cert: " + ce);
                }
            }
            AuthorityInfoAccessExtension aiaExt = null;
            if (currCertImpl != null) {
                aiaExt = currCertImpl.getAuthorityInfoAccessExtension();
            }
            if (aiaExt != null && (adList = aiaExt.getAccessDescriptions()) != null) {
                for (AccessDescription ad : adList) {
                    CertStore cs = URICertStore.getInstance(ad);
                    if (cs == null) continue;
                    if (debug != null) {
                        debug.println("adding AIAext CertStore");
                    }
                    builderParams.addCertStore(cs);
                }
            }
        }
        CertPathBuilder builder = null;
        try {
            builder = CertPathBuilder.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CertPathValidatorException(nsae);
        }
        try {
            while (true) {
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() about to try build ...");
                }
                PKIXCertPathBuilderResult cpbr = (PKIXCertPathBuilderResult)builder.build(builderParams);
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() about to check revocation ...");
                }
                if (stackedCerts == null) {
                    stackedCerts = new HashSet<X509Certificate>();
                }
                stackedCerts.add(currCert);
                TrustAnchor ta = cpbr.getTrustAnchor();
                PublicKey prevKey2 = ta.getCAPublicKey();
                if (prevKey2 == null) {
                    prevKey2 = ta.getTrustedCert().getPublicKey();
                }
                boolean signFlag = true;
                List<? extends Certificate> cpList = cpbr.getCertPath().getCertificates();
                try {
                    for (int i = cpList.size() - 1; i >= 0; --i) {
                        X509Certificate cert = (X509Certificate)cpList.get(i);
                        if (debug != null) {
                            debug.println("RevocationChecker.buildToNewKey() index " + i + " checking " + cert);
                        }
                        this.checkCRLs(cert, prevKey2, null, signFlag, true, stackedCerts, newAnchors);
                        signFlag = RevocationChecker.certCanSignCrl(cert);
                        prevKey2 = cert.getPublicKey();
                    }
                }
                catch (CertPathValidatorException cpve) {
                    badKeys.add(cpbr.getPublicKey());
                    continue;
                }
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() got key " + cpbr.getPublicKey());
                }
                PublicKey newKey = cpbr.getPublicKey();
                try {
                    this.checkCRLs(currCert, newKey, (X509Certificate)cpList.get(0), true, false, null, this.params.trustAnchors());
                    return;
                }
                catch (CertPathValidatorException cpve) {
                    if (cpve.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                        throw cpve;
                    }
                    badKeys.add(newKey);
                    continue;
                }
                break;
            }
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new CertPathValidatorException(iape);
        }
        catch (CertPathBuilderException cpbe) {
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
    }

    private static class RejectKeySelector
    extends X509CertSelector {
        private final Set<PublicKey> badKeySet;

        RejectKeySelector(Set<PublicKey> badPublicKeys) {
            this.badKeySet = badPublicKeys;
        }

        @Override
        public boolean match(Certificate cert) {
            if (!super.match(cert)) {
                return false;
            }
            if (this.badKeySet.contains(cert.getPublicKey())) {
                if (debug != null) {
                    debug.println("RejectKeySelector.match: bad key");
                }
                return false;
            }
            if (debug != null) {
                debug.println("RejectKeySelector.match: returning true");
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RejectKeySelector: [\n");
            sb.append(super.toString());
            sb.append(this.badKeySet);
            sb.append("]");
            return sb.toString();
        }
    }

    private static class RevocationProperties {
        boolean onlyEE;
        boolean ocspEnabled;
        boolean crlDPEnabled;
        String ocspUrl;
        String ocspSubject;
        String ocspIssuer;
        String ocspSerial;

        private RevocationProperties() {
        }
    }

    private static enum Mode {
        PREFER_OCSP,
        PREFER_CRLS,
        ONLY_CRLS;

    }
}

