/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Mi\u00f0afrika t\u00ed\u00f0",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskva vanlig t\u00ed\u00f0",
               "MSK",
               "Moskva summart\u00ed\u00f0",
               "MSD",
               "Moskva t\u00ed\u00f0",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japan vanlig t\u00ed\u00f0",
               "JST",
               "Japan summart\u00ed\u00f0",
               "JDT",
               "Japan t\u00ed\u00f0",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistan vanlig t\u00ed\u00f0",
               "PKT",
               "Pakistan summart\u00ed\u00f0",
               "PKST",
               "Pakistan t\u00ed\u00f0",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipei vanlig t\u00ed\u00f0",
               "CST",
               "Taipei summart\u00ed\u00f0",
               "CDT",
               "Taipei t\u00ed\u00f0",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovd vanlig t\u00ed\u00f0",
               "HOVT",
               "Hovd summart\u00ed\u00f0",
               "HOVST",
               "Hovd t\u00ed\u00f0",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadan vanlig t\u00ed\u00f0",
               "MAGT",
               "Magadan summart\u00ed\u00f0",
               "MAGST",
               "Magadan t\u00ed\u00f0",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "mi\u00f0vestur Avstralia vanlig t\u00ed\u00f0",
               "ACWST",
               "mi\u00f0vestur Avstralia summart\u00ed\u00f0",
               "ACWDT",
               "mi\u00f0vestur Avstralia t\u00ed\u00f0",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Mi\u00f0evropa vanlig t\u00ed\u00f0",
               "CET",
               "Mi\u00f0evropa summart\u00ed\u00f0",
               "CEST",
               "Mi\u00f0evropa t\u00ed\u00f0",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin vanlig t\u00ed\u00f0",
               "SAKT",
               "Sakhalin summart\u00ed\u00f0",
               "SAKST",
               "Sakhalin t\u00ed\u00f0",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguai vanlig t\u00ed\u00f0",
               "PYT",
               "Paraguai summart\u00ed\u00f0",
               "PYST",
               "Paraguai t\u00ed\u00f0",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Malaisia t\u00ed\u00f0",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern vanlig t\u00ed\u00f0",
               "EST",
               "Eastern summart\u00ed\u00f0",
               "EDT",
               "Eastern t\u00ed\u00f0",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe vanlig t\u00ed\u00f0",
               "LHST",
               "Lord Howe summart\u00ed\u00f0",
               "LHDT",
               "Lord Howe t\u00ed\u00f0",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "N\u00fds\u00e6land vanlig t\u00ed\u00f0",
               "NZST",
               "N\u00fds\u00e6land summart\u00ed\u00f0",
               "NZDT",
               "N\u00fds\u00e6land t\u00ed\u00f0",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiahav t\u00ed\u00f0",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk vanlig t\u00ed\u00f0",
               "YAKT",
               "Yakutsk summart\u00ed\u00f0",
               "YAKST",
               "Yakutsk t\u00ed\u00f0",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "M\u00f3ritius vanlig t\u00ed\u00f0",
               "MUT",
               "M\u00f3ritius summart\u00ed\u00f0",
               "MUST",
               "M\u00f3ritius t\u00ed\u00f0",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Eysturafrika t\u00ed\u00f0",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Eysturtimor t\u00ed\u00f0",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Salomonoyggjar t\u00ed\u00f0",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae t\u00ed\u00f0",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalloyggjar t\u00ed\u00f0",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Eysturevropa vanlig t\u00ed\u00f0",
               "EET",
               "Eysturevropa summart\u00ed\u00f0",
               "EEST",
               "Eysturevropa t\u00ed\u00f0",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland vanlig t\u00ed\u00f0",
               "NST",
               "Newfoundland summart\u00ed\u00f0",
               "NDT",
               "Newfoundland t\u00ed\u00f0",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan t\u00ed\u00f0",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong vanlig t\u00ed\u00f0",
               "HKT",
               "Hong Kong summart\u00ed\u00f0",
               "HKST",
               "Hong Kong t\u00ed\u00f0",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Vestur Argentina vanlig t\u00ed\u00f0",
               "ART",
               "Vestur Argentina summart\u00ed\u00f0",
               "ARST",
               "Vestur Argentina t\u00ed\u00f0",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantic vanlig t\u00ed\u00f0",
               "AST",
               "Atlantic summart\u00ed\u00f0",
               "ADT",
               "Atlantic t\u00ed\u00f0",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape t\u00ed\u00f0",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bolivia t\u00ed\u00f0",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon vanlig t\u00ed\u00f0",
               "PMST",
               "St. Pierre & Miquelon summart\u00ed\u00f0",
               "PMDT",
               "St. Pierre & Miquelon t\u00ed\u00f0",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indokina t\u00ed\u00f0",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg vanlig t\u00ed\u00f0",
               "YEKT",
               "Yekaterinburg summart\u00ed\u00f0",
               "YEKST",
               "Yekaterinburg t\u00ed\u00f0",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maldivoyggjar t\u00ed\u00f0",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti t\u00ed\u00f0",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u00cdsrael vanlig t\u00ed\u00f0",
               "IST",
               "\u00cdsrael summart\u00ed\u00f0",
               "IDT",
               "\u00cdsrael t\u00ed\u00f0",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Mi\u00f0 Indonesia t\u00ed\u00f0",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Wallis- og Futunaoyggjar t\u00ed\u00f0",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Su\u00f0urafrika vanlig t\u00ed\u00f0",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa t\u00ed\u00f0",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Lineoyggjar t\u00ed\u00f0",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan vanlig t\u00ed\u00f0",
               "UZT",
               "Usbekistan summart\u00ed\u00f0",
               "UZST",
               "Usbekistan t\u00ed\u00f0",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk vanlig t\u00ed\u00f0",
               "OMST",
               "Omsk summart\u00ed\u00f0",
               "OMSST",
               "Omsk t\u00ed\u00f0",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seyskelloyggjar t\u00ed\u00f0",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguai vanlig t\u00ed\u00f0",
               "UYT",
               "Uruguai summart\u00ed\u00f0",
               "UYST",
               "Uruguai t\u00ed\u00f0",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepal t\u00ed\u00f0",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator vanlig t\u00ed\u00f0",
               "ULAT",
               "Ulan Bator summart\u00ed\u00f0",
               "ULAST",
               "Ulan Bator t\u00ed\u00f0",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Central vanlig t\u00ed\u00f0",
               "CST",
               "Central summart\u00ed\u00f0",
               "CDT",
               "Central t\u00ed\u00f0",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuk t\u00ed\u00f0",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue t\u00ed\u00f0",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Wakeoyggj t\u00ed\u00f0",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falklandsoyggjar vanlig t\u00ed\u00f0",
               "FKT",
               "Falklandsoyggjar summart\u00ed\u00f0",
               "FKST",
               "Falklandsoyggjar t\u00ed\u00f0",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu vanlig t\u00ed\u00f0",
               "VUT",
               "Vanuatu summart\u00ed\u00f0",
               "VUST",
               "Vanuatu t\u00ed\u00f0",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk vanlig t\u00ed\u00f0",
               "NOVT",
               "Novosibirsk summart\u00ed\u00f0",
               "NOVST",
               "Novosibirsk t\u00ed\u00f0",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapor t\u00ed\u00f0",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azorurnar vanlig t\u00ed\u00f0",
               "AZOT",
               "Azorurnar summart\u00ed\u00f0",
               "AZOST",
               "Azorurnar t\u00ed\u00f0",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apia vanlig t\u00ed\u00f0",
               "WSST",
               "Apia summart\u00ed\u00f0",
               "WSDT",
               "Apia t\u00ed\u00f0",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Butan t\u00ed\u00f0",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinam t\u00ed\u00f0",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru t\u00ed\u00f0",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk vanlig t\u00ed\u00f0",
               "KRAT",
               "Krasnoyarsk summart\u00ed\u00f0",
               "KRAST",
               "Krasnoyarsk t\u00ed\u00f0",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Vestur Kasakstan t\u00ed\u00f0",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanmar (Burma) t\u00ed\u00f0",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "J\u00f3laoyggj t\u00ed\u00f0",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amasona vanlig t\u00ed\u00f0",
               "AMT",
               "Amasona summart\u00ed\u00f0",
               "AMST",
               "Amasona t\u00ed\u00f0",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Eystur Kasakstan t\u00ed\u00f0",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fiji vanlig t\u00ed\u00f0",
               "FJT",
               "Fiji summart\u00ed\u00f0",
               "FJST",
               "Fiji t\u00ed\u00f0",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union t\u00ed\u00f0",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Kokosoyggjar t\u00ed\u00f0",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chatham vanlig t\u00ed\u00f0",
               "CHAST",
               "Chatham summart\u00ed\u00f0",
               "CHADT",
               "Chatham t\u00ed\u00f0",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostok t\u00ed\u00f0",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentina vanlig t\u00ed\u00f0",
               "ART",
               "Argentina summart\u00ed\u00f0",
               "ARST",
               "Argentina t\u00ed\u00f0",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambier t\u00ed\u00f0",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu t\u00ed\u00f0",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos t\u00ed\u00f0",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Macquariesoyggj t\u00ed\u00f0",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venesuela t\u00ed\u00f0",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian vanlig t\u00ed\u00f0",
               "HAST",
               "Hawaii-Aleutian summart\u00ed\u00f0",
               "HADT",
               "Hawaii-Aleutian t\u00ed\u00f0",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "mi\u00f0 Avstralia vanlig t\u00ed\u00f0",
               "ACST",
               "mi\u00f0 Avstralia summart\u00ed\u00f0",
               "ACDT",
               "mi\u00f0 Avstralia t\u00ed\u00f0",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Pacific vanlig t\u00ed\u00f0",
               "PST",
               "Pacific summart\u00ed\u00f0",
               "PDT",
               "Pacific t\u00ed\u00f0",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixoyggjar t\u00ed\u00f0",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan vanlig t\u00ed\u00f0",
               "TMT",
               "Turkmenistan summart\u00ed\u00f0",
               "TMST",
               "Turkmenistan t\u00ed\u00f0",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Vesturevropa vanlig t\u00ed\u00f0",
               "WET",
               "Vesturevropa summart\u00ed\u00f0",
               "WEST",
               "Vesturevropa t\u00ed\u00f0",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Gr\u00f8nh\u00f8vdaoyggjar vanlig t\u00ed\u00f0",
               "CVT",
               "Gr\u00f8nh\u00f8vdaoyggjar summart\u00ed\u00f0",
               "CVST",
               "Gr\u00f8nh\u00f8vdaoyggjar t\u00ed\u00f0",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolksoyggj t\u00ed\u00f0",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Gujana t\u00ed\u00f0",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnoyggjar t\u00ed\u00f0",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera t\u00ed\u00f0",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa vanlig t\u00ed\u00f0",
               "SST",
               "Samoa summart\u00ed\u00f0",
               "SDT",
               "Samoa t\u00ed\u00f0",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau t\u00ed\u00f0",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "longri Eysturevropa t\u00ed\u00f0",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbadjan vanlig t\u00ed\u00f0",
               "AZT",
               "Aserbadjan summart\u00ed\u00f0",
               "AZST",
               "Aserbadjan t\u00ed\u00f0",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawson t\u00ed\u00f0",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexican Pacific vanlig t\u00ed\u00f0",
               "MST",
               "Mexican Pacific summart\u00ed\u00f0",
               "MDT",
               "Mexican Pacific t\u00ed\u00f0",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis t\u00ed\u00f0",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Cuba vanlig t\u00ed\u00f0",
               "CST",
               "Cuba summart\u00ed\u00f0",
               "CDT",
               "Cuba t\u00ed\u00f0",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Vesturafrika vanlig t\u00ed\u00f0",
               "CAT",
               "Vesturafrika summart\u00ed\u00f0",
               "CAST",
               "Vesturafrika t\u00ed\u00f0",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwich Mean t\u00ed\u00f0",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filipsoyggjar vanlig t\u00ed\u00f0",
               "PHT",
               "Filipsoyggjar summart\u00ed\u00f0",
               "PHST",
               "Filipsoyggjar t\u00ed\u00f0",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Fronsku sunnaru landa\u00f8ki og Antarktis t\u00ed\u00f0",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Su\u00f0urgeorgiaoyggjar t\u00ed\u00f0",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "N\u00fdkaled\u00f3nia vanlig t\u00ed\u00f0",
               "NCT",
               "N\u00fdkaled\u00f3nia summart\u00ed\u00f0",
               "NCST",
               "N\u00fdkaled\u00f3nia t\u00ed\u00f0",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam t\u00ed\u00f0",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Iran vanlig t\u00ed\u00f0",
               "IRST",
               "Iran summart\u00ed\u00f0",
               "IRDT",
               "Iran t\u00ed\u00f0",
               "IRT",
            };
        final String[] Easter = new String[] {
               "P\u00e1skaoyggin vanlig t\u00ed\u00f0",
               "EAST",
               "P\u00e1skaoyggin summart\u00ed\u00f0",
               "EASST",
               "P\u00e1skaoyggin t\u00ed\u00f0",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Northwest Mexico vanlig t\u00ed\u00f0",
               "PST",
               "Northwest Mexico summart\u00ed\u00f0",
               "PDT",
               "Northwest Mexico t\u00ed\u00f0",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville t\u00ed\u00f0",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tadsjikistan t\u00ed\u00f0",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonga vanlig t\u00ed\u00f0",
               "TOT",
               "Tonga summart\u00ed\u00f0",
               "TOST",
               "Tonga t\u00ed\u00f0",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesj vanlig t\u00ed\u00f0",
               "BDT",
               "Bangladesj summart\u00ed\u00f0",
               "BDST",
               "Bangladesj t\u00ed\u00f0",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru vanlig t\u00ed\u00f0",
               "PET",
               "Peru summart\u00ed\u00f0",
               "PEST",
               "Peru t\u00ed\u00f0",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Vestur gr\u00f8nlendsk vanlig t\u00ed\u00f0",
               "WGT",
               "Vestur gr\u00f8nlendsk summart\u00ed\u00f0",
               "WGST",
               "Vestur gr\u00f8nlendsk t\u00ed\u00f0",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvador t\u00ed\u00f0",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Eystur gr\u00f8nlendsk vanlig t\u00ed\u00f0",
               "EGT",
               "Eystur gr\u00f8nlendsk summart\u00ed\u00f0",
               "EGST",
               "Eystur gr\u00f8nlendsk t\u00ed\u00f0",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Gulf vanlig t\u00ed\u00f0",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eystur Indonesia t\u00ed\u00f0",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Korea vanlig t\u00ed\u00f0",
               "KST",
               "Korea summart\u00ed\u00f0",
               "KDT",
               "Korea t\u00ed\u00f0",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "vestur Avstralia vanlig t\u00ed\u00f0",
               "AWST",
               "vestur Avstralia summart\u00ed\u00f0",
               "AWDT",
               "vestur Avstralia t\u00ed\u00f0",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisia t\u00ed\u00f0",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vestur Indonesia t\u00ed\u00f0",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "eystur Avstralia vanlig t\u00ed\u00f0",
               "AEST",
               "eystur Avstralia summart\u00ed\u00f0",
               "AEDT",
               "eystur Avstralia t\u00ed\u00f0",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Franska Gujana t\u00ed\u00f0",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolombia vanlig t\u00ed\u00f0",
               "COT",
               "Kolombia summart\u00ed\u00f0",
               "COST",
               "Kolombia t\u00ed\u00f0",
               "COT",
            };
        final String[] Chile = new String[] {
               "Kili vanlig t\u00ed\u00f0",
               "CLT",
               "Kili summart\u00ed\u00f0",
               "CLST",
               "Kili t\u00ed\u00f0",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertoyggjar t\u00ed\u00f0",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Mountain vanlig t\u00ed\u00f0",
               "MST",
               "Mountain summart\u00ed\u00f0",
               "MDT",
               "Mountain t\u00ed\u00f0",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas t\u00ed\u00f0",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabisk vanlig t\u00ed\u00f0",
               "AST",
               "Arabisk summart\u00ed\u00f0",
               "ADT",
               "Arabisk t\u00ed\u00f0",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska vanlig t\u00ed\u00f0",
               "AKST",
               "Alaska summart\u00ed\u00f0",
               "AKDT",
               "Alaska t\u00ed\u00f0",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok vanlig t\u00ed\u00f0",
               "VLAT",
               "Vladivostok summart\u00ed\u00f0",
               "VLAST",
               "Vladivostok t\u00ed\u00f0",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro vanlig t\u00ed\u00f0",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk vanlig t\u00ed\u00f0",
               "IRKT",
               "Irkutsk summart\u00ed\u00f0",
               "IRKST",
               "Irkutsk t\u00ed\u00f0",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Georgia vanlig t\u00ed\u00f0",
               "GET",
               "Georgia summart\u00ed\u00f0",
               "GEST",
               "Georgia t\u00ed\u00f0",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau t\u00ed\u00f0",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua N\u00fdguinea t\u00ed\u00f0",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha vanlig t\u00ed\u00f0",
               "FNT",
               "Fernando de Noronha summart\u00ed\u00f0",
               "FNST",
               "Fernando de Noronha t\u00ed\u00f0",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan vanlig t\u00ed\u00f0",
               "CHOT",
               "Choibalsan summart\u00ed\u00f0",
               "CHOST",
               "Choibalsan t\u00ed\u00f0",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Brasilia vanlig t\u00ed\u00f0",
               "BRT",
               "Brasilia summart\u00ed\u00f0",
               "BRST",
               "Brasilia t\u00ed\u00f0",
               "BRT",
            };
        final String[] China = new String[] {
               "Kina vanlig t\u00ed\u00f0",
               "CST",
               "Kina summart\u00ed\u00f0",
               "CDT",
               "Kina t\u00ed\u00f0",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armenia vanlig t\u00ed\u00f0",
               "AMT",
               "Armenia summart\u00ed\u00f0",
               "AMST",
               "Armenia t\u00ed\u00f0",
               "AMT",
            };
        final String[] India = new String[] {
               "India t\u00ed\u00f0",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cooksoyggjar vanlig t\u00ed\u00f0",
               "CKT",
               "Cooksoyggjar summart\u00ed\u00f0",
               "CKHST",
               "Cooksoyggjar t\u00ed\u00f0",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "St\u00f3ra Bretland summart\u00ed\u00f0",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "\u00cdrsk vanlig t\u00ed\u00f0",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
