/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_vi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Gi\u1edd Trung Phi",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Gi\u1edd Chu\u1ea9n Matxc\u01a1va",
               "MSK",
               "Gi\u1edd M\u00f9a H\u00e8 Matxc\u01a1va",
               "MSD",
               "Gi\u1edd Matxc\u01a1va",
               "MT",
            };
        final String[] Japan = new String[] {
               "Gi\u1edd Chu\u1ea9n Nh\u1eadt B\u1ea3n",
               "JST",
               "Gi\u1edd M\u00f9a H\u00e8 Nh\u1eadt B\u1ea3n",
               "JDT",
               "Gi\u1edd Nh\u1eadt B\u1ea3n",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Gi\u1edd Chu\u1ea9n Pakistan",
               "PKT",
               "Gi\u1edd M\u00f9a H\u00e8 Pakistan",
               "PKST",
               "Gi\u1edd Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u00e0i B\u1eafc",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 \u0110\u00e0i B\u1eafc",
               "CDT",
               "Gi\u1edd \u0110\u00e0i B\u1eafc",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Gi\u1edd Chu\u1ea9n Hovd",
               "HOVT",
               "Gi\u1edd M\u00f9a H\u00e8 Hovd",
               "HOVST",
               "Gi\u1edd Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Gi\u1edd Chu\u1ea9n Magadan",
               "MAGT",
               "Gi\u1edd m\u00f9a h\u00e8 Magadan",
               "MAGST",
               "Gi\u1edd Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n Trung T\u00e2y N\u01b0\u1edbc \u00dac",
               "ACWST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n Trung T\u00e2y N\u01b0\u1edbc \u00dac",
               "ACWDT",
               "Gi\u1edd Mi\u1ec1n Trung T\u00e2y N\u01b0\u1edbc \u00dac",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Gi\u1edd Chu\u1ea9n Trung \u00c2u",
               "CET",
               "Gi\u1edd M\u00f9a H\u00e8 Trung \u00c2u",
               "CEST",
               "Gi\u1edd Trung \u00c2u",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Gi\u1edd Chu\u1ea9n Sakhalin",
               "SAKT",
               "Gi\u1edd m\u00f9a h\u00e8 Sakhalin",
               "SAKST",
               "Gi\u1edd Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Gi\u1edd Chu\u1ea9n Paraguay",
               "PYT",
               "Gi\u1edd M\u00f9a H\u00e8 Paraguay",
               "PYST",
               "Gi\u1edd Paraguay",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Gi\u1edd Chu\u1ea9n Acre",
               "ACT",
               "Gi\u1edd M\u00f9a H\u00e8 Acre",
               "ACST",
               "Gi\u1edd Acre",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Gi\u1edd Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n \u0111\u00f4ng",
               "EST",
               "Gi\u1edd ban ng\u00e0y mi\u1ec1n \u0111\u00f4ng",
               "EDT",
               "Gi\u1edd mi\u1ec1n \u0111\u00f4ng",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Gi\u1edd Chu\u1ea9n Lord Howe",
               "LHST",
               "Gi\u1edd M\u00f9a H\u00e8 Lord Howe",
               "LHDT",
               "Gi\u1edd Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Gi\u1edd Chu\u1ea9n New Zealand",
               "NZST",
               "Gi\u1edd M\u00f9a H\u00e8 New Zealand",
               "NZDT",
               "Gi\u1edd New Zealand",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Gi\u1edd \u1ea4n \u0110\u1ed9 D\u01b0\u01a1ng",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Yakutsk",
               "YAKT",
               "Gi\u1edd m\u00f9a h\u00e8 Yakutsk",
               "YAKST",
               "Gi\u1edd Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Gi\u1edd Chu\u1ea9n Mauritius",
               "MUT",
               "Gi\u1edd M\u00f9a H\u00e8 Mauritius",
               "MUST",
               "Gi\u1edd Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Gi\u1edd \u0110\u00f4ng Phi",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Gi\u1edd \u0110\u00f4ng Timor",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Solomon",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Gi\u1edd Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u00f4ng \u00c2u",
               "EET",
               "Gi\u1edd M\u00f9a H\u00e8 \u0110\u00f4ng \u00c2u",
               "EEST",
               "Gi\u1edd \u0110\u00f4ng \u00c2u",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Gi\u1edd Chu\u1ea9n Newfoundland",
               "NST",
               "Gi\u1edd M\u00f9a H\u00e8 Newfoundland",
               "NDT",
               "Gi\u1edd Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Gi\u1edd Afghanistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Gi\u1edd Chu\u1ea9n H\u1ed3ng K\u00f4ng",
               "HKT",
               "Gi\u1edd M\u00f9a H\u00e8 H\u1ed3ng K\u00f4ng",
               "HKST",
               "Gi\u1edd H\u1ed3ng K\u00f4ng",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n m\u00e2y Argentina",
               "ART",
               "Gi\u1edd m\u00f9a h\u00e8 mi\u1ec1n t\u00e2y Argentina",
               "ARST",
               "Gi\u1edd mi\u1ec1n t\u00e2y Argentina",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "AST",
               "Gi\u1edd M\u00f9a h\u00e8 \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "ADT",
               "Gi\u1edd \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Gi\u1edd Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Gi\u1edd Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Gi\u1edd Chu\u1ea9n St. Pierre v\u00e0 Miquelon",
               "PMST",
               "Gi\u1edd M\u00f9a H\u00e8 Saint Pierre v\u00e0 Miquelon",
               "PMDT",
               "Gi\u1edd St. Pierre v\u00e0 Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Gi\u1edd \u0110\u00f4ng D\u01b0\u01a1ng",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Gi\u1edd Chu\u1ea9n Yekaterinburg",
               "YEKT",
               "Gi\u1edd m\u00f9a h\u00e8 Yekaterinburg",
               "YEKST",
               "Gi\u1edd Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Gi\u1edd Maldives",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Gi\u1edd Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Gi\u1edd Chu\u1ea9n Israel",
               "IST",
               "Gi\u1edd M\u00f9a H\u00e8 Israel",
               "IDT",
               "Gi\u1edd Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Gi\u1edd Mi\u1ec1n Trung Indonesia",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Gi\u1edd Wallis v\u00e0 Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Gi\u1edd Chu\u1ea9n Nam Phi",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Gi\u1edd Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Line",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Gi\u1edd Chu\u1ea9n Uzbekistan",
               "UZT",
               "Gi\u1edd M\u00f9a H\u00e8 Uzbekistan",
               "UZST",
               "Gi\u1edd Uzbekistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Gi\u1edd chu\u1ea9n Omsk",
               "OMST",
               "Gi\u1edd m\u00f9a h\u00e8 Omsk",
               "OMSST",
               "Gi\u1edd Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Gi\u1edd Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Gi\u1edd Chu\u1ea9n Uruguay",
               "UYT",
               "Gi\u1edd M\u00f9a H\u00e8 Uruguay",
               "UYST",
               "Gi\u1edd Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Gi\u1edd Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Gi\u1edd chu\u1ea9n Ulan Bator",
               "ULAT",
               "Gi\u1edd m\u00f9a h\u00e8 Ulan Bator",
               "ULAST",
               "Gi\u1edd Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n trung",
               "CST",
               "Gi\u1edd ban ng\u00e0y mi\u1ec1n trung",
               "CDT",
               "Gi\u1edd mi\u1ec1n trung",
               "CT",
            };
        final String[] Truk = new String[] {
               "Gi\u1edd Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Gi\u1edd Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Gi\u1edd \u0110\u1ea3o Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Gi\u1edd Chu\u1ea9n Qu\u1ea7n \u0110\u1ea3o Falkland",
               "FKT",
               "Gi\u1edd M\u00f9a H\u00e8 Qu\u1ea7n \u0110\u1ea3o Falkland",
               "FKST",
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Gi\u1edd Chu\u1ea9n Vanuatu",
               "VUT",
               "Gi\u1edd M\u00f9a H\u00e8 Vanuatu",
               "VUST",
               "Gi\u1edd Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Gi\u1edd chu\u1ea9n Novosibirsk",
               "NOVT",
               "Gi\u1edd m\u00f9a h\u00e8 Novosibirsk",
               "NOVST",
               "Gi\u1edd Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Gi\u1edd Singapore",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Gi\u1edd Chu\u1ea9n Azores",
               "AZOT",
               "Gi\u1edd M\u00f9a H\u00e8 Azores",
               "AZOST",
               "Gi\u1edd Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Gi\u1edd Chu\u1ea9n Apia",
               "WSST",
               "Gi\u1edd Ban ng\u00e0y Apia",
               "WSDT",
               "Gi\u1edd Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Gi\u1edd Bhutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Gi\u1edd Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Gi\u1edd Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Krasnoyarsk",
               "KRAT",
               "Gi\u1edd M\u00f9a H\u00e8 Krasnoyarsk",
               "KRAST",
               "Gi\u1edd Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Gi\u1edd Mi\u1ec1n T\u00e2y Kazakhstan",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Gi\u1edd Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Gi\u1edd \u0110\u1ea3o Christmas",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Gi\u1edd Chu\u1ea9n Amazon",
               "AMT",
               "Gi\u1edd M\u00f9a H\u00e8 Amazon",
               "AMST",
               "Gi\u1edd Amazon",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Kazakhstan",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Gi\u1edd Chu\u1ea9n Fiji",
               "FJT",
               "Gi\u1edd M\u00f9a H\u00e8 Fiji",
               "FJST",
               "Gi\u1edd Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Gi\u1edd Reunion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Gi\u1edd Chu\u1ea9n Chatham",
               "CHAST",
               "Gi\u1edd M\u00f9a H\u00e8 Chatham",
               "CHADT",
               "Gi\u1edd Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Gi\u1edd Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Gi\u1edd Chu\u1ea9n Argentina",
               "ART",
               "Gi\u1edd M\u00f9a H\u00e8 Argentina",
               "ARST",
               "Gi\u1edd Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gi\u1edd Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Gi\u1edd chu\u1ea9n Petropavlovsk-Kamchatski",
               "PETT",
               "Gi\u1edd m\u00f9a h\u00e8 Petropavlovsk-Kamchatski",
               "PETST",
               "Gi\u1edd Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Gi\u1edd Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Gi\u1edd Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Gi\u1edd \u0111\u1ea3o Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Gi\u1edd Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Gi\u1edd Chu\u1ea9n Hawaii-Aleutian",
               "HAST",
               "Gi\u1edd M\u00f9a H\u00e8 Hawaii-Aleutian",
               "HADT",
               "Gi\u1edd Hawaii-Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n Trung N\u01b0\u1edbc \u00dac",
               "ACST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n Trung N\u01b0\u1edbc \u00dac",
               "ACDT",
               "Gi\u1edd Mi\u1ec1n Trung N\u01b0\u1edbc \u00dac",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Gi\u1edd chu\u1ea9n Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PST",
               "Gi\u1edd ban ng\u00e0y Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PDT",
               "Gi\u1edd Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Gi\u1edd Chu\u1ea9n Turkmenistan",
               "TMT",
               "Gi\u1edd M\u00f9a H\u00e8 Turkmenistan",
               "TMST",
               "Gi\u1edd Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n T\u00e2y \u00c2u",
               "WET",
               "Gi\u1edd M\u00f9a h\u00e8 T\u00e2y \u00c2u",
               "WEST",
               "Gi\u1edd T\u00e2y \u00c2u",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Gi\u1edd Chu\u1ea9n Cape Verde",
               "CVT",
               "Gi\u1edd M\u00f9a H\u00e8 Cape Verde",
               "CVST",
               "Gi\u1edd Cape Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Gi\u1edd \u0111\u1ea3o Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Gi\u1edd Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Gi\u1edd Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Gi\u1edd Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Gi\u1edd Chu\u1ea9n Samoa",
               "SST",
               "Gi\u1edd ban ng\u00e0y Samoa",
               "SDT",
               "Gi\u1edd Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Gi\u1edd Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Gi\u1edd Ch\u00e2u \u00c2u Vi\u1ec5n \u0110\u00f4ng",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Gi\u1edd Chu\u1ea9n Azerbaijan",
               "AZT",
               "Gi\u1edd M\u00f9a H\u00e8 Azerbaijan",
               "AZST",
               "Gi\u1edd Azerbaijan",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Gi\u1edd Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Gi\u1edd Chu\u1ea9n Th\u00e1i B\u00ecnh D\u01b0\u01a1ng Mexico",
               "MST",
               "Gi\u1edd M\u00f9a H\u00e8 Th\u00e1i B\u00ecnh D\u01b0\u01a1ng Mexico",
               "MDT",
               "Gi\u1edd Th\u00e1i B\u00ecnh D\u01b0\u01a1ng Mexico",
               "MT",
            };
        final String[] Davis = new String[] {
               "Gi\u1edd Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Gi\u1edd Chu\u1ea9n Cuba",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 Cuba",
               "CDT",
               "Gi\u1edd Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n T\u00e2y Phi",
               "CAT",
               "Gi\u1edd M\u00f9a H\u00e8 T\u00e2y Phi",
               "CAST",
               "Gi\u1edd T\u00e2y Phi",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Gi\u1edd Trung b\u00ecnh Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Gi\u1edd Chu\u1ea9n Philippin",
               "PHT",
               "Gi\u1edd M\u00f9a H\u00e8 Philippin",
               "PHST",
               "Gi\u1edd Philippin",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Gi\u1edd Nam C\u1ef1c v\u00e0 Nam N\u01b0\u1edbc Ph\u00e1p",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Gi\u1edd Nam Georgia",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Gi\u1edd Chu\u1ea9n New Caledonia",
               "NCT",
               "Gi\u1edd M\u00f9a H\u00e8 New Caledonia",
               "NCST",
               "Gi\u1edd New Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Gi\u1edd Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Gi\u1edd Chu\u1ea9n Iran",
               "IRST",
               "Gi\u1edd M\u00f9a H\u00e8 Iran",
               "IRDT",
               "Gi\u1edd Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u1ea3o Ph\u1ee5c Sinh",
               "EAST",
               "Gi\u1edd M\u00f9a H\u00e8 \u0110\u1ea3o Ph\u1ee5c Sinh",
               "EASST",
               "Gi\u1edd \u0110\u1ea3o Ph\u1ee5c Sinh",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Gi\u1edd Chu\u1ea9n T\u00e2y B\u1eafc Mexico",
               "PST",
               "Gi\u1edd M\u00f9a H\u00e8 T\u00e2y B\u1eafc Mexico",
               "PDT",
               "Gi\u1edd T\u00e2y B\u1eafc Mexico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Gi\u1edd Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Gi\u1edd Tajikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Gi\u1edd Chu\u1ea9n Tonga",
               "TOT",
               "Gi\u1edd M\u00f9a H\u00e8 Tonga",
               "TOST",
               "Gi\u1edd Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Gi\u1edd Chu\u1ea9n Bangladesh",
               "BDT",
               "Gi\u1edd M\u00f9a H\u00e8 Bangladesh",
               "BDST",
               "Gi\u1edd Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Gi\u1edd Chu\u1ea9n Peru",
               "PET",
               "Gi\u1edd M\u00f9a H\u00e8 Peru",
               "PEST",
               "Gi\u1edd Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n T\u00e2y Greenland",
               "WGT",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n T\u00e2y Greenland",
               "WGST",
               "Gi\u1edd Mi\u1ec1n T\u00e2y Greenland",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Gi\u1edd Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n \u0110\u00f4ng Greenland",
               "EGT",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n \u0110\u00f4ng Greenland",
               "EGST",
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Greenland",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Gi\u1edd Chu\u1ea9n V\u00f9ng V\u1ecbnh",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Indonesia",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Gi\u1edd Chu\u1ea9n H\u00e0n Qu\u1ed1c",
               "KST",
               "Gi\u1edd M\u00f9a H\u00e8 H\u00e0n Qu\u1ed1c",
               "KDT",
               "Gi\u1edd H\u00e0n Qu\u1ed1c",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n T\u00e2y N\u01b0\u1edbc \u00dac",
               "AWST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n T\u00e2y N\u01b0\u1edbc \u00dac",
               "AWDT",
               "Gi\u1edd Mi\u1ec1n T\u00e2y N\u01b0\u1edbc \u00dac",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Gi\u1edd Kyrgystan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Gi\u1edd Mi\u1ec1n T\u00e2y Indonesia",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n \u0110\u00f4ng N\u01b0\u1edbc \u00dac",
               "AEST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n \u0110\u00f4ng N\u01b0\u1edbc \u00dac",
               "AEDT",
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng N\u01b0\u1edbc \u00dac",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Gi\u1edd Guiana thu\u1ed9c Ph\u00e1p",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Gi\u1edd Chu\u1ea9n Colombia",
               "COT",
               "Gi\u1edd M\u00f9a H\u00e8 Colombia",
               "COST",
               "Gi\u1edd Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Gi\u1edd Chu\u1ea9n Chile",
               "CLT",
               "Gi\u1edd M\u00f9a H\u00e8 Chile",
               "CLST",
               "Gi\u1edd Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n n\u00fai",
               "MST",
               "Gi\u1edd ban ng\u00e0y mi\u1ec1n n\u00fai",
               "MDT",
               "Gi\u1edd mi\u1ec1n n\u00fai",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Gi\u1edd Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Gi\u1edd chu\u1ea9n \u1ea2 R\u1eadp",
               "AST",
               "Gi\u1edd M\u00f9a H\u00e8 \u1ea2 R\u1eadp",
               "ADT",
               "Gi\u1edd \u1ea2 R\u1eadp",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Gi\u1edd Chu\u1ea9n Alaska",
               "AKST",
               "Gi\u1edd M\u00f9a H\u00e8 Alaska",
               "AKDT",
               "Gi\u1edd Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Gi\u1edd Chu\u1ea9n Vladivostok",
               "VLAT",
               "Gi\u1edd m\u00f9a h\u00e8 Vladivostok",
               "VLAST",
               "Gi\u1edd Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Gi\u1edd Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Irkutsk",
               "IRKT",
               "Gi\u1edd M\u00f9a H\u00e8 Irkutsk",
               "IRKST",
               "Gi\u1edd Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Gi\u1edd Chu\u1ea9n Georgia",
               "GET",
               "Gi\u1edd M\u00f9a H\u00e8 Georgia",
               "GEST",
               "Gi\u1edd Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Gi\u1edd Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Gi\u1edd Papua New Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Gi\u1edd Chu\u1ea9n Fernando de Noronha",
               "FNT",
               "Gi\u1edd M\u00f9a H\u00e8 Fernando de Noronha",
               "FNST",
               "Gi\u1edd Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Gi\u1edd Chu\u1ea9n Choibalsan",
               "CHOT",
               "Gi\u1edd M\u00f9a H\u00e8 Choibalsan",
               "CHOST",
               "Gi\u1edd Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Gi\u1edd Chu\u1ea9n Brasilia",
               "BRT",
               "Gi\u1edd M\u00f9a H\u00e8 Brasilia",
               "BRST",
               "Gi\u1edd Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Gi\u1edd Chu\u1ea9n Trung Qu\u1ed1c",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 Trung Qu\u1ed1c",
               "CDT",
               "Gi\u1edd Trung Qu\u1ed1c",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Gi\u1edd Chu\u1ea9n Armenia",
               "AMT",
               "Gi\u1edd M\u00f9a H\u00e8 Armenia",
               "AMST",
               "Gi\u1edd Armenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Gi\u1edd Chu\u1ea9n Samara",
               "SAMT",
               "Gi\u1edd m\u00f9a h\u00e8 Samara",
               "SAMST",
               "Gi\u1edd Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Gi\u1edd Chu\u1ea9n \u1ea4n \u0110\u1ed9",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Gi\u1edd Chu\u1ea9n Qu\u1ea7n \u0110\u1ea3o Cook",
               "CKT",
               "Gi\u1edd N\u1eeda M\u00f9a H\u00e8 Qu\u1ea7n \u0110\u1ea3o Cook",
               "CKHST",
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Gi\u1edd Trung b\u00ecnh Greenwich",
                    "GMT",
                    "Gi\u1edd M\u00f9a H\u00e8 Anh",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Gi\u1edd Trung b\u00ecnh Greenwich",
                    "GMT",
                    "Gi\u1edd chu\u1ea9n Ai-len",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
