/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

public final class AtomicDetailsProvider
extends DetailsProvider.Basic {
    private static final String BOOLEAN_MASK = "java.util.concurrent.atomic.AtomicBoolean+";
    private static final String INTEGER_MASK = "java.util.concurrent.atomic.AtomicInteger+";
    private static final String LONG_MASK = "java.util.concurrent.atomic.AtomicLong+";
    private static final String REFERENCE_MASK = "java.util.concurrent.atomic.AtomicReference+";

    public AtomicDetailsProvider() {
        super(BOOLEAN_MASK, INTEGER_MASK, LONG_MASK, REFERENCE_MASK);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        Object object;
        if (BOOLEAN_MASK.equals(string)) {
            int n = DetailsUtils.getIntFieldValue(instance, "value", 0);
            return Boolean.toString(n != 0);
        }
        if (INTEGER_MASK.equals(string)) {
            int n = DetailsUtils.getIntFieldValue(instance, "value", 0);
            return Integer.toString(n);
        }
        if (LONG_MASK.equals(string)) {
            long l = DetailsUtils.getLongFieldValue(instance, "value", 0L);
            return Long.toString(l);
        }
        if (REFERENCE_MASK.equals(string) && (object = instance.getValueOfField("value")) instanceof Instance) {
            Instance instance2 = (Instance)object;
            String string2 = DetailsUtils.getInstanceString(instance2, heap);
            string2 = string2 == null ? "#" + instance2.getInstanceNumber() : ": " + string2;
            return BrowserUtils.getSimpleType(instance2.getJavaClass().getName()) + string2;
        }
        return null;
    }
}

