/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegexpValidator
implements Validator<String> {
    private final Pattern pattern;
    private final String message;
    private boolean acceptPartialMatches;

    RegexpValidator(String pattern, String message, boolean acceptPartialMatches) {
        this.pattern = Pattern.compile(pattern);
        this.message = message;
        this.acceptPartialMatches = acceptPartialMatches;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        boolean result;
        Matcher m = this.pattern.matcher(model);
        boolean bl = result = this.acceptPartialMatches ? m.lookingAt() : m.matches();
        if (!result) {
            String prb = this.message;
            prb = MessageFormat.format(prb, compName, model);
            problems.add(prb);
        }
        return result;
    }
}

